
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&#13;
 *                     Selects the SVG syntax used for formatting graphics states.&#13;
 *                     &lt;ul&gt;&lt;li&gt;verbose = Writes verbose graphics states and groups and always prefers direct path definitions.&lt;/li&gt;&lt;li&gt;centralize = Writes compact graphics states and groups and centralizes formatting instructions, also utilizes the "use" syntax to prepare and reference indirect paths. (May not be readable by some SVG viewers.)&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for SvgGraphicsStateModeType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="SvgGraphicsStateModeType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="verbose"/>
 *     <enumeration value="centralize"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "SvgGraphicsStateModeType")
@XmlEnum
public enum SvgGraphicsStateModeType {

    @XmlEnumValue("verbose")
    VERBOSE("verbose"),
    @XmlEnumValue("centralize")
    CENTRALIZE("centralize");
    private final String value;

    SvgGraphicsStateModeType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static SvgGraphicsStateModeType fromValue(String v) {
        for (SvgGraphicsStateModeType c: SvgGraphicsStateModeType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
