
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects parameters for the creation of SVGs, possibly contained in resulting documents.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for SvgFormatType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="SvgFormatType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="decimalPrecision" default="2">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *             <maxInclusive value="10"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="graphicsStateMode" default="centralize">
 *         <simpleType>
 *           <restriction base="{http://schema.webpdf.de/1.0/operation}SvgGraphicsStateModeType">
 *             <enumeration value="verbose"/>
 *             <enumeration value="centralize"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="pathDrawMode" default="compact">
 *         <simpleType>
 *           <restriction base="{http://schema.webpdf.de/1.0/operation}SvgPathDrawModeType">
 *             <enumeration value="verbose"/>
 *             <enumeration value="compact"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SvgFormatType")
public class SvgFormatType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the number of decimal places for numeric values of contained SVGs.&lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                         The number of decimal places directly influences the size of the resulting file. (should SVGs be contained.) However: Higher values will result in a better SVG quality.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "decimalPrecision")
    protected Integer decimalPrecision;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&#13;
     *                         Selects the SVG syntax used for formatting graphics states.&#13;
     *                         &lt;ul&gt;&lt;li&gt;verbose = Writes verbose graphics states and groups and always prefers direct path definitions.&lt;/li&gt;&lt;li&gt;compact = Writes compact graphics states and groups and centralizes formatting instructions, also utilizes the "use" syntax to prepare and reference indirect paths. (May not be readable by some SVG viewers.)&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "graphicsStateMode")
    protected SvgGraphicsStateModeType graphicsStateMode;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&#13;
     *                         Selects the SVG syntax used for formatting graphics states.&#13;
     *                         &lt;ul&gt;&lt;li&gt;verbose = Writes verbose paths, containing a human readable complete and simple syntax.&lt;/li&gt;&lt;li&gt;compress = Compresses path draw instructions, by applying the EBNF (Extended Backus Naur Form).&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "pathDrawMode")
    protected SvgPathDrawModeType pathDrawMode;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the number of decimal places for numeric values of contained SVGs.&lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                         The number of decimal places directly influences the size of the resulting file. (should SVGs be contained.) However: Higher values will result in a better SVG quality.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getDecimalPrecision() {
        if (decimalPrecision == null) {
            return  2;
        } else {
            return decimalPrecision;
        }
    }

    /**
     * Sets the value of the decimalPrecision property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getDecimalPrecision()
     */
    public void setDecimalPrecision(int value) {
        this.decimalPrecision = value;
    }

    public boolean isSetDecimalPrecision() {
        return (this.decimalPrecision!= null);
    }

    public void unsetDecimalPrecision() {
        this.decimalPrecision = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&#13;
     *                         Selects the SVG syntax used for formatting graphics states.&#13;
     *                         &lt;ul&gt;&lt;li&gt;verbose = Writes verbose graphics states and groups and always prefers direct path definitions.&lt;/li&gt;&lt;li&gt;compact = Writes compact graphics states and groups and centralizes formatting instructions, also utilizes the "use" syntax to prepare and reference indirect paths. (May not be readable by some SVG viewers.)&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link SvgGraphicsStateModeType }
     *     
     */
    public SvgGraphicsStateModeType getGraphicsStateMode() {
        if (graphicsStateMode == null) {
            return SvgGraphicsStateModeType.CENTRALIZE;
        } else {
            return graphicsStateMode;
        }
    }

    /**
     * Sets the value of the graphicsStateMode property.
     * 
     * @param value
     *     allowed object is
     *     {@link SvgGraphicsStateModeType }
     *     
     * @see #getGraphicsStateMode()
     */
    public void setGraphicsStateMode(SvgGraphicsStateModeType value) {
        this.graphicsStateMode = value;
    }

    public boolean isSetGraphicsStateMode() {
        return (this.graphicsStateMode!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&#13;
     *                         Selects the SVG syntax used for formatting graphics states.&#13;
     *                         &lt;ul&gt;&lt;li&gt;verbose = Writes verbose paths, containing a human readable complete and simple syntax.&lt;/li&gt;&lt;li&gt;compress = Compresses path draw instructions, by applying the EBNF (Extended Backus Naur Form).&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link SvgPathDrawModeType }
     *     
     */
    public SvgPathDrawModeType getPathDrawMode() {
        if (pathDrawMode == null) {
            return SvgPathDrawModeType.COMPACT;
        } else {
            return pathDrawMode;
        }
    }

    /**
     * Sets the value of the pathDrawMode property.
     * 
     * @param value
     *     allowed object is
     *     {@link SvgPathDrawModeType }
     *     
     * @see #getPathDrawMode()
     */
    public void setPathDrawMode(SvgPathDrawModeType value) {
        this.pathDrawMode = value;
    }

    public boolean isSetPathDrawMode() {
        return (this.pathDrawMode!= null);
    }

}
