
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p259448_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p756858_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the elements that are part of the visual signature.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for SignatureIdentifierType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="SignatureIdentifierType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="showSignedBy" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="showName" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="showCommonName" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="showOrganisationUnit" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="showOrganisationName" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="showLocal" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="showState" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="showCountry" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="showMail" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="showDate" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="textSignedBy" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SignatureIdentifierType")
public class SignatureIdentifierType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p259448_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p756858_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Displays or hides the text &lt;code&gt;Digitally signed by&lt;/code&gt;. Can be overridden by the value of &lt;code&gt;textSignedBy&lt;/code&gt;.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "showSignedBy")
    protected Boolean showSignedBy;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p259448_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p756858_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Displays or hides the signature &lt;code&gt;name&lt;/code&gt;.&#13;
     *                         (If &lt;code&gt;name&lt;/code&gt; has not been set, the common name (CN) part of the certificate is displayed instead.)&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "showName")
    protected Boolean showName;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p259448_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p756858_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Displays or hides the common name (CN) part of the certificate.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "showCommonName")
    protected Boolean showCommonName;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p259448_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p756858_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Displays or hides the certificate owner's suborganization/department (OU).&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "showOrganisationUnit")
    protected Boolean showOrganisationUnit;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p259448_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p756858_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Displays or hides the certificate holder's organization/company (O).&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "showOrganisationName")
    protected Boolean showOrganisationName;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p259448_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p756858_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Displays or hides the location/city (L) where the certificate holder is located.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "showLocal")
    protected Boolean showLocal;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p259448_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p756858_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Displays or hides the state (S) in which the certificate holder is located.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "showState")
    protected Boolean showState;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p259448_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p756858_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Displays or hides the (ISO valid) country code (C) of the country in which the certificate holder is located.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "showCountry")
    protected Boolean showCountry;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p259448_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p756858_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Displays or hides the email address (E) at which the certificate holder can be contacted.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "showMail")
    protected Boolean showMail;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p259448_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p756858_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Displays or hides the signature time.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "showDate")
    protected Boolean showDate;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p259448_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p756858_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Text that is displayed when the &lt;code&gt;showSignedBy&lt;/code&gt; option is enabled. If not set, then the text &lt;code&gt;Digitally signed by&lt;/code&gt; is used as default.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "textSignedBy")
    protected String textSignedBy;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p259448_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p756858_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Displays or hides the text &lt;code&gt;Digitally signed by&lt;/code&gt;. Can be overridden by the value of &lt;code&gt;textSignedBy&lt;/code&gt;.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isShowSignedBy() {
        if (showSignedBy == null) {
            return true;
        } else {
            return showSignedBy;
        }
    }

    /**
     * Sets the value of the showSignedBy property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isShowSignedBy()
     */
    public void setShowSignedBy(boolean value) {
        this.showSignedBy = value;
    }

    public boolean isSetShowSignedBy() {
        return (this.showSignedBy!= null);
    }

    public void unsetShowSignedBy() {
        this.showSignedBy = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p259448_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p756858_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Displays or hides the signature &lt;code&gt;name&lt;/code&gt;.&#13;
     *                         (If &lt;code&gt;name&lt;/code&gt; has not been set, the common name (CN) part of the certificate is displayed instead.)&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isShowName() {
        if (showName == null) {
            return true;
        } else {
            return showName;
        }
    }

    /**
     * Sets the value of the showName property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isShowName()
     */
    public void setShowName(boolean value) {
        this.showName = value;
    }

    public boolean isSetShowName() {
        return (this.showName!= null);
    }

    public void unsetShowName() {
        this.showName = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p259448_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p756858_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Displays or hides the common name (CN) part of the certificate.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isShowCommonName() {
        if (showCommonName == null) {
            return true;
        } else {
            return showCommonName;
        }
    }

    /**
     * Sets the value of the showCommonName property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isShowCommonName()
     */
    public void setShowCommonName(boolean value) {
        this.showCommonName = value;
    }

    public boolean isSetShowCommonName() {
        return (this.showCommonName!= null);
    }

    public void unsetShowCommonName() {
        this.showCommonName = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p259448_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p756858_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Displays or hides the certificate owner's suborganization/department (OU).&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isShowOrganisationUnit() {
        if (showOrganisationUnit == null) {
            return true;
        } else {
            return showOrganisationUnit;
        }
    }

    /**
     * Sets the value of the showOrganisationUnit property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isShowOrganisationUnit()
     */
    public void setShowOrganisationUnit(boolean value) {
        this.showOrganisationUnit = value;
    }

    public boolean isSetShowOrganisationUnit() {
        return (this.showOrganisationUnit!= null);
    }

    public void unsetShowOrganisationUnit() {
        this.showOrganisationUnit = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p259448_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p756858_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Displays or hides the certificate holder's organization/company (O).&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isShowOrganisationName() {
        if (showOrganisationName == null) {
            return true;
        } else {
            return showOrganisationName;
        }
    }

    /**
     * Sets the value of the showOrganisationName property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isShowOrganisationName()
     */
    public void setShowOrganisationName(boolean value) {
        this.showOrganisationName = value;
    }

    public boolean isSetShowOrganisationName() {
        return (this.showOrganisationName!= null);
    }

    public void unsetShowOrganisationName() {
        this.showOrganisationName = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p259448_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p756858_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Displays or hides the location/city (L) where the certificate holder is located.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isShowLocal() {
        if (showLocal == null) {
            return true;
        } else {
            return showLocal;
        }
    }

    /**
     * Sets the value of the showLocal property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isShowLocal()
     */
    public void setShowLocal(boolean value) {
        this.showLocal = value;
    }

    public boolean isSetShowLocal() {
        return (this.showLocal!= null);
    }

    public void unsetShowLocal() {
        this.showLocal = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p259448_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p756858_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Displays or hides the state (S) in which the certificate holder is located.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isShowState() {
        if (showState == null) {
            return true;
        } else {
            return showState;
        }
    }

    /**
     * Sets the value of the showState property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isShowState()
     */
    public void setShowState(boolean value) {
        this.showState = value;
    }

    public boolean isSetShowState() {
        return (this.showState!= null);
    }

    public void unsetShowState() {
        this.showState = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p259448_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p756858_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Displays or hides the (ISO valid) country code (C) of the country in which the certificate holder is located.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isShowCountry() {
        if (showCountry == null) {
            return true;
        } else {
            return showCountry;
        }
    }

    /**
     * Sets the value of the showCountry property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isShowCountry()
     */
    public void setShowCountry(boolean value) {
        this.showCountry = value;
    }

    public boolean isSetShowCountry() {
        return (this.showCountry!= null);
    }

    public void unsetShowCountry() {
        this.showCountry = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p259448_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p756858_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Displays or hides the email address (E) at which the certificate holder can be contacted.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isShowMail() {
        if (showMail == null) {
            return true;
        } else {
            return showMail;
        }
    }

    /**
     * Sets the value of the showMail property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isShowMail()
     */
    public void setShowMail(boolean value) {
        this.showMail = value;
    }

    public boolean isSetShowMail() {
        return (this.showMail!= null);
    }

    public void unsetShowMail() {
        this.showMail = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p259448_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p756858_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Displays or hides the signature time.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isShowDate() {
        if (showDate == null) {
            return true;
        } else {
            return showDate;
        }
    }

    /**
     * Sets the value of the showDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isShowDate()
     */
    public void setShowDate(boolean value) {
        this.showDate = value;
    }

    public boolean isSetShowDate() {
        return (this.showDate!= null);
    }

    public void unsetShowDate() {
        this.showDate = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p259448_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p756858_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Text that is displayed when the &lt;code&gt;showSignedBy&lt;/code&gt; option is enabled. If not set, then the text &lt;code&gt;Digitally signed by&lt;/code&gt; is used as default.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTextSignedBy() {
        if (textSignedBy == null) {
            return "";
        } else {
            return textSignedBy;
        }
    }

    /**
     * Sets the value of the textSignedBy property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getTextSignedBy()
     */
    public void setTextSignedBy(String value) {
        this.textSignedBy = value;
    }

    public boolean isSetTextSignedBy() {
        return (this.textSignedBy!= null);
    }

}
