
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to configure global settings that should be respected when running the web service operation. This concerns e.g. settings whether the execution of the operation is allowed within the scope of the PDF document settings or how the result of the operation should be handled.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for SettingsType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="SettingsType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <all>
 *         <element name="signature" type="{http://schema.webpdf.de/1.0/operation}SignatureSettingsType" minOccurs="0"/>
 *         <element name="compress" minOccurs="0">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <all>
 *                   <element name="compressObjects" type="{http://schema.webpdf.de/1.0/operation}CompressObjectsType" minOccurs="0"/>
 *                 </all>
 *                 <attribute name="compressProfile" type="{http://schema.webpdf.de/1.0/operation}CompressProfileType" default="never" />
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *         <element name="pdfa" type="{http://schema.webpdf.de/1.0/operation}PdfaSettingsType" minOccurs="0"/>
 *         <element name="http" type="{http://schema.webpdf.de/1.0/operation}HttpSettingsType" minOccurs="0"/>
 *       </all>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SettingsType", propOrder = {

})
public class SettingsType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The &lt;code&gt;signature&lt;/code&gt; element allows to make settings for automatic handling of digital signatures. The web service operation checks whether it´s execution is valid for a given signed document according to the settings or whether invalidation of the existing signatures is allowed. Thus, the settings allow for intentional invalidation of signatures.&#13;
     *                         &lt;/p&gt;
     * </pre>
     * 
     */
    protected SignatureSettingsType signature;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The &lt;code&gt;compress&lt;/code&gt; element can be used to automatically compress the contents of the PDF document when saving it. Whenever the web service operation saves the PDF document, it should try to compress it according to the settings specified here. Document compression can also be triggered specifically via the 'compress' web service instead.&#13;
     *                         &lt;/p&gt;
     * </pre>
     * 
     */
    protected SettingsType.Compress compress;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&#13;
     *                             The &lt;code&gt;pdfa&lt;/code&gt; element allows to make settings for automatic handling of PDF/A documents. The web service operation checks whether it´s execution is valid for a given PDF/A document according to the settings.&#13;
     *                         &lt;/p&gt;
     * </pre>
     * 
     */
    protected PdfaSettingsType pdfa;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The &lt;code&gt;http&lt;/code&gt; element allows to define the options for all external HTTP requests made by the server during the execution of the web service operation.&#13;
     *                         &lt;/p&gt;
     * </pre>
     * 
     */
    protected HttpSettingsType http;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The &lt;code&gt;signature&lt;/code&gt; element allows to make settings for automatic handling of digital signatures. The web service operation checks whether it´s execution is valid for a given signed document according to the settings or whether invalidation of the existing signatures is allowed. Thus, the settings allow for intentional invalidation of signatures.&#13;
     *                         &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link SignatureSettingsType }
     *     
     */
    public SignatureSettingsType getSignature() {
        return signature;
    }

    /**
     * Sets the value of the signature property.
     * 
     * @param value
     *     allowed object is
     *     {@link SignatureSettingsType }
     *     
     * @see #getSignature()
     */
    public void setSignature(SignatureSettingsType value) {
        this.signature = value;
    }

    public boolean isSetSignature() {
        return (this.signature!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The &lt;code&gt;compress&lt;/code&gt; element can be used to automatically compress the contents of the PDF document when saving it. Whenever the web service operation saves the PDF document, it should try to compress it according to the settings specified here. Document compression can also be triggered specifically via the 'compress' web service instead.&#13;
     *                         &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link SettingsType.Compress }
     *     
     */
    public SettingsType.Compress getCompress() {
        return compress;
    }

    /**
     * Sets the value of the compress property.
     * 
     * @param value
     *     allowed object is
     *     {@link SettingsType.Compress }
     *     
     * @see #getCompress()
     */
    public void setCompress(SettingsType.Compress value) {
        this.compress = value;
    }

    public boolean isSetCompress() {
        return (this.compress!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&#13;
     *                             The &lt;code&gt;pdfa&lt;/code&gt; element allows to make settings for automatic handling of PDF/A documents. The web service operation checks whether it´s execution is valid for a given PDF/A document according to the settings.&#13;
     *                         &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link PdfaSettingsType }
     *     
     */
    public PdfaSettingsType getPdfa() {
        return pdfa;
    }

    /**
     * Sets the value of the pdfa property.
     * 
     * @param value
     *     allowed object is
     *     {@link PdfaSettingsType }
     *     
     * @see #getPdfa()
     */
    public void setPdfa(PdfaSettingsType value) {
        this.pdfa = value;
    }

    public boolean isSetPdfa() {
        return (this.pdfa!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The &lt;code&gt;http&lt;/code&gt; element allows to define the options for all external HTTP requests made by the server during the execution of the web service operation.&#13;
     *                         &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link HttpSettingsType }
     *     
     */
    public HttpSettingsType getHttp() {
        return http;
    }

    /**
     * Sets the value of the http property.
     * 
     * @param value
     *     allowed object is
     *     {@link HttpSettingsType }
     *     
     * @see #getHttp()
     */
    public void setHttp(HttpSettingsType value) {
        this.http = value;
    }

    public boolean isSetHttp() {
        return (this.http!= null);
    }


    /**
     * <p>Java class for anonymous complex type</p>.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.</p>
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <all>
     *         <element name="compressObjects" type="{http://schema.webpdf.de/1.0/operation}CompressObjectsType" minOccurs="0"/>
     *       </all>
     *       <attribute name="compressProfile" type="{http://schema.webpdf.de/1.0/operation}CompressProfileType" default="never" />
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {

    })
    public static class Compress {

        protected CompressObjectsType compressObjects;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Sets the profile for automatic document compression and thus defines whether compression should be applied when saving.&#13;
         *                                     &lt;ul&gt;&lt;li&gt;always = PDF documents should always be compressed when saved.&lt;/li&gt;&lt;li&gt;never = PDF documents should not be automatically compressed.&lt;/li&gt;&lt;li&gt;recompress = PDF documents should only be compressed automatically if they were already compressed before.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "compressProfile")
        protected CompressProfileType compressProfile;

        /**
         * Gets the value of the compressObjects property.
         * 
         * @return
         *     possible object is
         *     {@link CompressObjectsType }
         *     
         */
        public CompressObjectsType getCompressObjects() {
            return compressObjects;
        }

        /**
         * Sets the value of the compressObjects property.
         * 
         * @param value
         *     allowed object is
         *     {@link CompressObjectsType }
         *     
         */
        public void setCompressObjects(CompressObjectsType value) {
            this.compressObjects = value;
        }

        public boolean isSetCompressObjects() {
            return (this.compressObjects!= null);
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Sets the profile for automatic document compression and thus defines whether compression should be applied when saving.&#13;
         *                                     &lt;ul&gt;&lt;li&gt;always = PDF documents should always be compressed when saved.&lt;/li&gt;&lt;li&gt;never = PDF documents should not be automatically compressed.&lt;/li&gt;&lt;li&gt;recompress = PDF documents should only be compressed automatically if they were already compressed before.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link CompressProfileType }
         *     
         */
        public CompressProfileType getCompressProfile() {
            if (compressProfile == null) {
                return CompressProfileType.NEVER;
            } else {
                return compressProfile;
            }
        }

        /**
         * Sets the value of the compressProfile property.
         * 
         * @param value
         *     allowed object is
         *     {@link CompressProfileType }
         *     
         * @see #getCompressProfile()
         */
        public void setCompressProfile(CompressProfileType value) {
            this.compressProfile = value;
        }

        public boolean isSetCompressProfile() {
            return (this.compressProfile!= null);
        }

    }

}
