
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects a specific box of a given page range of a PDF document.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for SelectionBoxType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="SelectionBoxType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="pages" type="{http://www.w3.org/2001/XMLSchema}string" default="*" />
 *       <attribute name="box" type="{http://schema.webpdf.de/1.0/operation}PageBoxType" default="crop_box" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SelectionBoxType")
public class SelectionBoxType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the page(s) from which boxes should be removed. The page number can be an individual page, a page range, or a list (separated with commas) (e.g., "1,5-6,9"). To specify "all pages," use an asterisk ("*").&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "pages")
    protected String pages;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the box to remove.&#13;
     *                         &lt;ul&gt;&lt;li&gt;crop_box = The visible (printable) page area.&lt;/li&gt;&lt;li&gt;bleed_box = Untrimmed content position on the page (content dimensions plus trim box).&lt;/li&gt;&lt;li&gt;trim_box = Trimmed content position on the page (final content dimensions).&lt;/li&gt;&lt;li&gt;art_box = Position for special page content (images).&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "box")
    protected PageBoxType box;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the page(s) from which boxes should be removed. The page number can be an individual page, a page range, or a list (separated with commas) (e.g., "1,5-6,9"). To specify "all pages," use an asterisk ("*").&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPages() {
        if (pages == null) {
            return "*";
        } else {
            return pages;
        }
    }

    /**
     * Sets the value of the pages property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getPages()
     */
    public void setPages(String value) {
        this.pages = value;
    }

    public boolean isSetPages() {
        return (this.pages!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the box to remove.&#13;
     *                         &lt;ul&gt;&lt;li&gt;crop_box = The visible (printable) page area.&lt;/li&gt;&lt;li&gt;bleed_box = Untrimmed content position on the page (content dimensions plus trim box).&lt;/li&gt;&lt;li&gt;trim_box = Trimmed content position on the page (final content dimensions).&lt;/li&gt;&lt;li&gt;art_box = Position for special page content (images).&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link PageBoxType }
     *     
     */
    public PageBoxType getBox() {
        if (box == null) {
            return PageBoxType.CROP_BOX;
        } else {
            return box;
        }
    }

    /**
     * Sets the value of the box property.
     * 
     * @param value
     *     allowed object is
     *     {@link PageBoxType }
     *     
     * @see #getBox()
     */
    public void setBox(PageBoxType value) {
        this.box = value;
    }

    public boolean isSetBox() {
        return (this.box!= null);
    }

}
