
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p23729_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p441386_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p50928_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines criteria for the selection of annotations.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for SelectionAnnotationType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="SelectionAnnotationType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <choice>
 *         <element name="objectKey">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <attribute name="id" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *         <element name="position" type="{http://schema.webpdf.de/1.0/operation}RectangleType"/>
 *       </choice>
 *       <attribute name="page" default="1">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="1"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SelectionAnnotationType", propOrder = {
    "objectKey",
    "position"
})
public class SelectionAnnotationType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p23729_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p441386_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p50928_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the annotation by object ID.&lt;/p&gt;
     * </pre>
     * 
     */
    protected SelectionAnnotationType.ObjectKey objectKey;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p23729_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p441386_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p50928_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects all annotations in the given area.&lt;/p&gt;
     * </pre>
     * 
     */
    protected RectangleType position;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p23729_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p441386_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p50928_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the page by page number, that shall contain the annotation.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "page")
    protected Integer page;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p23729_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p441386_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p50928_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the annotation by object ID.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link SelectionAnnotationType.ObjectKey }
     *     
     */
    public SelectionAnnotationType.ObjectKey getObjectKey() {
        return objectKey;
    }

    /**
     * Sets the value of the objectKey property.
     * 
     * @param value
     *     allowed object is
     *     {@link SelectionAnnotationType.ObjectKey }
     *     
     * @see #getObjectKey()
     */
    public void setObjectKey(SelectionAnnotationType.ObjectKey value) {
        this.objectKey = value;
    }

    public boolean isSetObjectKey() {
        return (this.objectKey!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p23729_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p441386_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p50928_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects all annotations in the given area.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link RectangleType }
     *     
     */
    public RectangleType getPosition() {
        return position;
    }

    /**
     * Sets the value of the position property.
     * 
     * @param value
     *     allowed object is
     *     {@link RectangleType }
     *     
     * @see #getPosition()
     */
    public void setPosition(RectangleType value) {
        this.position = value;
    }

    public boolean isSetPosition() {
        return (this.position!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p23729_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p441386_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p50928_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the page by page number, that shall contain the annotation.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getPage() {
        if (page == null) {
            return  1;
        } else {
            return page;
        }
    }

    /**
     * Sets the value of the page property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getPage()
     */
    public void setPage(int value) {
        this.page = value;
    }

    public boolean isSetPage() {
        return (this.page!= null);
    }

    public void unsetPage() {
        this.page = null;
    }


    /**
     * <p>Java class for anonymous complex type</p>.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.</p>
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <attribute name="id" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "")
    public static class ObjectKey {

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p23729_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p441386_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p50928_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The object id shall be given as a String that may contain either:&#13;
         *                                     &lt;ul&gt;&lt;li&gt;The numeric object ID itself&lt;/li&gt;&lt;li&gt;The object ID followed by the generation number, separated by a space&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "id")
        protected String id;

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p23729_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p441386_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p50928_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The object id shall be given as a String that may contain either:&#13;
         *                                     &lt;ul&gt;&lt;li&gt;The numeric object ID itself&lt;/li&gt;&lt;li&gt;The object ID followed by the generation number, separated by a space&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getId() {
            if (id == null) {
                return "";
            } else {
                return id;
            }
        }

        /**
         * Sets the value of the id property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         * @see #getId()
         */
        public void setId(String value) {
            this.id = value;
        }

        public boolean isSetId() {
            return (this.id!= null);
        }

    }

}
