
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p343700_="https://jakarta.ee/xml/ns/jaxb" xmlns:p472644_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p752341_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The border style for separators in between the different parts of the barcode.&#13;
 *                     &lt;ul&gt;&lt;li&gt;none = No separator shall be used.&lt;/li&gt;&lt;li&gt;solidLine = A solid separator line.&lt;/li&gt;&lt;li&gt;solidLineWithScissors = A solid separator line with a scissor icon.&lt;/li&gt;&lt;li&gt;dashedLine = A dashed separator line.&lt;/li&gt;&lt;li&gt;dashedLineWithScissors = A dashed separator line with a scissor icon.&lt;/li&gt;&lt;li&gt;dottedLine = A dotted separator line.&lt;/li&gt;&lt;li&gt;dottedLineWithScissors = A dotted separator line with a scissor icon.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for QrSwissPaymentSeparatorType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="QrSwissPaymentSeparatorType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="none"/>
 *     <enumeration value="solidLine"/>
 *     <enumeration value="solidLineWithScissors"/>
 *     <enumeration value="dashedLine"/>
 *     <enumeration value="dashedLineWithScissors"/>
 *     <enumeration value="dottedLine"/>
 *     <enumeration value="dottedLineWithScissors"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "QrSwissPaymentSeparatorType")
@XmlEnum
public enum QrSwissPaymentSeparatorType {

    @XmlEnumValue("none")
    NONE("none"),
    @XmlEnumValue("solidLine")
    SOLID_LINE("solidLine"),
    @XmlEnumValue("solidLineWithScissors")
    SOLID_LINE_WITH_SCISSORS("solidLineWithScissors"),
    @XmlEnumValue("dashedLine")
    DASHED_LINE("dashedLine"),
    @XmlEnumValue("dashedLineWithScissors")
    DASHED_LINE_WITH_SCISSORS("dashedLineWithScissors"),
    @XmlEnumValue("dottedLine")
    DOTTED_LINE("dottedLine"),
    @XmlEnumValue("dottedLineWithScissors")
    DOTTED_LINE_WITH_SCISSORS("dottedLineWithScissors");
    private final String value;

    QrSwissPaymentSeparatorType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static QrSwissPaymentSeparatorType fromValue(String v) {
        for (QrSwissPaymentSeparatorType c: QrSwissPaymentSeparatorType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
