
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p343700_="https://jakarta.ee/xml/ns/jaxb" xmlns:p472644_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p752341_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to adjust the error correction level for generated QR codes. The higher the level, the more error-resistant the barcode, ensuring that damaged codes will still be readable.&#13;
 *                     &lt;ul&gt;&lt;li&gt;l = Low&lt;/li&gt;&lt;li&gt;m = Medium&lt;/li&gt;&lt;li&gt;q = Quartile&lt;/li&gt;&lt;li&gt;h = High&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for QrCodeErrorCorrectionType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="QrCodeErrorCorrectionType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="l"/>
 *     <enumeration value="m"/>
 *     <enumeration value="q"/>
 *     <enumeration value="h"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "QrCodeErrorCorrectionType")
@XmlEnum
public enum QrCodeErrorCorrectionType {

    @XmlEnumValue("l")
    L("l"),
    @XmlEnumValue("m")
    M("m"),
    @XmlEnumValue("q")
    Q("q"),
    @XmlEnumValue("h")
    H("h");
    private final String value;

    QrCodeErrorCorrectionType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static QrCodeErrorCorrectionType fromValue(String v) {
        for (QrCodeErrorCorrectionType c: QrCodeErrorCorrectionType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
