
package net.webpdf.wsclient.schema.operation;

import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p186898_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p243_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p722845_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Extracts one or more documents from the portfolio. The result will be returned as a ZIP document. The ZIP document will not only contain the extracted files, but will also reproduce the folder structure in which the documents were found.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for PortfolioExtractType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="PortfolioExtractType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <choice maxOccurs="unbounded">
 *         <element name="selection" type="{http://schema.webpdf.de/1.0/operation}PortfolioSelectionType"/>
 *       </choice>
 *       <attribute name="singleFileAsZip" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "PortfolioExtractType", propOrder = {
    "selection"
})
public class PortfolioExtractType {

    protected List<PortfolioSelectionType> selection;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p186898_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p243_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p722845_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The returned attachments will be generated as a ZIP file even if selection is used to select only one single file. You can change this behaviour by setting this option to "false". In this case, the file will not be zipped, and will instead be returned directly as is. However, this will only work if selection has been used to select one file and one file only.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "singleFileAsZip")
    protected Boolean singleFileAsZip;

    /**
     * Gets the value of the selection property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the selection property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getSelection().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PortfolioSelectionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the selection property.
     */
    public List<PortfolioSelectionType> getSelection() {
        if (selection == null) {
            selection = new ArrayList<>();
        }
        return this.selection;
    }

    public boolean isSetSelection() {
        return ((this.selection!= null)&&(!this.selection.isEmpty()));
    }

    public void unsetSelection() {
        this.selection = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p186898_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p243_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p722845_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The returned attachments will be generated as a ZIP file even if selection is used to select only one single file. You can change this behaviour by setting this option to "false". In this case, the file will not be zipped, and will instead be returned directly as is. However, this will only work if selection has been used to select one file and one file only.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isSingleFileAsZip() {
        if (singleFileAsZip == null) {
            return true;
        } else {
            return singleFileAsZip;
        }
    }

    /**
     * Sets the value of the singleFileAsZip property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isSingleFileAsZip()
     */
    public void setSingleFileAsZip(boolean value) {
        this.singleFileAsZip = value;
    }

    public boolean isSetSingleFileAsZip() {
        return (this.singleFileAsZip!= null);
    }

    public void unsetSingleFileAsZip() {
        this.singleFileAsZip = null;
    }

}
