
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;
import net.webpdf.wsclient.schema.ParameterInterface;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p179225_="https://jakarta.ee/xml/ns/jaxb" xmlns:p413817_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;When using the "Pdfa" web service, both the &lt;code&gt;&amp;lt;convert&amp;gt;&lt;/code&gt; and &lt;code&gt;&amp;lt;analyze&amp;gt;&lt;/code&gt; operations can be used.&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p179225_="https://jakarta.ee/xml/ns/jaxb" xmlns:p413817_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The &lt;code&gt;convert&lt;/code&gt; operation is used to convert PDF documents to PDF/A, while the &lt;code&gt;analyze&lt;/code&gt; operation is used to validate existing PDF/A documents.&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for PdfaType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="PdfaType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <choice>
 *         <element name="convert">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <all>
 *                   <element name="zugferd" type="{http://schema.webpdf.de/1.0/operation}ZugferdType" minOccurs="0"/>
 *                   <element name="errorCorrection" type="{http://schema.webpdf.de/1.0/operation}PdfaErrorCorrectionType" minOccurs="0"/>
 *                 </all>
 *                 <attribute name="level" type="{http://schema.webpdf.de/1.0/operation}PdfaLevelType" default="3b" />
 *                 <attribute name="imageQuality" default="75">
 *                   <simpleType>
 *                     <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *                       <minInclusive value="0"/>
 *                       <maxInclusive value="100"/>
 *                     </restriction>
 *                   </simpleType>
 *                 </attribute>
 *                 <attribute name="errorReport" type="{http://schema.webpdf.de/1.0/operation}PdfaErrorReportType" default="none" />
 *                 <attribute name="successReport" type="{http://schema.webpdf.de/1.0/operation}PdfaSuccessReportType" default="none" />
 *                 <attribute name="autoTagging" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *         <element name="analyze">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <attribute name="level" type="{http://schema.webpdf.de/1.0/operation}PdfaLevelType" default="3b" />
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *       </choice>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "PdfaType", propOrder = {
    "convert",
    "analyze"
})
public class PdfaType
    implements ParameterInterface
{

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p179225_="https://jakarta.ee/xml/ns/jaxb" xmlns:p413817_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to convert a PDF document to PDF/A.&lt;/p&gt;
     * </pre>
     * 
     */
    protected PdfaType.Convert convert;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p179225_="https://jakarta.ee/xml/ns/jaxb" xmlns:p413817_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the parameters for the PDF/A conversion.&lt;/p&gt;
     * </pre>
     * 
     */
    protected PdfaType.Analyze analyze;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p179225_="https://jakarta.ee/xml/ns/jaxb" xmlns:p413817_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to convert a PDF document to PDF/A.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link PdfaType.Convert }
     *     
     */
    public PdfaType.Convert getConvert() {
        return convert;
    }

    /**
     * Sets the value of the convert property.
     * 
     * @param value
     *     allowed object is
     *     {@link PdfaType.Convert }
     *     
     * @see #getConvert()
     */
    public void setConvert(PdfaType.Convert value) {
        this.convert = value;
    }

    public boolean isSetConvert() {
        return (this.convert!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p179225_="https://jakarta.ee/xml/ns/jaxb" xmlns:p413817_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the parameters for the PDF/A conversion.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link PdfaType.Analyze }
     *     
     */
    public PdfaType.Analyze getAnalyze() {
        return analyze;
    }

    /**
     * Sets the value of the analyze property.
     * 
     * @param value
     *     allowed object is
     *     {@link PdfaType.Analyze }
     *     
     * @see #getAnalyze()
     */
    public void setAnalyze(PdfaType.Analyze value) {
        this.analyze = value;
    }

    public boolean isSetAnalyze() {
        return (this.analyze!= null);
    }


    /**
     * <p>Java class for anonymous complex type</p>.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.</p>
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <attribute name="level" type="{http://schema.webpdf.de/1.0/operation}PdfaLevelType" default="3b" />
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "")
    public static class Analyze {

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p179225_="https://jakarta.ee/xml/ns/jaxb" xmlns:p413817_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies the compliance level when creating or validating PDF/A documents (as specified in ISO 19005).&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "level")
        protected PdfaLevelType level;

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p179225_="https://jakarta.ee/xml/ns/jaxb" xmlns:p413817_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies the compliance level when creating or validating PDF/A documents (as specified in ISO 19005).&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link PdfaLevelType }
         *     
         */
        public PdfaLevelType getLevel() {
            if (level == null) {
                return PdfaLevelType.LEVEL_3B;
            } else {
                return level;
            }
        }

        /**
         * Sets the value of the level property.
         * 
         * @param value
         *     allowed object is
         *     {@link PdfaLevelType }
         *     
         * @see #getLevel()
         */
        public void setLevel(PdfaLevelType value) {
            this.level = value;
        }

        public boolean isSetLevel() {
            return (this.level!= null);
        }

    }


    /**
     * <p>Java class for anonymous complex type</p>.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.</p>
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <all>
     *         <element name="zugferd" type="{http://schema.webpdf.de/1.0/operation}ZugferdType" minOccurs="0"/>
     *         <element name="errorCorrection" type="{http://schema.webpdf.de/1.0/operation}PdfaErrorCorrectionType" minOccurs="0"/>
     *       </all>
     *       <attribute name="level" type="{http://schema.webpdf.de/1.0/operation}PdfaLevelType" default="3b" />
     *       <attribute name="imageQuality" default="75">
     *         <simpleType>
     *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
     *             <minInclusive value="0"/>
     *             <maxInclusive value="100"/>
     *           </restriction>
     *         </simpleType>
     *       </attribute>
     *       <attribute name="errorReport" type="{http://schema.webpdf.de/1.0/operation}PdfaErrorReportType" default="none" />
     *       <attribute name="successReport" type="{http://schema.webpdf.de/1.0/operation}PdfaSuccessReportType" default="none" />
     *       <attribute name="autoTagging" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {

    })
    public static class Convert {

        protected ZugferdType zugferd;
        protected PdfaErrorCorrectionType errorCorrection;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p179225_="https://jakarta.ee/xml/ns/jaxb" xmlns:p413817_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies the compliance level when creating or validating PDF/A documents (as specified in ISO 19005).&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "level")
        protected PdfaLevelType level;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p179225_="https://jakarta.ee/xml/ns/jaxb" xmlns:p413817_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The quality for images which must be transformed during the conversion because they use a compression which is not allowed (e.g. JPX is not allowed in PDF/A-1) is defined using this parameter. Values in a range from 1 to 100 are allowed whereby a higher value means better quality, but also larger PDF documents.&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "imageQuality")
        protected Integer imageQuality;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p179225_="https://jakarta.ee/xml/ns/jaxb" xmlns:p413817_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This parameter is used to define whether and in which format the XML report for a failed conversion will be returned.&#13;
         *                                     &lt;ul&gt;&lt;li&gt;none = An XML report will not be returned&lt;/li&gt;&lt;li&gt;message = The XML report will be returned as part of the error message&lt;/li&gt;&lt;li&gt;file = The XML report will be saved in a file&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "errorReport")
        protected PdfaErrorReportType errorReport;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p179225_="https://jakarta.ee/xml/ns/jaxb" xmlns:p413817_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This parameter is used to define whether and in which format the XML report for a successful conversion will be returned.&#13;
         *                                     &lt;ul&gt;&lt;li&gt;none = An XML report will not be returned&lt;/li&gt;&lt;li&gt;linked = The XML report will be appended at the end of the PDF/A document.&lt;/li&gt;&lt;li&gt;zip = The PDF/A document and the XML report will be packaged together in a ZIP archive.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
         * </pre>
         * 
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p179225_="https://jakarta.ee/xml/ns/jaxb" xmlns:p413817_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Tip:&lt;/b&gt;&#13;
         *                                     The format of the document generated with "errorReport" and "successReport" is described by the http://schema.webpdf.de/1.0/report/pdfa.xsd schema.&#13;
         *                                 &lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "successReport")
        protected PdfaSuccessReportType successReport;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p179225_="https://jakarta.ee/xml/ns/jaxb" xmlns:p413817_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;In order to convert a document to conformity levels PDF/A 1a-3a, the entire document must have appropriate structure information (tags). If auto tagging is enabled, the corresponding structure information (in the form of page tags) will be generated automatically before the actual conversion.&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "autoTagging")
        protected Boolean autoTagging;

        /**
         * Gets the value of the zugferd property.
         * 
         * @return
         *     possible object is
         *     {@link ZugferdType }
         *     
         */
        public ZugferdType getZugferd() {
            return zugferd;
        }

        /**
         * Sets the value of the zugferd property.
         * 
         * @param value
         *     allowed object is
         *     {@link ZugferdType }
         *     
         */
        public void setZugferd(ZugferdType value) {
            this.zugferd = value;
        }

        public boolean isSetZugferd() {
            return (this.zugferd!= null);
        }

        /**
         * Gets the value of the errorCorrection property.
         * 
         * @return
         *     possible object is
         *     {@link PdfaErrorCorrectionType }
         *     
         */
        public PdfaErrorCorrectionType getErrorCorrection() {
            return errorCorrection;
        }

        /**
         * Sets the value of the errorCorrection property.
         * 
         * @param value
         *     allowed object is
         *     {@link PdfaErrorCorrectionType }
         *     
         */
        public void setErrorCorrection(PdfaErrorCorrectionType value) {
            this.errorCorrection = value;
        }

        public boolean isSetErrorCorrection() {
            return (this.errorCorrection!= null);
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p179225_="https://jakarta.ee/xml/ns/jaxb" xmlns:p413817_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies the compliance level when creating or validating PDF/A documents (as specified in ISO 19005).&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link PdfaLevelType }
         *     
         */
        public PdfaLevelType getLevel() {
            if (level == null) {
                return PdfaLevelType.LEVEL_3B;
            } else {
                return level;
            }
        }

        /**
         * Sets the value of the level property.
         * 
         * @param value
         *     allowed object is
         *     {@link PdfaLevelType }
         *     
         * @see #getLevel()
         */
        public void setLevel(PdfaLevelType value) {
            this.level = value;
        }

        public boolean isSetLevel() {
            return (this.level!= null);
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p179225_="https://jakarta.ee/xml/ns/jaxb" xmlns:p413817_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The quality for images which must be transformed during the conversion because they use a compression which is not allowed (e.g. JPX is not allowed in PDF/A-1) is defined using this parameter. Values in a range from 1 to 100 are allowed whereby a higher value means better quality, but also larger PDF documents.&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link Integer }
         *     
         */
        public int getImageQuality() {
            if (imageQuality == null) {
                return  75;
            } else {
                return imageQuality;
            }
        }

        /**
         * Sets the value of the imageQuality property.
         * 
         * @param value
         *     allowed object is
         *     {@link Integer }
         *     
         * @see #getImageQuality()
         */
        public void setImageQuality(int value) {
            this.imageQuality = value;
        }

        public boolean isSetImageQuality() {
            return (this.imageQuality!= null);
        }

        public void unsetImageQuality() {
            this.imageQuality = null;
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p179225_="https://jakarta.ee/xml/ns/jaxb" xmlns:p413817_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This parameter is used to define whether and in which format the XML report for a failed conversion will be returned.&#13;
         *                                     &lt;ul&gt;&lt;li&gt;none = An XML report will not be returned&lt;/li&gt;&lt;li&gt;message = The XML report will be returned as part of the error message&lt;/li&gt;&lt;li&gt;file = The XML report will be saved in a file&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link PdfaErrorReportType }
         *     
         */
        public PdfaErrorReportType getErrorReport() {
            if (errorReport == null) {
                return PdfaErrorReportType.NONE;
            } else {
                return errorReport;
            }
        }

        /**
         * Sets the value of the errorReport property.
         * 
         * @param value
         *     allowed object is
         *     {@link PdfaErrorReportType }
         *     
         * @see #getErrorReport()
         */
        public void setErrorReport(PdfaErrorReportType value) {
            this.errorReport = value;
        }

        public boolean isSetErrorReport() {
            return (this.errorReport!= null);
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p179225_="https://jakarta.ee/xml/ns/jaxb" xmlns:p413817_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This parameter is used to define whether and in which format the XML report for a successful conversion will be returned.&#13;
         *                                     &lt;ul&gt;&lt;li&gt;none = An XML report will not be returned&lt;/li&gt;&lt;li&gt;linked = The XML report will be appended at the end of the PDF/A document.&lt;/li&gt;&lt;li&gt;zip = The PDF/A document and the XML report will be packaged together in a ZIP archive.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
         * </pre>
         * 
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p179225_="https://jakarta.ee/xml/ns/jaxb" xmlns:p413817_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Tip:&lt;/b&gt;&#13;
         *                                     The format of the document generated with "errorReport" and "successReport" is described by the http://schema.webpdf.de/1.0/report/pdfa.xsd schema.&#13;
         *                                 &lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link PdfaSuccessReportType }
         *     
         */
        public PdfaSuccessReportType getSuccessReport() {
            if (successReport == null) {
                return PdfaSuccessReportType.NONE;
            } else {
                return successReport;
            }
        }

        /**
         * Sets the value of the successReport property.
         * 
         * @param value
         *     allowed object is
         *     {@link PdfaSuccessReportType }
         *     
         * @see #getSuccessReport()
         */
        public void setSuccessReport(PdfaSuccessReportType value) {
            this.successReport = value;
        }

        public boolean isSetSuccessReport() {
            return (this.successReport!= null);
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p179225_="https://jakarta.ee/xml/ns/jaxb" xmlns:p413817_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;In order to convert a document to conformity levels PDF/A 1a-3a, the entire document must have appropriate structure information (tags). If auto tagging is enabled, the corresponding structure information (in the form of page tags) will be generated automatically before the actual conversion.&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isAutoTagging() {
            if (autoTagging == null) {
                return false;
            } else {
                return autoTagging;
            }
        }

        /**
         * Sets the value of the autoTagging property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         * @see #isAutoTagging()
         */
        public void setAutoTagging(boolean value) {
            this.autoTagging = value;
        }

        public boolean isSetAutoTagging() {
            return (this.autoTagging!= null);
        }

        public void unsetAutoTagging() {
            this.autoTagging = null;
        }

    }

}
