
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&#13;
 *                     Defines the profile whose rules web services have to check before they can come to execution. These profiles define a set of rules concerning the validity of PDF/A documents. A web service whose execution for a given PDF/A document would violate the rule set selected here should instead abort with an appropriate error code.&#13;
 *                     &lt;ul&gt;&lt;li&gt;generalEditRestrictions = All changes to PDF/A documents are prohibited.&lt;/li&gt;&lt;li&gt;removePdfaMetadata = All changes to PDF/A documents are allowed, but the PDF/A state of the document is revoked. (By removing the PDF/A metadata.)&lt;/li&gt;&lt;li&gt;noEditRestrictions = All changes to PDF/A documents are allowed, without touching the PDF/A state of the document. (Risking the invalidation of the document.)&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for PdfaEditProfileType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="PdfaEditProfileType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="generalEditRestrictions"/>
 *     <enumeration value="removePdfaMetadata"/>
 *     <enumeration value="noEditRestrictions"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "PdfaEditProfileType")
@XmlEnum
public enum PdfaEditProfileType {

    @XmlEnumValue("generalEditRestrictions")
    GENERAL_EDIT_RESTRICTIONS("generalEditRestrictions"),
    @XmlEnumValue("removePdfaMetadata")
    REMOVE_PDFA_METADATA("removePdfaMetadata"),
    @XmlEnumValue("noEditRestrictions")
    NO_EDIT_RESTRICTIONS("noEditRestrictions");
    private final String value;

    PdfaEditProfileType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static PdfaEditProfileType fromValue(String v) {
        for (PdfaEditProfileType c: PdfaEditProfileType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
