
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p296078_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p595873_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Sets the encryption level for the document.&#13;
 *                     &lt;ul&gt;&lt;li&gt;RC4_40 = 40-bit RC4&lt;/li&gt;&lt;li&gt;RC4_128 = 128-bit RC4&lt;/li&gt;&lt;li&gt;AES_128 = 128-bit AES&lt;/li&gt;&lt;li&gt;AES_256 = 256-bit AES&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p296078_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p595873_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
 *                     Please note that the option "256-bit AES" only works if the "Java Cryptography Extension (JCE)" has been enabled with "Unlimited Strength" in the JVM. You can obtain the modified "Policy Files" (along with instructions for installation) from the Oracle website:&#13;
 *                     Java Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy Files 7 Download:&#13;
 *                     http://www.oracle.com/technetwork/java/javase/downloads/jce-7-download-432124.html&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for PdfEncryptionKeyType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="PdfEncryptionKeyType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="RC4_40"/>
 *     <enumeration value="RC4_128"/>
 *     <enumeration value="AES_128"/>
 *     <enumeration value="AES_256"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "PdfEncryptionKeyType")
@XmlEnum
public enum PdfEncryptionKeyType {

    @XmlEnumValue("RC4_40")
    RC_4_40("RC4_40"),
    @XmlEnumValue("RC4_128")
    RC_4_128("RC4_128"),
    AES_128("AES_128"),
    AES_256("AES_256");
    private final String value;

    PdfEncryptionKeyType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static PdfEncryptionKeyType fromValue(String v) {
        for (PdfEncryptionKeyType c: PdfEncryptionKeyType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
