
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p343700_="https://jakarta.ee/xml/ns/jaxb" xmlns:p472644_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p752341_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If PDF417 barcode compression has been enabled with the "compact" attribute, the encoding selected here for the compression of generated PDF417 barcodes will be used.&#13;
 *                     &lt;ul&gt;&lt;li&gt;auto = Try to determine the best encoding method automatically.&lt;/li&gt;&lt;li&gt;byte = Select a byte encoding method in which every 5 codewords represent 6 bytes.&lt;/li&gt;&lt;li&gt;numeric = Select a numeric encoding method in which a group of 15 codewords represents up to 44 decimal numbers.&lt;/li&gt;&lt;li&gt;text = Select a text encoding method in which each codeword represents up to 2 letters.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for Pdf417CompactionModeType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="Pdf417CompactionModeType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="text"/>
 *     <enumeration value="numeric"/>
 *     <enumeration value="byte"/>
 *     <enumeration value="auto"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "Pdf417CompactionModeType")
@XmlEnum
public enum Pdf417CompactionModeType {

    @XmlEnumValue("text")
    TEXT("text"),
    @XmlEnumValue("numeric")
    NUMERIC("numeric"),
    @XmlEnumValue("byte")
    BYTE("byte"),
    @XmlEnumValue("auto")
    AUTO("auto");
    private final String value;

    Pdf417CompactionModeType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static Pdf417CompactionModeType fromValue(String v) {
        for (Pdf417CompactionModeType c: Pdf417CompactionModeType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
