
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p343700_="https://jakarta.ee/xml/ns/jaxb" xmlns:p472644_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p752341_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A PDF417 barcode.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for Pdf417BarcodeType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="Pdf417BarcodeType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}BaseBarcodeType">
 *       <attribute name="errorCorrection" default="2">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="1"/>
 *             <maxInclusive value="8"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="compact" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="compactionMode" type="{http://schema.webpdf.de/1.0/operation}Pdf417CompactionModeType" default="auto" />
 *       <attribute name="dataCodewordsMin">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="1"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="dataCodewordsMax">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="1"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="symbolsPerCodewordMin">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="1"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="symbolsPerCodewordMax">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="1"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="shape" type="{http://schema.webpdf.de/1.0/operation}DataMatrixShapeType" default="default" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Pdf417BarcodeType")
public class Pdf417BarcodeType
    extends BaseBarcodeType
{

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p343700_="https://jakarta.ee/xml/ns/jaxb" xmlns:p472644_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p752341_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to adjust the error correction level for generated PDF417 codes. The higher the level, the more error-resistant the barcode, ensuring that damaged codes will still be readable. A level of 1 to 8 can be specified.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "errorCorrection")
    protected Integer errorCorrection;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p343700_="https://jakarta.ee/xml/ns/jaxb" xmlns:p472644_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p752341_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to "true," the contents of all generated PDF417 barcodes will be compressed using the encoding selected with the "compactionMode" attribute.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "compact")
    protected Boolean compact;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p343700_="https://jakarta.ee/xml/ns/jaxb" xmlns:p472644_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p752341_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If PDF417 barcode compression has been enabled with the "compact" attribute, the encoding selected here for the compression of generated PDF417 barcodes will be used.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;auto = Try to determine the best encoding method automatically.&lt;/li&gt;&lt;li&gt;byte = Select a byte encoding method in which every 5 codewords represent 6 bytes.&lt;/li&gt;&lt;li&gt;numeric = Select a numeric encoding method in which a group of 15 codewords represents up to 44 decimal numbers.&lt;/li&gt;&lt;li&gt;text = Select a text encoding method in which each codeword represents up to 2 letters.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "compactionMode")
    protected Pdf417CompactionModeType compactionMode;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p343700_="https://jakarta.ee/xml/ns/jaxb" xmlns:p472644_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p752341_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the minimum number of codewords allowed in a single PDF417 barcode row.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "dataCodewordsMin")
    protected Integer dataCodewordsMin;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p343700_="https://jakarta.ee/xml/ns/jaxb" xmlns:p472644_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p752341_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the maximum number of codewords allowed in a single PDF417 barcode row.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "dataCodewordsMax")
    protected Integer dataCodewordsMax;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p343700_="https://jakarta.ee/xml/ns/jaxb" xmlns:p472644_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p752341_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the minimum number of code symbols that are allowed to be in a single codeword in the PDF417 barcode.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "symbolsPerCodewordMin")
    protected Integer symbolsPerCodewordMin;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p343700_="https://jakarta.ee/xml/ns/jaxb" xmlns:p472644_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p752341_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the maximum number of code symbols that are allowed to be in a single codeword in the PDF417 barcode.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "symbolsPerCodewordMax")
    protected Integer symbolsPerCodewordMax;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p343700_="https://jakarta.ee/xml/ns/jaxb" xmlns:p472644_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p752341_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Can be used to force a specific shape for generated PDF417 barcodes.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;default = Select an appropriate shape.&lt;/li&gt;&lt;li&gt;rectangle = Force a rectangular shape.&lt;/li&gt;&lt;li&gt;square = Force a square shape.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "shape")
    protected DataMatrixShapeType shape;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p343700_="https://jakarta.ee/xml/ns/jaxb" xmlns:p472644_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p752341_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to adjust the error correction level for generated PDF417 codes. The higher the level, the more error-resistant the barcode, ensuring that damaged codes will still be readable. A level of 1 to 8 can be specified.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getErrorCorrection() {
        if (errorCorrection == null) {
            return  2;
        } else {
            return errorCorrection;
        }
    }

    /**
     * Sets the value of the errorCorrection property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getErrorCorrection()
     */
    public void setErrorCorrection(int value) {
        this.errorCorrection = value;
    }

    public boolean isSetErrorCorrection() {
        return (this.errorCorrection!= null);
    }

    public void unsetErrorCorrection() {
        this.errorCorrection = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p343700_="https://jakarta.ee/xml/ns/jaxb" xmlns:p472644_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p752341_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to "true," the contents of all generated PDF417 barcodes will be compressed using the encoding selected with the "compactionMode" attribute.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isCompact() {
        if (compact == null) {
            return false;
        } else {
            return compact;
        }
    }

    /**
     * Sets the value of the compact property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isCompact()
     */
    public void setCompact(boolean value) {
        this.compact = value;
    }

    public boolean isSetCompact() {
        return (this.compact!= null);
    }

    public void unsetCompact() {
        this.compact = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p343700_="https://jakarta.ee/xml/ns/jaxb" xmlns:p472644_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p752341_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If PDF417 barcode compression has been enabled with the "compact" attribute, the encoding selected here for the compression of generated PDF417 barcodes will be used.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;auto = Try to determine the best encoding method automatically.&lt;/li&gt;&lt;li&gt;byte = Select a byte encoding method in which every 5 codewords represent 6 bytes.&lt;/li&gt;&lt;li&gt;numeric = Select a numeric encoding method in which a group of 15 codewords represents up to 44 decimal numbers.&lt;/li&gt;&lt;li&gt;text = Select a text encoding method in which each codeword represents up to 2 letters.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Pdf417CompactionModeType }
     *     
     */
    public Pdf417CompactionModeType getCompactionMode() {
        if (compactionMode == null) {
            return Pdf417CompactionModeType.AUTO;
        } else {
            return compactionMode;
        }
    }

    /**
     * Sets the value of the compactionMode property.
     * 
     * @param value
     *     allowed object is
     *     {@link Pdf417CompactionModeType }
     *     
     * @see #getCompactionMode()
     */
    public void setCompactionMode(Pdf417CompactionModeType value) {
        this.compactionMode = value;
    }

    public boolean isSetCompactionMode() {
        return (this.compactionMode!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p343700_="https://jakarta.ee/xml/ns/jaxb" xmlns:p472644_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p752341_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the minimum number of codewords allowed in a single PDF417 barcode row.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getDataCodewordsMin() {
        return dataCodewordsMin;
    }

    /**
     * Sets the value of the dataCodewordsMin property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getDataCodewordsMin()
     */
    public void setDataCodewordsMin(int value) {
        this.dataCodewordsMin = value;
    }

    public boolean isSetDataCodewordsMin() {
        return (this.dataCodewordsMin!= null);
    }

    public void unsetDataCodewordsMin() {
        this.dataCodewordsMin = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p343700_="https://jakarta.ee/xml/ns/jaxb" xmlns:p472644_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p752341_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the maximum number of codewords allowed in a single PDF417 barcode row.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getDataCodewordsMax() {
        return dataCodewordsMax;
    }

    /**
     * Sets the value of the dataCodewordsMax property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getDataCodewordsMax()
     */
    public void setDataCodewordsMax(int value) {
        this.dataCodewordsMax = value;
    }

    public boolean isSetDataCodewordsMax() {
        return (this.dataCodewordsMax!= null);
    }

    public void unsetDataCodewordsMax() {
        this.dataCodewordsMax = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p343700_="https://jakarta.ee/xml/ns/jaxb" xmlns:p472644_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p752341_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the minimum number of code symbols that are allowed to be in a single codeword in the PDF417 barcode.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getSymbolsPerCodewordMin() {
        return symbolsPerCodewordMin;
    }

    /**
     * Sets the value of the symbolsPerCodewordMin property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getSymbolsPerCodewordMin()
     */
    public void setSymbolsPerCodewordMin(int value) {
        this.symbolsPerCodewordMin = value;
    }

    public boolean isSetSymbolsPerCodewordMin() {
        return (this.symbolsPerCodewordMin!= null);
    }

    public void unsetSymbolsPerCodewordMin() {
        this.symbolsPerCodewordMin = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p343700_="https://jakarta.ee/xml/ns/jaxb" xmlns:p472644_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p752341_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the maximum number of code symbols that are allowed to be in a single codeword in the PDF417 barcode.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getSymbolsPerCodewordMax() {
        return symbolsPerCodewordMax;
    }

    /**
     * Sets the value of the symbolsPerCodewordMax property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getSymbolsPerCodewordMax()
     */
    public void setSymbolsPerCodewordMax(int value) {
        this.symbolsPerCodewordMax = value;
    }

    public boolean isSetSymbolsPerCodewordMax() {
        return (this.symbolsPerCodewordMax!= null);
    }

    public void unsetSymbolsPerCodewordMax() {
        this.symbolsPerCodewordMax = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p343700_="https://jakarta.ee/xml/ns/jaxb" xmlns:p472644_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p752341_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Can be used to force a specific shape for generated PDF417 barcodes.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;default = Select an appropriate shape.&lt;/li&gt;&lt;li&gt;rectangle = Force a rectangular shape.&lt;/li&gt;&lt;li&gt;square = Force a square shape.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link DataMatrixShapeType }
     *     
     */
    public DataMatrixShapeType getShape() {
        if (shape == null) {
            return DataMatrixShapeType.DEFAULT;
        } else {
            return shape;
        }
    }

    /**
     * Sets the value of the shape property.
     * 
     * @param value
     *     allowed object is
     *     {@link DataMatrixShapeType }
     *     
     * @see #getShape()
     */
    public void setShape(DataMatrixShapeType value) {
        this.shape = value;
    }

    public boolean isSetShape() {
        return (this.shape!= null);
    }

}
