
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the document page range to which new elements should be added. Can be used to define a fixed interval from one page to another page.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for PageIntervalType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="PageIntervalType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="odd" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="even" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="pages" type="{http://www.w3.org/2001/XMLSchema}string" default="*" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "PageIntervalType")
public class PageIntervalType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If true, the elements are also placed on pages with odd-numbered pages.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "odd")
    protected Boolean odd;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If true, the elements are also placed on even-numbered pages.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "even")
    protected Boolean even;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines the pages of the PDF document to which new elements should be added. Either a single page or a range of pages (e.g., "1-5") can be defined. (Can only be used to define a single contiguous interval of consecutive pages.)&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "pages")
    protected String pages;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If true, the elements are also placed on pages with odd-numbered pages.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isOdd() {
        if (odd == null) {
            return true;
        } else {
            return odd;
        }
    }

    /**
     * Sets the value of the odd property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isOdd()
     */
    public void setOdd(boolean value) {
        this.odd = value;
    }

    public boolean isSetOdd() {
        return (this.odd!= null);
    }

    public void unsetOdd() {
        this.odd = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If true, the elements are also placed on even-numbered pages.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isEven() {
        if (even == null) {
            return true;
        } else {
            return even;
        }
    }

    /**
     * Sets the value of the even property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isEven()
     */
    public void setEven(boolean value) {
        this.even = value;
    }

    public boolean isSetEven() {
        return (this.even!= null);
    }

    public void unsetEven() {
        this.even = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines the pages of the PDF document to which new elements should be added. Either a single page or a range of pages (e.g., "1-5") can be defined. (Can only be used to define a single contiguous interval of consecutive pages.)&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPages() {
        if (pages == null) {
            return "*";
        } else {
            return pages;
        }
    }

    /**
     * Sets the value of the pages property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getPages()
     */
    public void setPages(String value) {
        this.pages = value;
    }

    public boolean isSetPages() {
        return (this.pages!= null);
    }

}
