
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The launchApplication element will open another application or document when activated. The "applicationPath" subelement is required. "launchParameters" is optional.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for LaunchApplicationActionType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="LaunchApplicationActionType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}ActionEventType">
 *       <all>
 *         <element name="applicationPath" type="{http://schema.webpdf.de/1.0/operation}FileSpecificationType" minOccurs="0"/>
 *         <element name="launchParameters" type="{http://schema.webpdf.de/1.0/operation}LaunchParameterType" minOccurs="0"/>
 *       </all>
 *       <attribute name="newWindow" type="{http://schema.webpdf.de/1.0/operation}OpenModeType" default="userPreferences" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "LaunchApplicationActionType", propOrder = {
    "applicationPath",
    "launchParameters"
})
public class LaunchApplicationActionType
    extends ActionEventType
{

    protected FileSpecificationType applicationPath;
    protected LaunchParameterType launchParameters;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to select the window in which the application / document should be opened.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;userPreference = Uses the variant that is normal in the reader application or that has been configured by the user.&lt;/li&gt;&lt;li&gt;newWindow = Forces the application or document to be opened in a new window.&lt;/li&gt;&lt;li&gt;sameWindow = Attempts (if possible) to open the document in the current reader application window.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "newWindow")
    protected OpenModeType newWindow;

    /**
     * Gets the value of the applicationPath property.
     * 
     * @return
     *     possible object is
     *     {@link FileSpecificationType }
     *     
     */
    public FileSpecificationType getApplicationPath() {
        return applicationPath;
    }

    /**
     * Sets the value of the applicationPath property.
     * 
     * @param value
     *     allowed object is
     *     {@link FileSpecificationType }
     *     
     */
    public void setApplicationPath(FileSpecificationType value) {
        this.applicationPath = value;
    }

    public boolean isSetApplicationPath() {
        return (this.applicationPath!= null);
    }

    /**
     * Gets the value of the launchParameters property.
     * 
     * @return
     *     possible object is
     *     {@link LaunchParameterType }
     *     
     */
    public LaunchParameterType getLaunchParameters() {
        return launchParameters;
    }

    /**
     * Sets the value of the launchParameters property.
     * 
     * @param value
     *     allowed object is
     *     {@link LaunchParameterType }
     *     
     */
    public void setLaunchParameters(LaunchParameterType value) {
        this.launchParameters = value;
    }

    public boolean isSetLaunchParameters() {
        return (this.launchParameters!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to select the window in which the application / document should be opened.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;userPreference = Uses the variant that is normal in the reader application or that has been configured by the user.&lt;/li&gt;&lt;li&gt;newWindow = Forces the application or document to be opened in a new window.&lt;/li&gt;&lt;li&gt;sameWindow = Attempts (if possible) to open the document in the current reader application window.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link OpenModeType }
     *     
     */
    public OpenModeType getNewWindow() {
        if (newWindow == null) {
            return OpenModeType.USER_PREFERENCES;
        } else {
            return newWindow;
        }
    }

    /**
     * Sets the value of the newWindow property.
     * 
     * @param value
     *     allowed object is
     *     {@link OpenModeType }
     *     
     * @see #getNewWindow()
     */
    public void setNewWindow(OpenModeType value) {
        this.newWindow = value;
    }

    public boolean isSetNewWindow() {
        return (this.newWindow!= null);
    }

}
