
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the horizontal justification/alignment/orientation of elements.&#13;
 *                     &lt;ul&gt;&lt;li&gt;leftJustified = All elements shall be oriented to the left.&lt;/li&gt;&lt;li&gt;centered = All elements shall be placed in the center of the container.&lt;/li&gt;&lt;li&gt;rightJustified = All elements shall be oriented to the right.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for JustificationType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="JustificationType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="leftJustified"/>
 *     <enumeration value="centered"/>
 *     <enumeration value="rightJustified"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "JustificationType")
@XmlEnum
public enum JustificationType {

    @XmlEnumValue("leftJustified")
    LEFT_JUSTIFIED("leftJustified"),
    @XmlEnumValue("centered")
    CENTERED("centered"),
    @XmlEnumValue("rightJustified")
    RIGHT_JUSTIFIED("rightJustified");
    private final String value;

    JustificationType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static JustificationType fromValue(String v) {
        for (JustificationType c: JustificationType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
