
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The image operation element can be used to export a document as an image.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for ImageType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ImageType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}BaseToolboxType">
 *       <choice>
 *         <element name="png" type="{http://schema.webpdf.de/1.0/operation}PngType"/>
 *         <element name="tiff" type="{http://schema.webpdf.de/1.0/operation}TiffType"/>
 *         <element name="jpeg" type="{http://schema.webpdf.de/1.0/operation}JpegType"/>
 *         <element name="gif" type="{http://schema.webpdf.de/1.0/operation}GifType"/>
 *         <element name="bmp" type="{http://schema.webpdf.de/1.0/operation}BmpType"/>
 *         <element name="svg" type="{http://schema.webpdf.de/1.0/operation}SvgType"/>
 *       </choice>
 *       <attribute name="pages" type="{http://www.w3.org/2001/XMLSchema}string" default="1" />
 *       <attribute name="fileNameTemplate" type="{http://www.w3.org/2001/XMLSchema}string" default="page[%d]" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ImageType", propOrder = {
    "png",
    "tiff",
    "jpeg",
    "gif",
    "bmp",
    "svg"
})
public class ImageType
    extends BaseToolboxType
{

    protected PngType png;
    protected TiffType tiff;
    protected JpegType jpeg;
    protected GifType gif;
    protected BmpType bmp;
    protected SvgType svg;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the page number or page range (e.g., "1,5-6,9") that should be converted to an image file format. If only a single page is defined, the image file will be returned directly. If a range of pages is declared, then the call will return a ZIP file containing all the exported pages. The name of the individual image file (when multiple pages are exported) is defined with the "fileNameTemplate" attribute.&#13;
     *                                 The "tif" format is an exception when exporting multiple pages. When using this format, the "multipage" attribute can be used to define whether a multipage TIFF will be generated or whether the individual pages will be exported to a ZIP file (as with the other image file formats).&#13;
     *                             &lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "pages")
    protected String pages;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;When exporting multiple pages, this parameter is used to define the file name that will be used for the generated image files in the ZIP file. The file name must include the string "%d". This string will be replaced with a consecutive number in the file name.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "fileNameTemplate")
    protected String fileNameTemplate;

    /**
     * Gets the value of the png property.
     * 
     * @return
     *     possible object is
     *     {@link PngType }
     *     
     */
    public PngType getPng() {
        return png;
    }

    /**
     * Sets the value of the png property.
     * 
     * @param value
     *     allowed object is
     *     {@link PngType }
     *     
     */
    public void setPng(PngType value) {
        this.png = value;
    }

    public boolean isSetPng() {
        return (this.png!= null);
    }

    /**
     * Gets the value of the tiff property.
     * 
     * @return
     *     possible object is
     *     {@link TiffType }
     *     
     */
    public TiffType getTiff() {
        return tiff;
    }

    /**
     * Sets the value of the tiff property.
     * 
     * @param value
     *     allowed object is
     *     {@link TiffType }
     *     
     */
    public void setTiff(TiffType value) {
        this.tiff = value;
    }

    public boolean isSetTiff() {
        return (this.tiff!= null);
    }

    /**
     * Gets the value of the jpeg property.
     * 
     * @return
     *     possible object is
     *     {@link JpegType }
     *     
     */
    public JpegType getJpeg() {
        return jpeg;
    }

    /**
     * Sets the value of the jpeg property.
     * 
     * @param value
     *     allowed object is
     *     {@link JpegType }
     *     
     */
    public void setJpeg(JpegType value) {
        this.jpeg = value;
    }

    public boolean isSetJpeg() {
        return (this.jpeg!= null);
    }

    /**
     * Gets the value of the gif property.
     * 
     * @return
     *     possible object is
     *     {@link GifType }
     *     
     */
    public GifType getGif() {
        return gif;
    }

    /**
     * Sets the value of the gif property.
     * 
     * @param value
     *     allowed object is
     *     {@link GifType }
     *     
     */
    public void setGif(GifType value) {
        this.gif = value;
    }

    public boolean isSetGif() {
        return (this.gif!= null);
    }

    /**
     * Gets the value of the bmp property.
     * 
     * @return
     *     possible object is
     *     {@link BmpType }
     *     
     */
    public BmpType getBmp() {
        return bmp;
    }

    /**
     * Sets the value of the bmp property.
     * 
     * @param value
     *     allowed object is
     *     {@link BmpType }
     *     
     */
    public void setBmp(BmpType value) {
        this.bmp = value;
    }

    public boolean isSetBmp() {
        return (this.bmp!= null);
    }

    /**
     * Gets the value of the svg property.
     * 
     * @return
     *     possible object is
     *     {@link SvgType }
     *     
     */
    public SvgType getSvg() {
        return svg;
    }

    /**
     * Sets the value of the svg property.
     * 
     * @param value
     *     allowed object is
     *     {@link SvgType }
     *     
     */
    public void setSvg(SvgType value) {
        this.svg = value;
    }

    public boolean isSetSvg() {
        return (this.svg!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the page number or page range (e.g., "1,5-6,9") that should be converted to an image file format. If only a single page is defined, the image file will be returned directly. If a range of pages is declared, then the call will return a ZIP file containing all the exported pages. The name of the individual image file (when multiple pages are exported) is defined with the "fileNameTemplate" attribute.&#13;
     *                                 The "tif" format is an exception when exporting multiple pages. When using this format, the "multipage" attribute can be used to define whether a multipage TIFF will be generated or whether the individual pages will be exported to a ZIP file (as with the other image file formats).&#13;
     *                             &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPages() {
        if (pages == null) {
            return "1";
        } else {
            return pages;
        }
    }

    /**
     * Sets the value of the pages property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getPages()
     */
    public void setPages(String value) {
        this.pages = value;
    }

    public boolean isSetPages() {
        return (this.pages!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;When exporting multiple pages, this parameter is used to define the file name that will be used for the generated image files in the ZIP file. The file name must include the string "%d". This string will be replaced with a consecutive number in the file name.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getFileNameTemplate() {
        if (fileNameTemplate == null) {
            return "page[%d]";
        } else {
            return fileNameTemplate;
        }
    }

    /**
     * Sets the value of the fileNameTemplate property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getFileNameTemplate()
     */
    public void setFileNameTemplate(String value) {
        this.fileNameTemplate = value;
    }

    public boolean isSetFileNameTemplate() {
        return (this.fileNameTemplate!= null);
    }

}
