
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The optimization element allows to correct the images of the pages to optimize them for OCR. Except for the "deskew" parameter, none of the optimizations are actually visible in the generated documents. The other optimizations are only used to improve the text recognition.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for ImageOptimizationType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ImageOptimizationType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="deskew" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="despeckle" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="reduceDithering" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="noiseReduction" type="{http://schema.webpdf.de/1.0/operation}OptimizationIntensityType" default="low" />
 *       <attribute name="noiseReductionValue" default="1.0">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}float">
 *             <minInclusive value="0.0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="gammaCorrection" type="{http://schema.webpdf.de/1.0/operation}OptimizationIntensityType" default="off" />
 *       <attribute name="gammaCorrectionValue" default="0.0">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}float">
 *             <minInclusive value="0.0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="increaseContrast" type="{http://schema.webpdf.de/1.0/operation}OptimizationIntensityType" default="off" />
 *       <attribute name="increaseContrastValue" default="0">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="-100"/>
 *             <maxInclusive value="100"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="edgeAccentuation" type="{http://schema.webpdf.de/1.0/operation}OptimizationIntensityType" default="low" />
 *       <attribute name="edgeAccentuationValue" default="100">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="sharpen" type="{http://schema.webpdf.de/1.0/operation}OptimizationIntensityType" default="low" />
 *       <attribute name="sharpenValue" default="1.0">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}float">
 *             <minInclusive value="0.0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="medianFilter" type="{http://schema.webpdf.de/1.0/operation}OptimizationIntensityType" default="low" />
 *       <attribute name="medianFilterValue" default="1">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ImageOptimizationType")
public class ImageOptimizationType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Straight scans of pages can be created with a slight skew. If this value is set to true, an attempt is made to counter-rotate this skew and thus "deskew" the page. The results of this manipulation are visible in the resulting document.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "deskew")
    protected Boolean deskew;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this mode is set, impurities and stains are reduced. These are caused, for example, by dust or dirt on the pane of a scanner. It is recommended to activate this optimization.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "despeckle")
    protected Boolean despeckle;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;In black and white images (including black and white scans), color values are often represented by a halftone according to their brightness (dithering / moiré effect). These halftones/hatchings translate a color value into a uniform sequence of black and white areas that visually appear to be a uniform area of the same color/brightness. Such patterns can be very difficult to delineate against actual text that may be in such a "colored" area. Setting this value to true will try to reduce such dithering patterns. This mode should only be set if absolutely necessary, as this process can be very lossy.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "reduceDithering")
    protected Boolean reduceDithering;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this mode is set, an attempt is made to remove background noise from the image, which is caused by irregularities in the image background or by artifacts that can result from image compression. Such irregularities - especially around letters - can affect recognition. It is recommended to activate this optimization.&#13;
     *                         &lt;ul&gt;&lt;li&gt;off = Do not apply this optimization&lt;/li&gt;&lt;li&gt;value = Choose your own value&lt;/li&gt;&lt;li&gt;low = Perform optimization only with low intensity to avoid information loss.&lt;/li&gt;&lt;li&gt;medium = Perform optimization with medium intensity.&lt;/li&gt;&lt;li&gt;high = Perform optimization with high intensity and accept possible information losses.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "noiseReduction")
    protected OptimizationIntensityType noiseReduction;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Allows in combination with the noiseReduction mode "value" the free choice of a value for this optimization. A decimal value greater than 0 indicates the intensity with which the effect is to be applied to the image. The predefined values range between 1.0 (low) and 3.0 (high).&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "noiseReductionValue")
    protected Float noiseReductionValue;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This value should only be activated for very poorly exposed images. Selective light value spreading (compression) is used to emphasize the dark areas of the image over the light areas (gamma correction) and thus make detection possible at all. This mode should only be activated if absolutely necessary, since it can lead to strong information losses or otherwise make a recognition impossible. Together with an increase in image contrast, this optimization can be used, for example, to remove image backgrounds that would otherwise be difficult to distinguish from the letters applied to them.&#13;
     *                         &lt;ul&gt;&lt;li&gt;off = Do not apply this optimization&lt;/li&gt;&lt;li&gt;value = Select your own value&lt;/li&gt;&lt;li&gt;low = Perform optimization only with low intensity to avoid information loss.&lt;/li&gt;&lt;li&gt;medium = Perform optimization with medium intensity.&lt;/li&gt;&lt;li&gt;high = Perform optimization with strong intensity and accept possible information losses.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "gammaCorrection")
    protected OptimizationIntensityType gammaCorrection;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Allows in combination with the gammaCorrection mode "value" the free choice of a value for this optimization. A comma value greater than 0 specifies the value to be applied to the image as gamma correction. The predefined values range between 1.5 (low) and 2.5 (high).&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "gammaCorrectionValue")
    protected Float gammaCorrectionValue;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This value should only be activated for very poorly exposed images. By increasing the contrast, an attempt is made to emphasize the dark areas of the image over the light ones, thus making detection possible at all. This mode should only be activated if absolutely necessary, as it can lead to severe information loss or otherwise make detection impossible. Together with gamma correction, this optimization can be used, for example, to remove image backgrounds that would otherwise be difficult to distinguish from the letters applied to them.&#13;
     *                         &lt;ul&gt;&lt;li&gt;off = Do not apply this optimization&lt;/li&gt;&lt;li&gt;value = Choose your own value&lt;/li&gt;&lt;li&gt;low = Perform optimization only with low intensity to avoid information loss.&lt;/li&gt;&lt;li&gt;medium = Perform optimization with medium intensity.&lt;/li&gt;&lt;li&gt;high = Perform optimization with strong intensity and accept possible information losses.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "increaseContrast")
    protected OptimizationIntensityType increaseContrast;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Allows in combination with the increaseContrast mode "value" the free choice of a value for this optimization. An integer value between -100 and +100 specifies the intensity of the contrast enhancement. The predefined values range between 25 (low) and 75 (high).&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "increaseContrastValue")
    protected Integer increaseContrastValue;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set, a Marr-Hildreth operator is used to accentuate the edges of the image. This optimization usually leads to significantly better recognition results, but can also lead to information loss.&#13;
     *                         &lt;ul&gt;&lt;li&gt;off = Do not apply this optimization&lt;/li&gt;&lt;li&gt;value = Choose your own value&lt;/li&gt;&lt;li&gt;low = Perform optimization only with low intensity to avoid information loss.&lt;/li&gt;&lt;li&gt;medium = Perform optimization with medium intensity.&lt;/li&gt;&lt;li&gt;high = Perform optimization with strong intensity and accept possible information losses.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "edgeAccentuation")
    protected OptimizationIntensityType edgeAccentuation;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Allows in combination with the edgeAccentuation mode "value" the free choice of a value for this optimization. An integer percentage value indicates the intensity of the edge accentuation. The actual image is overlaid with a corresponding sharpening filter for the edge accentuation - this percentage value specifies how intensively this effect should be emphasized compared to the original image. The predefined values range between 100 (low) and 200 percent (high).&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "edgeAccentuationValue")
    protected Integer edgeAccentuationValue;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set, edge sharpening is applied to the image. This optimization usually leads to significantly better recognition results, but can also lead to information loss.&#13;
     *                         &lt;ul&gt;&lt;li&gt;off = Do not apply this optimization&lt;/li&gt;&lt;li&gt;value = Select your own value&lt;/li&gt;&lt;li&gt;low = Apply optimization only with low intensity to avoid information loss.&lt;/li&gt;&lt;li&gt;medium = Perform optimization with medium intensity.&lt;/li&gt;&lt;li&gt;high = Perform optimization with strong intensity and accept possible information losses.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "sharpen")
    protected OptimizationIntensityType sharpen;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Allows in combination with the sharpen mode "value" the free choice of a value for this optimization. A comma value greater than 0 indicates the intensity with which the effect is to be applied to the image. The predefined values range between 1.0 (low) and 3.0 (high).&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "sharpenValue")
    protected Float sharpenValue;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set, the color and brightness diversity of the image is selectively reduced and unified via a median filter. In general, this makes areas more uniform and more clearly distinguishable from their surroundings. This can lead to better recognition results, especially for images with a colored or grayscale background.&#13;
     *                         &lt;ul&gt;&lt;li&gt;off = Do not apply this optimization&lt;/li&gt;&lt;li&gt;value = Select your own value&lt;/li&gt;&lt;li&gt;low = Perform optimization only with low intensity to avoid information loss.&lt;/li&gt;&lt;li&gt;medium = Perform optimization with medium intensity.&lt;/li&gt;&lt;li&gt;high = Perform optimization with strong intensity and accept possible information losses.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "medianFilter")
    protected OptimizationIntensityType medianFilter;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Allows, in combination with the medianFilter mode "value", the free choice of a value for this optimization. An integer value greater than 0 specifies the grid size with which the effect is to be applied to the image. The predefined values range between 1 (low) and 3 (high).&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "medianFilterValue")
    protected Integer medianFilterValue;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Straight scans of pages can be created with a slight skew. If this value is set to true, an attempt is made to counter-rotate this skew and thus "deskew" the page. The results of this manipulation are visible in the resulting document.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isDeskew() {
        if (deskew == null) {
            return true;
        } else {
            return deskew;
        }
    }

    /**
     * Sets the value of the deskew property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isDeskew()
     */
    public void setDeskew(boolean value) {
        this.deskew = value;
    }

    public boolean isSetDeskew() {
        return (this.deskew!= null);
    }

    public void unsetDeskew() {
        this.deskew = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this mode is set, impurities and stains are reduced. These are caused, for example, by dust or dirt on the pane of a scanner. It is recommended to activate this optimization.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isDespeckle() {
        if (despeckle == null) {
            return true;
        } else {
            return despeckle;
        }
    }

    /**
     * Sets the value of the despeckle property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isDespeckle()
     */
    public void setDespeckle(boolean value) {
        this.despeckle = value;
    }

    public boolean isSetDespeckle() {
        return (this.despeckle!= null);
    }

    public void unsetDespeckle() {
        this.despeckle = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;In black and white images (including black and white scans), color values are often represented by a halftone according to their brightness (dithering / moiré effect). These halftones/hatchings translate a color value into a uniform sequence of black and white areas that visually appear to be a uniform area of the same color/brightness. Such patterns can be very difficult to delineate against actual text that may be in such a "colored" area. Setting this value to true will try to reduce such dithering patterns. This mode should only be set if absolutely necessary, as this process can be very lossy.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isReduceDithering() {
        if (reduceDithering == null) {
            return false;
        } else {
            return reduceDithering;
        }
    }

    /**
     * Sets the value of the reduceDithering property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isReduceDithering()
     */
    public void setReduceDithering(boolean value) {
        this.reduceDithering = value;
    }

    public boolean isSetReduceDithering() {
        return (this.reduceDithering!= null);
    }

    public void unsetReduceDithering() {
        this.reduceDithering = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this mode is set, an attempt is made to remove background noise from the image, which is caused by irregularities in the image background or by artifacts that can result from image compression. Such irregularities - especially around letters - can affect recognition. It is recommended to activate this optimization.&#13;
     *                         &lt;ul&gt;&lt;li&gt;off = Do not apply this optimization&lt;/li&gt;&lt;li&gt;value = Choose your own value&lt;/li&gt;&lt;li&gt;low = Perform optimization only with low intensity to avoid information loss.&lt;/li&gt;&lt;li&gt;medium = Perform optimization with medium intensity.&lt;/li&gt;&lt;li&gt;high = Perform optimization with high intensity and accept possible information losses.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link OptimizationIntensityType }
     *     
     */
    public OptimizationIntensityType getNoiseReduction() {
        if (noiseReduction == null) {
            return OptimizationIntensityType.LOW;
        } else {
            return noiseReduction;
        }
    }

    /**
     * Sets the value of the noiseReduction property.
     * 
     * @param value
     *     allowed object is
     *     {@link OptimizationIntensityType }
     *     
     * @see #getNoiseReduction()
     */
    public void setNoiseReduction(OptimizationIntensityType value) {
        this.noiseReduction = value;
    }

    public boolean isSetNoiseReduction() {
        return (this.noiseReduction!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Allows in combination with the noiseReduction mode "value" the free choice of a value for this optimization. A decimal value greater than 0 indicates the intensity with which the effect is to be applied to the image. The predefined values range between 1.0 (low) and 3.0 (high).&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Float }
     *     
     */
    public float getNoiseReductionValue() {
        if (noiseReductionValue == null) {
            return  1.0F;
        } else {
            return noiseReductionValue;
        }
    }

    /**
     * Sets the value of the noiseReductionValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link Float }
     *     
     * @see #getNoiseReductionValue()
     */
    public void setNoiseReductionValue(float value) {
        this.noiseReductionValue = value;
    }

    public boolean isSetNoiseReductionValue() {
        return (this.noiseReductionValue!= null);
    }

    public void unsetNoiseReductionValue() {
        this.noiseReductionValue = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This value should only be activated for very poorly exposed images. Selective light value spreading (compression) is used to emphasize the dark areas of the image over the light areas (gamma correction) and thus make detection possible at all. This mode should only be activated if absolutely necessary, since it can lead to strong information losses or otherwise make a recognition impossible. Together with an increase in image contrast, this optimization can be used, for example, to remove image backgrounds that would otherwise be difficult to distinguish from the letters applied to them.&#13;
     *                         &lt;ul&gt;&lt;li&gt;off = Do not apply this optimization&lt;/li&gt;&lt;li&gt;value = Select your own value&lt;/li&gt;&lt;li&gt;low = Perform optimization only with low intensity to avoid information loss.&lt;/li&gt;&lt;li&gt;medium = Perform optimization with medium intensity.&lt;/li&gt;&lt;li&gt;high = Perform optimization with strong intensity and accept possible information losses.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link OptimizationIntensityType }
     *     
     */
    public OptimizationIntensityType getGammaCorrection() {
        if (gammaCorrection == null) {
            return OptimizationIntensityType.OFF;
        } else {
            return gammaCorrection;
        }
    }

    /**
     * Sets the value of the gammaCorrection property.
     * 
     * @param value
     *     allowed object is
     *     {@link OptimizationIntensityType }
     *     
     * @see #getGammaCorrection()
     */
    public void setGammaCorrection(OptimizationIntensityType value) {
        this.gammaCorrection = value;
    }

    public boolean isSetGammaCorrection() {
        return (this.gammaCorrection!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Allows in combination with the gammaCorrection mode "value" the free choice of a value for this optimization. A comma value greater than 0 specifies the value to be applied to the image as gamma correction. The predefined values range between 1.5 (low) and 2.5 (high).&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Float }
     *     
     */
    public float getGammaCorrectionValue() {
        if (gammaCorrectionValue == null) {
            return  0.0F;
        } else {
            return gammaCorrectionValue;
        }
    }

    /**
     * Sets the value of the gammaCorrectionValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link Float }
     *     
     * @see #getGammaCorrectionValue()
     */
    public void setGammaCorrectionValue(float value) {
        this.gammaCorrectionValue = value;
    }

    public boolean isSetGammaCorrectionValue() {
        return (this.gammaCorrectionValue!= null);
    }

    public void unsetGammaCorrectionValue() {
        this.gammaCorrectionValue = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This value should only be activated for very poorly exposed images. By increasing the contrast, an attempt is made to emphasize the dark areas of the image over the light ones, thus making detection possible at all. This mode should only be activated if absolutely necessary, as it can lead to severe information loss or otherwise make detection impossible. Together with gamma correction, this optimization can be used, for example, to remove image backgrounds that would otherwise be difficult to distinguish from the letters applied to them.&#13;
     *                         &lt;ul&gt;&lt;li&gt;off = Do not apply this optimization&lt;/li&gt;&lt;li&gt;value = Choose your own value&lt;/li&gt;&lt;li&gt;low = Perform optimization only with low intensity to avoid information loss.&lt;/li&gt;&lt;li&gt;medium = Perform optimization with medium intensity.&lt;/li&gt;&lt;li&gt;high = Perform optimization with strong intensity and accept possible information losses.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link OptimizationIntensityType }
     *     
     */
    public OptimizationIntensityType getIncreaseContrast() {
        if (increaseContrast == null) {
            return OptimizationIntensityType.OFF;
        } else {
            return increaseContrast;
        }
    }

    /**
     * Sets the value of the increaseContrast property.
     * 
     * @param value
     *     allowed object is
     *     {@link OptimizationIntensityType }
     *     
     * @see #getIncreaseContrast()
     */
    public void setIncreaseContrast(OptimizationIntensityType value) {
        this.increaseContrast = value;
    }

    public boolean isSetIncreaseContrast() {
        return (this.increaseContrast!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Allows in combination with the increaseContrast mode "value" the free choice of a value for this optimization. An integer value between -100 and +100 specifies the intensity of the contrast enhancement. The predefined values range between 25 (low) and 75 (high).&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getIncreaseContrastValue() {
        if (increaseContrastValue == null) {
            return  0;
        } else {
            return increaseContrastValue;
        }
    }

    /**
     * Sets the value of the increaseContrastValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getIncreaseContrastValue()
     */
    public void setIncreaseContrastValue(int value) {
        this.increaseContrastValue = value;
    }

    public boolean isSetIncreaseContrastValue() {
        return (this.increaseContrastValue!= null);
    }

    public void unsetIncreaseContrastValue() {
        this.increaseContrastValue = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set, a Marr-Hildreth operator is used to accentuate the edges of the image. This optimization usually leads to significantly better recognition results, but can also lead to information loss.&#13;
     *                         &lt;ul&gt;&lt;li&gt;off = Do not apply this optimization&lt;/li&gt;&lt;li&gt;value = Choose your own value&lt;/li&gt;&lt;li&gt;low = Perform optimization only with low intensity to avoid information loss.&lt;/li&gt;&lt;li&gt;medium = Perform optimization with medium intensity.&lt;/li&gt;&lt;li&gt;high = Perform optimization with strong intensity and accept possible information losses.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link OptimizationIntensityType }
     *     
     */
    public OptimizationIntensityType getEdgeAccentuation() {
        if (edgeAccentuation == null) {
            return OptimizationIntensityType.LOW;
        } else {
            return edgeAccentuation;
        }
    }

    /**
     * Sets the value of the edgeAccentuation property.
     * 
     * @param value
     *     allowed object is
     *     {@link OptimizationIntensityType }
     *     
     * @see #getEdgeAccentuation()
     */
    public void setEdgeAccentuation(OptimizationIntensityType value) {
        this.edgeAccentuation = value;
    }

    public boolean isSetEdgeAccentuation() {
        return (this.edgeAccentuation!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Allows in combination with the edgeAccentuation mode "value" the free choice of a value for this optimization. An integer percentage value indicates the intensity of the edge accentuation. The actual image is overlaid with a corresponding sharpening filter for the edge accentuation - this percentage value specifies how intensively this effect should be emphasized compared to the original image. The predefined values range between 100 (low) and 200 percent (high).&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getEdgeAccentuationValue() {
        if (edgeAccentuationValue == null) {
            return  100;
        } else {
            return edgeAccentuationValue;
        }
    }

    /**
     * Sets the value of the edgeAccentuationValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getEdgeAccentuationValue()
     */
    public void setEdgeAccentuationValue(int value) {
        this.edgeAccentuationValue = value;
    }

    public boolean isSetEdgeAccentuationValue() {
        return (this.edgeAccentuationValue!= null);
    }

    public void unsetEdgeAccentuationValue() {
        this.edgeAccentuationValue = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set, edge sharpening is applied to the image. This optimization usually leads to significantly better recognition results, but can also lead to information loss.&#13;
     *                         &lt;ul&gt;&lt;li&gt;off = Do not apply this optimization&lt;/li&gt;&lt;li&gt;value = Select your own value&lt;/li&gt;&lt;li&gt;low = Apply optimization only with low intensity to avoid information loss.&lt;/li&gt;&lt;li&gt;medium = Perform optimization with medium intensity.&lt;/li&gt;&lt;li&gt;high = Perform optimization with strong intensity and accept possible information losses.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link OptimizationIntensityType }
     *     
     */
    public OptimizationIntensityType getSharpen() {
        if (sharpen == null) {
            return OptimizationIntensityType.LOW;
        } else {
            return sharpen;
        }
    }

    /**
     * Sets the value of the sharpen property.
     * 
     * @param value
     *     allowed object is
     *     {@link OptimizationIntensityType }
     *     
     * @see #getSharpen()
     */
    public void setSharpen(OptimizationIntensityType value) {
        this.sharpen = value;
    }

    public boolean isSetSharpen() {
        return (this.sharpen!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Allows in combination with the sharpen mode "value" the free choice of a value for this optimization. A comma value greater than 0 indicates the intensity with which the effect is to be applied to the image. The predefined values range between 1.0 (low) and 3.0 (high).&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Float }
     *     
     */
    public float getSharpenValue() {
        if (sharpenValue == null) {
            return  1.0F;
        } else {
            return sharpenValue;
        }
    }

    /**
     * Sets the value of the sharpenValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link Float }
     *     
     * @see #getSharpenValue()
     */
    public void setSharpenValue(float value) {
        this.sharpenValue = value;
    }

    public boolean isSetSharpenValue() {
        return (this.sharpenValue!= null);
    }

    public void unsetSharpenValue() {
        this.sharpenValue = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set, the color and brightness diversity of the image is selectively reduced and unified via a median filter. In general, this makes areas more uniform and more clearly distinguishable from their surroundings. This can lead to better recognition results, especially for images with a colored or grayscale background.&#13;
     *                         &lt;ul&gt;&lt;li&gt;off = Do not apply this optimization&lt;/li&gt;&lt;li&gt;value = Select your own value&lt;/li&gt;&lt;li&gt;low = Perform optimization only with low intensity to avoid information loss.&lt;/li&gt;&lt;li&gt;medium = Perform optimization with medium intensity.&lt;/li&gt;&lt;li&gt;high = Perform optimization with strong intensity and accept possible information losses.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link OptimizationIntensityType }
     *     
     */
    public OptimizationIntensityType getMedianFilter() {
        if (medianFilter == null) {
            return OptimizationIntensityType.LOW;
        } else {
            return medianFilter;
        }
    }

    /**
     * Sets the value of the medianFilter property.
     * 
     * @param value
     *     allowed object is
     *     {@link OptimizationIntensityType }
     *     
     * @see #getMedianFilter()
     */
    public void setMedianFilter(OptimizationIntensityType value) {
        this.medianFilter = value;
    }

    public boolean isSetMedianFilter() {
        return (this.medianFilter!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p400085_="https://jakarta.ee/xml/ns/jaxb" xmlns:p45416_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Allows, in combination with the medianFilter mode "value", the free choice of a value for this optimization. An integer value greater than 0 specifies the grid size with which the effect is to be applied to the image. The predefined values range between 1 (low) and 3 (high).&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getMedianFilterValue() {
        if (medianFilterValue == null) {
            return  1;
        } else {
            return medianFilterValue;
        }
    }

    /**
     * Sets the value of the medianFilterValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getMedianFilterValue()
     */
    public void setMedianFilterValue(int value) {
        this.medianFilterValue = value;
    }

    public boolean isSetMedianFilterValue() {
        return (this.medianFilterValue!= null);
    }

    public void unsetMedianFilterValue() {
        this.medianFilterValue = null;
    }

}
