
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p338479_="https://jakarta.ee/xml/ns/jaxb" xmlns:p733184_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If an attachment is embedded at the page level, this option can be used to specify the icon that should be used to show it:&lt;/p&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p338479_="https://jakarta.ee/xml/ns/jaxb" xmlns:p733184_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The value you use here will define which icon will be used, as well as the basic dimensions for the annotation generated in the PDF.&#13;
 *                     If you use the "None" icon type, a predefined icon will not be used. Instead, this option will only use the dimensions specified in "width" and "height" to generate an annotation with a transparent selection box at the specified position.&#13;
 *                     &lt;ul&gt;&lt;li&gt;graph = Diagram&lt;/li&gt;&lt;li&gt;paperclip = Paper clip&lt;/li&gt;&lt;li&gt;pushPin = Thumb tack&lt;/li&gt;&lt;li&gt;tag = Tag&lt;/li&gt;&lt;li&gt;none = Rectangular selection box&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for IconsType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="IconsType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="graph"/>
 *     <enumeration value="paperclip"/>
 *     <enumeration value="pushPin"/>
 *     <enumeration value="tag"/>
 *     <enumeration value="none"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "IconsType")
@XmlEnum
public enum IconsType {

    @XmlEnumValue("graph")
    GRAPH("graph"),
    @XmlEnumValue("paperclip")
    PAPERCLIP("paperclip"),
    @XmlEnumValue("pushPin")
    PUSH_PIN("pushPin"),
    @XmlEnumValue("tag")
    TAG("tag"),
    @XmlEnumValue("none")
    NONE("none");
    private final String value;

    IconsType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static IconsType fromValue(String v) {
        for (IconsType c: IconsType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
