
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Converts the given document into a HTML representation.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for HtmlTranscribeType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="HtmlTranscribeType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <all>
 *         <element name="svgFormat" type="{http://schema.webpdf.de/1.0/operation}SvgFormatType" minOccurs="0"/>
 *       </all>
 *       <attribute name="pages" type="{http://www.w3.org/2001/XMLSchema}string" default="1" />
 *       <attribute name="dpi" default="72">
 *         <simpleType>
 *           <restriction base="{http://schema.webpdf.de/1.0/operation}DpiType">
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "HtmlTranscribeType", propOrder = {

})
public class HtmlTranscribeType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects parameters for the creation of SVGs, possibly contained in resulting documents.&lt;/p&gt;
     * </pre>
     * 
     */
    protected SvgFormatType svgFormat;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies which page(s) to convert. The page number can be either a single page, a range of pages or a list (separated by commas) (e.g. "1,5-6,9"). The specification of all pages is done with "*".&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "pages")
    protected String pages;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This parameter sets the DPI resolution of the document. The larger the value, the larger the X/Y resolution of the document's pages and generated raster graphics. Also, as the DPI resolution increases, so does the byte size of the document.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "dpi")
    protected Integer dpi;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects parameters for the creation of SVGs, possibly contained in resulting documents.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link SvgFormatType }
     *     
     */
    public SvgFormatType getSvgFormat() {
        return svgFormat;
    }

    /**
     * Sets the value of the svgFormat property.
     * 
     * @param value
     *     allowed object is
     *     {@link SvgFormatType }
     *     
     * @see #getSvgFormat()
     */
    public void setSvgFormat(SvgFormatType value) {
        this.svgFormat = value;
    }

    public boolean isSetSvgFormat() {
        return (this.svgFormat!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies which page(s) to convert. The page number can be either a single page, a range of pages or a list (separated by commas) (e.g. "1,5-6,9"). The specification of all pages is done with "*".&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPages() {
        if (pages == null) {
            return "1";
        } else {
            return pages;
        }
    }

    /**
     * Sets the value of the pages property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getPages()
     */
    public void setPages(String value) {
        this.pages = value;
    }

    public boolean isSetPages() {
        return (this.pages!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This parameter sets the DPI resolution of the document. The larger the value, the larger the X/Y resolution of the document's pages and generated raster graphics. Also, as the DPI resolution increases, so does the byte size of the document.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getDpi() {
        if (dpi == null) {
            return  72;
        } else {
            return dpi;
        }
    }

    /**
     * Sets the value of the dpi property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getDpi()
     */
    public void setDpi(int value) {
        this.dpi = value;
    }

    public boolean isSetDpi() {
        return (this.dpi!= null);
    }

    public void unsetDpi() {
        this.dpi = null;
    }

}
