
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The goTo element jumps to a specific place (destination) in the document. The goTo Element represents a triggerable action. There can only be one single subelement. Each one of the specified subelements represents a known destination in the document that can be jumped to.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for GoToDestinationActionType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="GoToDestinationActionType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}ActionEventType">
 *       <choice>
 *         <element name="zoomPage" type="{http://schema.webpdf.de/1.0/operation}ZoomDestinationType"/>
 *         <element name="fitPage" type="{http://schema.webpdf.de/1.0/operation}FitPageDestinationType"/>
 *         <element name="fitWidth" type="{http://schema.webpdf.de/1.0/operation}FitWidthDestinationType"/>
 *         <element name="fitHeight" type="{http://schema.webpdf.de/1.0/operation}FitHeightDestinationType"/>
 *         <element name="fitRectangle" type="{http://schema.webpdf.de/1.0/operation}FitRectangleDestinationType"/>
 *         <element name="fitBoundingBox" type="{http://schema.webpdf.de/1.0/operation}FitBoundingBoxDestinationType"/>
 *         <element name="fitBoundingBoxWidth" type="{http://schema.webpdf.de/1.0/operation}FitBoundingBoxWidthDestinationType"/>
 *         <element name="goToNamed" type="{http://schema.webpdf.de/1.0/operation}NamedDestinationType"/>
 *       </choice>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "GoToDestinationActionType", propOrder = {
    "destination"
})
public class GoToDestinationActionType
    extends ActionEventType
{

    @XmlElements({
        @XmlElement(name = "zoomPage", type = ZoomDestinationType.class),
        @XmlElement(name = "fitPage", type = FitPageDestinationType.class),
        @XmlElement(name = "fitWidth", type = FitWidthDestinationType.class),
        @XmlElement(name = "fitHeight", type = FitHeightDestinationType.class),
        @XmlElement(name = "fitRectangle", type = FitRectangleDestinationType.class),
        @XmlElement(name = "fitBoundingBox", type = FitBoundingBoxDestinationType.class),
        @XmlElement(name = "fitBoundingBoxWidth", type = FitBoundingBoxWidthDestinationType.class),
        @XmlElement(name = "goToNamed", type = NamedDestinationType.class)
    })
    protected DestinationEventType destination;

    /**
     * Gets the value of the destination property.
     * 
     * @return
     *     possible object is
     *     {@link FitBoundingBoxDestinationType }
     *     {@link FitBoundingBoxWidthDestinationType }
     *     {@link FitHeightDestinationType }
     *     {@link FitPageDestinationType }
     *     {@link FitRectangleDestinationType }
     *     {@link FitWidthDestinationType }
     *     {@link NamedDestinationType }
     *     {@link ZoomDestinationType }
     *     
     */
    public DestinationEventType getDestination() {
        return destination;
    }

    /**
     * Sets the value of the destination property.
     * 
     * @param value
     *     allowed object is
     *     {@link FitBoundingBoxDestinationType }
     *     {@link FitBoundingBoxWidthDestinationType }
     *     {@link FitHeightDestinationType }
     *     {@link FitPageDestinationType }
     *     {@link FitRectangleDestinationType }
     *     {@link FitWidthDestinationType }
     *     {@link NamedDestinationType }
     *     {@link ZoomDestinationType }
     *     
     */
    public void setDestination(DestinationEventType value) {
        this.destination = value;
    }

    public boolean isSetDestination() {
        return (this.destination!= null);
    }

}
