
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the location and additional parameters for running an application or opening a document.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for FileSpecificationType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="FileSpecificationType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="volatileFile" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="description" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="resourceURL" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "FileSpecificationType")
public class FileSpecificationType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This value should be set to true if the selected document will be subject to changes continuously and the reader application should be forced to continuously reload the document instead of caching it.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "volatileFile")
    protected Boolean volatileFile;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A description of the application that should be opened.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "description")
    protected String description;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The path or URL for the application / document. Use forward slashes as path separators. It is potentially possible to use platform-specific characters, but this is not recommended. If you do end up using platform-specific characters anyway, they must be preceded by a backslash (‘\').&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "resourceURL")
    protected String resourceURL;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This value should be set to true if the selected document will be subject to changes continuously and the reader application should be forced to continuously reload the document instead of caching it.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isVolatileFile() {
        if (volatileFile == null) {
            return false;
        } else {
            return volatileFile;
        }
    }

    /**
     * Sets the value of the volatileFile property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isVolatileFile()
     */
    public void setVolatileFile(boolean value) {
        this.volatileFile = value;
    }

    public boolean isSetVolatileFile() {
        return (this.volatileFile!= null);
    }

    public void unsetVolatileFile() {
        this.volatileFile = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A description of the application that should be opened.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDescription() {
        if (description == null) {
            return "";
        } else {
            return description;
        }
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getDescription()
     */
    public void setDescription(String value) {
        this.description = value;
    }

    public boolean isSetDescription() {
        return (this.description!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The path or URL for the application / document. Use forward slashes as path separators. It is potentially possible to use platform-specific characters, but this is not recommended. If you do end up using platform-specific characters anyway, they must be preceded by a backslash (‘\').&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getResourceURL() {
        if (resourceURL == null) {
            return "";
        } else {
            return resourceURL;
        }
    }

    /**
     * Sets the value of the resourceURL property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getResourceURL()
     */
    public void setResourceURL(String value) {
        this.resourceURL = value;
    }

    public boolean isSetResourceURL() {
        return (this.resourceURL!= null);
    }

}
