
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Extract all the words from the PDF document, with page and position information.&lt;/p&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Generates an ASCII text, XML, or JSON file that will be returned as a result when the web service is called. For each found word, the file will contain the page number and the X-axis and Y-axis coordinates of the word. When the TEXT output format is selected, only the word's text will be output, separated with line breaks.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for ExtractionWordsType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ExtractionWordsType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}BaseExtractionType">
 *       <attribute name="removePunctuation" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="delimitAfterPunctuation" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="extendedSequenceCharacters" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ExtractionWordsType")
public class ExtractionWordsType
    extends BaseExtractionType
{

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify whether punctuation marks should be included in the export or whether they should be explicitly removed.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "removePunctuation")
    protected Boolean removePunctuation;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this attribute is set to true, a new word will be started after each punctuation mark.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "delimitAfterPunctuation")
    protected Boolean delimitAfterPunctuation;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This attribute specifies whether quotation marks and apostrophes should be handled the same way as brackets (such as parentheses and square brackets), i.e., whether they should be placed before the word they enclose.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "extendedSequenceCharacters")
    protected Boolean extendedSequenceCharacters;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify whether punctuation marks should be included in the export or whether they should be explicitly removed.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isRemovePunctuation() {
        if (removePunctuation == null) {
            return false;
        } else {
            return removePunctuation;
        }
    }

    /**
     * Sets the value of the removePunctuation property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isRemovePunctuation()
     */
    public void setRemovePunctuation(boolean value) {
        this.removePunctuation = value;
    }

    public boolean isSetRemovePunctuation() {
        return (this.removePunctuation!= null);
    }

    public void unsetRemovePunctuation() {
        this.removePunctuation = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this attribute is set to true, a new word will be started after each punctuation mark.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isDelimitAfterPunctuation() {
        if (delimitAfterPunctuation == null) {
            return true;
        } else {
            return delimitAfterPunctuation;
        }
    }

    /**
     * Sets the value of the delimitAfterPunctuation property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isDelimitAfterPunctuation()
     */
    public void setDelimitAfterPunctuation(boolean value) {
        this.delimitAfterPunctuation = value;
    }

    public boolean isSetDelimitAfterPunctuation() {
        return (this.delimitAfterPunctuation!= null);
    }

    public void unsetDelimitAfterPunctuation() {
        this.delimitAfterPunctuation = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This attribute specifies whether quotation marks and apostrophes should be handled the same way as brackets (such as parentheses and square brackets), i.e., whether they should be placed before the word they enclose.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isExtendedSequenceCharacters() {
        if (extendedSequenceCharacters == null) {
            return false;
        } else {
            return extendedSequenceCharacters;
        }
    }

    /**
     * Sets the value of the extendedSequenceCharacters property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isExtendedSequenceCharacters()
     */
    public void setExtendedSequenceCharacters(boolean value) {
        this.extendedSequenceCharacters = value;
    }

    public boolean isSetExtendedSequenceCharacters() {
        return (this.extendedSequenceCharacters!= null);
    }

    public void unsetExtendedSequenceCharacters() {
        this.extendedSequenceCharacters = null;
    }

}
