
package net.webpdf.wsclient.schema.operation;

import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p296078_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p595873_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;These parameters can be used to set the asymmetric encryption of a PDF document.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for EncryptCertificateType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="EncryptCertificateType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="recipient" type="{http://schema.webpdf.de/1.0/operation}RecipientType" maxOccurs="unbounded"/>
 *       </sequence>
 *       <attribute name="encryptionKey" type="{http://schema.webpdf.de/1.0/operation}PdfEncryptionKeyType" default="RC4_128" />
 *       <attribute name="contentEncryption" type="{http://schema.webpdf.de/1.0/operation}PdfContentEncryptionType" default="encryptEverything" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "EncryptCertificateType", propOrder = {
    "recipient"
})
public class EncryptCertificateType {

    @XmlElement(required = true)
    protected List<RecipientType> recipient;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p296078_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p595873_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Sets the encryption level for the document.&#13;
     *                         &lt;ul&gt;&lt;li&gt;RC4_40 = 40-bit RC4&lt;/li&gt;&lt;li&gt;RC4_128 = 128-bit RC4&lt;/li&gt;&lt;li&gt;AES_128 = 128-bit AES&lt;/li&gt;&lt;li&gt;AES_256 = 256-bit AES&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p296078_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p595873_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                         Please note that the option "256-bit AES" only works if the "Java Cryptography Extension (JCE)" has been enabled with "Unlimited Strength" in the JVM. You can obtain the modified "Policy Files" (along with instructions for installation) from the Oracle website:&#13;
     *                         Java Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy Files 7 Download:&#13;
     *                         http://www.oracle.com/technetwork/java/javase/downloads/jce-7-download-432124.html&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "encryptionKey")
    protected PdfEncryptionKeyType encryptionKey;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p296078_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p595873_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies whether certain contents should be treated differently than others during encryption.&#13;
     *                         &lt;ul&gt;&lt;li&gt;encryptEverything = All contents of the document are encrypted without distinction (if provided by the standard).&lt;/li&gt;&lt;li&gt;exposeMetadata = The document's metadata is left unencrypted to make it discoverable by processing programs. (Has an effect only for 128 bit and 256 bit AES).&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "contentEncryption")
    protected PdfContentEncryptionType contentEncryption;

    /**
     * Gets the value of the recipient property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the recipient property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getRecipient().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link RecipientType }
     * </p>
     * 
     * 
     * @return
     *     The value of the recipient property.
     */
    public List<RecipientType> getRecipient() {
        if (recipient == null) {
            recipient = new ArrayList<>();
        }
        return this.recipient;
    }

    public boolean isSetRecipient() {
        return ((this.recipient!= null)&&(!this.recipient.isEmpty()));
    }

    public void unsetRecipient() {
        this.recipient = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p296078_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p595873_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Sets the encryption level for the document.&#13;
     *                         &lt;ul&gt;&lt;li&gt;RC4_40 = 40-bit RC4&lt;/li&gt;&lt;li&gt;RC4_128 = 128-bit RC4&lt;/li&gt;&lt;li&gt;AES_128 = 128-bit AES&lt;/li&gt;&lt;li&gt;AES_256 = 256-bit AES&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p296078_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p595873_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                         Please note that the option "256-bit AES" only works if the "Java Cryptography Extension (JCE)" has been enabled with "Unlimited Strength" in the JVM. You can obtain the modified "Policy Files" (along with instructions for installation) from the Oracle website:&#13;
     *                         Java Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy Files 7 Download:&#13;
     *                         http://www.oracle.com/technetwork/java/javase/downloads/jce-7-download-432124.html&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link PdfEncryptionKeyType }
     *     
     */
    public PdfEncryptionKeyType getEncryptionKey() {
        if (encryptionKey == null) {
            return PdfEncryptionKeyType.RC_4_128;
        } else {
            return encryptionKey;
        }
    }

    /**
     * Sets the value of the encryptionKey property.
     * 
     * @param value
     *     allowed object is
     *     {@link PdfEncryptionKeyType }
     *     
     * @see #getEncryptionKey()
     */
    public void setEncryptionKey(PdfEncryptionKeyType value) {
        this.encryptionKey = value;
    }

    public boolean isSetEncryptionKey() {
        return (this.encryptionKey!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p296078_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p595873_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies whether certain contents should be treated differently than others during encryption.&#13;
     *                         &lt;ul&gt;&lt;li&gt;encryptEverything = All contents of the document are encrypted without distinction (if provided by the standard).&lt;/li&gt;&lt;li&gt;exposeMetadata = The document's metadata is left unencrypted to make it discoverable by processing programs. (Has an effect only for 128 bit and 256 bit AES).&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link PdfContentEncryptionType }
     *     
     */
    public PdfContentEncryptionType getContentEncryption() {
        if (contentEncryption == null) {
            return PdfContentEncryptionType.ENCRYPT_EVERYTHING;
        } else {
            return contentEncryption;
        }
    }

    /**
     * Sets the value of the contentEncryption property.
     * 
     * @param value
     *     allowed object is
     *     {@link PdfContentEncryptionType }
     *     
     * @see #getContentEncryption()
     */
    public void setContentEncryption(PdfContentEncryptionType value) {
        this.contentEncryption = value;
    }

    public boolean isSetContentEncryption() {
        return (this.contentEncryption!= null);
    }

}
