
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Sets whether and how pages are to be printed on both sides. (This setting is only a dialog default and can be changed by the user at any time).&#13;
 *                     &lt;ul&gt;&lt;li&gt;simplex = Print on one side.&lt;/li&gt;&lt;li&gt;duplexFlipLongEdge = Print on both sides and flip over the longer edge of the page.&lt;/li&gt;&lt;li&gt;duplexFlipShortEdge = Print on both sides and flip over the shorter side edge.&lt;/li&gt;&lt;li&gt;none = Use the default settings of the display program.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for DuplexType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="DuplexType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="none"/>
 *     <enumeration value="simplex"/>
 *     <enumeration value="duplexFlipShortEdge"/>
 *     <enumeration value="duplexFlipLongEdge"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "DuplexType")
@XmlEnum
public enum DuplexType {

    @XmlEnumValue("none")
    NONE("none"),
    @XmlEnumValue("simplex")
    SIMPLEX("simplex"),
    @XmlEnumValue("duplexFlipShortEdge")
    DUPLEX_FLIP_SHORT_EDGE("duplexFlipShortEdge"),
    @XmlEnumValue("duplexFlipLongEdge")
    DUPLEX_FLIP_LONG_EDGE("duplexFlipLongEdge");
    private final String value;

    DuplexType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static DuplexType fromValue(String v) {
        for (DuplexType c: DuplexType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
