
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p117921_="https://jakarta.ee/xml/ns/jaxb" xmlns:p71612_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;These settings are only used for HTML (e.g. websites) and HTML-based documents (e.g. e-mails).&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for ConverterHtmlType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ConverterHtmlType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <all>
 *         <element name="templateData" type="{http://schema.webpdf.de/1.0/operation}TemplateDataType" minOccurs="0"/>
 *         <element name="errorReport" type="{http://schema.webpdf.de/1.0/operation}ConverterHtmlErrorReportType" minOccurs="0"/>
 *       </all>
 *       <attribute name="downloadImages" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="adjustFonts" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="baseURL" type="{http://www.w3.org/2001/XMLSchema}anyURI" default="" />
 *       <attribute name="useAsTemplate" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="useBackground" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="preferCSSPageSize" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="imageMode" type="{http://schema.webpdf.de/1.0/operation}ConverterHtmlImageModeType" default="base64" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ConverterHtmlType", propOrder = {

})
public class ConverterHtmlType {

    protected TemplateDataType templateData;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p117921_="https://jakarta.ee/xml/ns/jaxb" xmlns:p71612_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&#13;
     *                             This parameter specifies whether HTML content errors should be detected and, if so, whether a report should be provided along with the error code. The report is created only if at least one error was found. If the parameter is not specified, then any errors that may occur in the HTML document will not be detected and will be silently ignored.&#13;
     *                             &lt;p&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                                 This parameter refers only to the content of the passed HTML document and not to the web service call itself.&#13;
     *                             &lt;/p&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    protected ConverterHtmlErrorReportType errorReport;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p117921_="https://jakarta.ee/xml/ns/jaxb" xmlns:p71612_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true", then externally referenced images of the HTML document are downloaded and inserted into the document. If false, the images are not downloaded and the external references to the image are removed, leaving already embedded images intact.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "downloadImages")
    protected Boolean downloadImages;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p117921_="https://jakarta.ee/xml/ns/jaxb" xmlns:p71612_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true", then the font specifications "Arial", "Helvetica" and "Sans-Serif" in HTML documents and e-mails (which are based on HTML) are automatically replaced by the "Arial Unicode MS" font. The improves the appearance of the typeface in the PDF result.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "adjustFonts")
    protected Boolean adjustFonts;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p117921_="https://jakarta.ee/xml/ns/jaxb" xmlns:p71612_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the URL that will be the base for all URLs in the HTML document that are not defined as absolute URLs. The URL must be absolute and contain a scheme (e.g. 'http' or 'https'); the scheme 'file' is not allowed.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "baseURL")
    @XmlSchemaType(name = "anyURI")
    protected String baseURL;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p117921_="https://jakarta.ee/xml/ns/jaxb" xmlns:p71612_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true", the HTML document will be interpreted as a template, i.e., the system will search for variables in the HTML and replace them with the data passed in "templateData". The document will not be converted to HTML format until after this step is completed. This means that by using the HTML document as a template together with passed data, you can obtain a dynamically generated PDF document.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "useAsTemplate")
    protected Boolean useAsTemplate;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p117921_="https://jakarta.ee/xml/ns/jaxb" xmlns:p71612_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true", the background defined in the HTML document will be output in the PDF document as well. If "false", the background will be hidden.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "useBackground")
    protected Boolean useBackground;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p117921_="https://jakarta.ee/xml/ns/jaxb" xmlns:p71612_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true", then the page size and margins are preferentially used from the CSS. Otherwise, the sizes from the passed page parameter are used.&#13;
     *                         The values can also be only partially overwritten, so that e.g. the page size is determined by the parameter values and the page margins are defined in the CSS.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "preferCSSPageSize")
    protected Boolean preferCSSPageSize;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p117921_="https://jakarta.ee/xml/ns/jaxb" xmlns:p71612_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This defines how downloaded images are inserted into the HTML content (with reference to the &lt;code&gt;&amp;lt;downloadImages&amp;gt;&lt;/code&gt; parameter). When referencing large images in the HTML content, it is recommended to use &lt;code&gt;&amp;lt;file&amp;gt;&lt;/code&gt; to reduce the size of the HTML file and speed up the rendering of the HTML.&#13;
     *                         &lt;ul&gt;&lt;li&gt;base64 = embed images as BASE64 content&lt;/li&gt;&lt;li&gt;file = embed images as file links to local temporary files&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "imageMode")
    protected ConverterHtmlImageModeType imageMode;

    /**
     * Gets the value of the templateData property.
     * 
     * @return
     *     possible object is
     *     {@link TemplateDataType }
     *     
     */
    public TemplateDataType getTemplateData() {
        return templateData;
    }

    /**
     * Sets the value of the templateData property.
     * 
     * @param value
     *     allowed object is
     *     {@link TemplateDataType }
     *     
     */
    public void setTemplateData(TemplateDataType value) {
        this.templateData = value;
    }

    public boolean isSetTemplateData() {
        return (this.templateData!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p117921_="https://jakarta.ee/xml/ns/jaxb" xmlns:p71612_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&#13;
     *                             This parameter specifies whether HTML content errors should be detected and, if so, whether a report should be provided along with the error code. The report is created only if at least one error was found. If the parameter is not specified, then any errors that may occur in the HTML document will not be detected and will be silently ignored.&#13;
     *                             &lt;p&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                                 This parameter refers only to the content of the passed HTML document and not to the web service call itself.&#13;
     *                             &lt;/p&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link ConverterHtmlErrorReportType }
     *     
     */
    public ConverterHtmlErrorReportType getErrorReport() {
        return errorReport;
    }

    /**
     * Sets the value of the errorReport property.
     * 
     * @param value
     *     allowed object is
     *     {@link ConverterHtmlErrorReportType }
     *     
     * @see #getErrorReport()
     */
    public void setErrorReport(ConverterHtmlErrorReportType value) {
        this.errorReport = value;
    }

    public boolean isSetErrorReport() {
        return (this.errorReport!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p117921_="https://jakarta.ee/xml/ns/jaxb" xmlns:p71612_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true", then externally referenced images of the HTML document are downloaded and inserted into the document. If false, the images are not downloaded and the external references to the image are removed, leaving already embedded images intact.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isDownloadImages() {
        if (downloadImages == null) {
            return false;
        } else {
            return downloadImages;
        }
    }

    /**
     * Sets the value of the downloadImages property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isDownloadImages()
     */
    public void setDownloadImages(boolean value) {
        this.downloadImages = value;
    }

    public boolean isSetDownloadImages() {
        return (this.downloadImages!= null);
    }

    public void unsetDownloadImages() {
        this.downloadImages = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p117921_="https://jakarta.ee/xml/ns/jaxb" xmlns:p71612_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true", then the font specifications "Arial", "Helvetica" and "Sans-Serif" in HTML documents and e-mails (which are based on HTML) are automatically replaced by the "Arial Unicode MS" font. The improves the appearance of the typeface in the PDF result.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isAdjustFonts() {
        if (adjustFonts == null) {
            return false;
        } else {
            return adjustFonts;
        }
    }

    /**
     * Sets the value of the adjustFonts property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isAdjustFonts()
     */
    public void setAdjustFonts(boolean value) {
        this.adjustFonts = value;
    }

    public boolean isSetAdjustFonts() {
        return (this.adjustFonts!= null);
    }

    public void unsetAdjustFonts() {
        this.adjustFonts = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p117921_="https://jakarta.ee/xml/ns/jaxb" xmlns:p71612_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the URL that will be the base for all URLs in the HTML document that are not defined as absolute URLs. The URL must be absolute and contain a scheme (e.g. 'http' or 'https'); the scheme 'file' is not allowed.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBaseURL() {
        if (baseURL == null) {
            return "";
        } else {
            return baseURL;
        }
    }

    /**
     * Sets the value of the baseURL property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getBaseURL()
     */
    public void setBaseURL(String value) {
        this.baseURL = value;
    }

    public boolean isSetBaseURL() {
        return (this.baseURL!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p117921_="https://jakarta.ee/xml/ns/jaxb" xmlns:p71612_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true", the HTML document will be interpreted as a template, i.e., the system will search for variables in the HTML and replace them with the data passed in "templateData". The document will not be converted to HTML format until after this step is completed. This means that by using the HTML document as a template together with passed data, you can obtain a dynamically generated PDF document.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isUseAsTemplate() {
        if (useAsTemplate == null) {
            return false;
        } else {
            return useAsTemplate;
        }
    }

    /**
     * Sets the value of the useAsTemplate property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isUseAsTemplate()
     */
    public void setUseAsTemplate(boolean value) {
        this.useAsTemplate = value;
    }

    public boolean isSetUseAsTemplate() {
        return (this.useAsTemplate!= null);
    }

    public void unsetUseAsTemplate() {
        this.useAsTemplate = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p117921_="https://jakarta.ee/xml/ns/jaxb" xmlns:p71612_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true", the background defined in the HTML document will be output in the PDF document as well. If "false", the background will be hidden.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isUseBackground() {
        if (useBackground == null) {
            return true;
        } else {
            return useBackground;
        }
    }

    /**
     * Sets the value of the useBackground property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isUseBackground()
     */
    public void setUseBackground(boolean value) {
        this.useBackground = value;
    }

    public boolean isSetUseBackground() {
        return (this.useBackground!= null);
    }

    public void unsetUseBackground() {
        this.useBackground = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p117921_="https://jakarta.ee/xml/ns/jaxb" xmlns:p71612_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true", then the page size and margins are preferentially used from the CSS. Otherwise, the sizes from the passed page parameter are used.&#13;
     *                         The values can also be only partially overwritten, so that e.g. the page size is determined by the parameter values and the page margins are defined in the CSS.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isPreferCSSPageSize() {
        if (preferCSSPageSize == null) {
            return false;
        } else {
            return preferCSSPageSize;
        }
    }

    /**
     * Sets the value of the preferCSSPageSize property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isPreferCSSPageSize()
     */
    public void setPreferCSSPageSize(boolean value) {
        this.preferCSSPageSize = value;
    }

    public boolean isSetPreferCSSPageSize() {
        return (this.preferCSSPageSize!= null);
    }

    public void unsetPreferCSSPageSize() {
        this.preferCSSPageSize = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p117921_="https://jakarta.ee/xml/ns/jaxb" xmlns:p71612_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This defines how downloaded images are inserted into the HTML content (with reference to the &lt;code&gt;&amp;lt;downloadImages&amp;gt;&lt;/code&gt; parameter). When referencing large images in the HTML content, it is recommended to use &lt;code&gt;&amp;lt;file&amp;gt;&lt;/code&gt; to reduce the size of the HTML file and speed up the rendering of the HTML.&#13;
     *                         &lt;ul&gt;&lt;li&gt;base64 = embed images as BASE64 content&lt;/li&gt;&lt;li&gt;file = embed images as file links to local temporary files&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link ConverterHtmlImageModeType }
     *     
     */
    public ConverterHtmlImageModeType getImageMode() {
        if (imageMode == null) {
            return ConverterHtmlImageModeType.BASE_64;
        } else {
            return imageMode;
        }
    }

    /**
     * Sets the value of the imageMode property.
     * 
     * @param value
     *     allowed object is
     *     {@link ConverterHtmlImageModeType }
     *     
     * @see #getImageMode()
     */
    public void setImageMode(ConverterHtmlImageModeType value) {
        this.imageMode = value;
    }

    public boolean isSetImageMode() {
        return (this.imageMode!= null);
    }

}
