
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Adds a solid-color background layer to the document.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for ColorBackgroundType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ColorBackgroundType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}BackgroundBaseType">
 *       <all>
 *         <element name="settings" type="{http://schema.webpdf.de/1.0/operation}BackgroundBaseSettingsType" minOccurs="0"/>
 *       </all>
 *       <attribute name="color" type="{http://schema.webpdf.de/1.0/operation}RgbColorType" default="#FFFFFF" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ColorBackgroundType", propOrder = {
    "settings"
})
public class ColorBackgroundType
    extends BackgroundBaseType
{

    protected BackgroundBaseSettingsType settings;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the colour for the background layer. The colour needs to be specified as a hexadecimal RGB value with a number sign before it.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "color")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    protected String color;

    /**
     * Gets the value of the settings property.
     * 
     * @return
     *     possible object is
     *     {@link BackgroundBaseSettingsType }
     *     
     */
    public BackgroundBaseSettingsType getSettings() {
        return settings;
    }

    /**
     * Sets the value of the settings property.
     * 
     * @param value
     *     allowed object is
     *     {@link BackgroundBaseSettingsType }
     *     
     */
    public void setSettings(BackgroundBaseSettingsType value) {
        this.settings = value;
    }

    public boolean isSetSettings() {
        return (this.settings!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the colour for the background layer. The colour needs to be specified as a hexadecimal RGB value with a number sign before it.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getColor() {
        if (color == null) {
            return "#FFFFFF";
        } else {
            return color;
        }
    }

    /**
     * Sets the value of the color property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getColor()
     */
    public void setColor(String value) {
        this.color = value;
    }

    public boolean isSetColor() {
        return (this.color!= null);
    }

}
