
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p343700_="https://jakarta.ee/xml/ns/jaxb" xmlns:p472644_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p752341_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to select the format of the file with the contents that will be scanned for barcodes.&#13;
 *                     &lt;ul&gt;&lt;li&gt;pdf = PDF document&lt;/li&gt;&lt;li&gt;img = Image document (JPG, PNG, TIF)&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for BarcodeDetectInputFormatType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="BarcodeDetectInputFormatType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="pdf"/>
 *     <enumeration value="img"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "BarcodeDetectInputFormatType")
@XmlEnum
public enum BarcodeDetectInputFormatType {

    @XmlEnumValue("pdf")
    PDF("pdf"),
    @XmlEnumValue("img")
    IMG("img");
    private final String value;

    BarcodeDetectInputFormatType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static BarcodeDetectInputFormatType fromValue(String v) {
        for (BarcodeDetectInputFormatType c: BarcodeDetectInputFormatType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
