
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The encoding of the audio file. Possible values are:&#13;
 *                     &lt;ul&gt;&lt;li&gt;Raw&lt;/li&gt;&lt;li&gt;Signed&lt;/li&gt;&lt;li&gt;muLaw&lt;/li&gt;&lt;li&gt;ALaw&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for AudioEncodingType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="AudioEncodingType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="Raw"/>
 *     <enumeration value="Signed"/>
 *     <enumeration value="muLaw"/>
 *     <enumeration value="ALaw"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "AudioEncodingType")
@XmlEnum
public enum AudioEncodingType {

    @XmlEnumValue("Raw")
    RAW("Raw"),
    @XmlEnumValue("Signed")
    SIGNED("Signed"),
    @XmlEnumValue("muLaw")
    MU_LAW("muLaw"),
    @XmlEnumValue("ALaw")
    A_LAW("ALaw");
    private final String value;

    AudioEncodingType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static AudioEncodingType fromValue(String v) {
        for (AudioEncodingType c: AudioEncodingType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
