
package net.webpdf.wsclient.schema.extraction.info;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Lists a set of further settings and definitions, that a Reader may honor, when displaying the document.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for ViewerPreferencesType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ViewerPreferencesType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="hideToolbar" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="hideMenuBar" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="hideWindowUI" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="fitWindow" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="centerWindow" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="displayDocTitle" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="nonFullScreenPageMode" type="{http://schema.webpdf.de/1.0/extraction/info}NonFullScreenPageModeType" default="none" />
 *       <attribute name="textDirection" type="{http://schema.webpdf.de/1.0/extraction/info}TextDirectionType" default="leftToRight" />
 *       <attribute name="viewArea" type="{http://schema.webpdf.de/1.0/extraction/info}BoxSelectionType" default="cropBox" />
 *       <attribute name="viewClip" type="{http://schema.webpdf.de/1.0/extraction/info}BoxSelectionType" default="cropBox" />
 *       <attribute name="printArea" type="{http://schema.webpdf.de/1.0/extraction/info}BoxSelectionType" default="cropBox" />
 *       <attribute name="printClip" type="{http://schema.webpdf.de/1.0/extraction/info}BoxSelectionType" default="cropBox" />
 *       <attribute name="printScaling" type="{http://schema.webpdf.de/1.0/extraction/info}PrintScaleType" default="readerDefault" />
 *       <attribute name="duplex" type="{http://schema.webpdf.de/1.0/extraction/info}DuplexType" default="none" />
 *       <attribute name="printTraySelection" type="{http://schema.webpdf.de/1.0/extraction/info}PrintTraySelectionType" default="readerDefault" />
 *       <attribute name="printPageRange" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="numCopies" default="1">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="1"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ViewerPreferencesType")
public class ViewerPreferencesType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The Reader's toolbars shall be hidden, when opening the document.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "hideToolbar")
    protected Boolean hideToolbar;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The Reader's menu bar shall be hidden, when opening the document.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "hideMenuBar")
    protected Boolean hideMenuBar;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The Reader's navigation controls (such as scrollbars) shall be hidden, when opening the document.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "hideWindowUI")
    protected Boolean hideWindowUI;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The dimensions of the Reader's window shall adapt to the first displayed page of the document.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "fitWindow")
    protected Boolean fitWindow;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The Reader's window shall be positioned at the center of the screen, when opening the document.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "centerWindow")
    protected Boolean centerWindow;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Instead of the file name the reader shall display the title of the document in it's title bar.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "displayDocTitle")
    protected Boolean displayDocTitle;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;When displaying the document in windowed mode, the Reader shall show the selected panel.&#13;
     *                         &lt;ul&gt;&lt;li&gt;none = No panel shall be opened.&lt;/li&gt;&lt;li&gt;outlines = The document's outlines shall be displayed.&lt;/li&gt;&lt;li&gt;thumbnails = The document's page thumbnails shall be shown.&lt;/li&gt;&lt;li&gt;optionalContents = document's layers (OCGs - Optional Content Groups) shall be displayed.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "nonFullScreenPageMode")
    protected NonFullScreenPageModeType nonFullScreenPageMode;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the predominant document's text writing/reading direction.&#13;
     *                         &lt;ul&gt;&lt;li&gt;leftToRight or&lt;/li&gt;&lt;li&gt;rightToLeft&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "textDirection")
    protected TextDirectionType textDirection;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the visible box, when displaying the document.&#13;
     *                         &lt;ul&gt;&lt;li&gt;media_box = The page's physical dimensions.&lt;/li&gt;&lt;li&gt;crop_box = The visible (printable) page area.&lt;/li&gt;&lt;li&gt;bleed_box = Untrimmed content position on the page (content dimensions plus trim box).&lt;/li&gt;&lt;li&gt;trim_box = Trimmed content position on the page (final content dimensions).&lt;/li&gt;&lt;li&gt;art_box = Position for special page content (images).&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "viewArea")
    protected BoxSelectionType viewArea;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the box contents shall be cropped at, when displaying the document.&#13;
     *                         &lt;ul&gt;&lt;li&gt;media_box = The page's physical dimensions.&lt;/li&gt;&lt;li&gt;crop_box = The visible (printable) page area.&lt;/li&gt;&lt;li&gt;bleed_box = Untrimmed content position on the page (content dimensions plus trim box).&lt;/li&gt;&lt;li&gt;trim_box = Trimmed content position on the page (final content dimensions).&lt;/li&gt;&lt;li&gt;art_box = Position for special page content (images).&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "viewClip")
    protected BoxSelectionType viewClip;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the visible box, when printing the document.&#13;
     *                         &lt;ul&gt;&lt;li&gt;media_box = The page's physical dimensions.&lt;/li&gt;&lt;li&gt;crop_box = The visible (printable) page area.&lt;/li&gt;&lt;li&gt;bleed_box = Untrimmed content position on the page (content dimensions plus trim box).&lt;/li&gt;&lt;li&gt;trim_box = Trimmed content position on the page (final content dimensions).&lt;/li&gt;&lt;li&gt;art_box = Position for special page content (images).&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "printArea")
    protected BoxSelectionType printArea;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the box contents shall be cropped at, when printing the document.&#13;
     *                         &lt;ul&gt;&lt;li&gt;media_box = The page's physical dimensions.&lt;/li&gt;&lt;li&gt;crop_box = The visible (printable) page area.&lt;/li&gt;&lt;li&gt;bleed_box = Untrimmed content position on the page (content dimensions plus trim box).&lt;/li&gt;&lt;li&gt;trim_box = Trimmed content position on the page (final content dimensions).&lt;/li&gt;&lt;li&gt;art_box = Position for special page content (images).&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "printClip")
    protected BoxSelectionType printClip;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The print scaling initially suggested when opening the Reader's print dialog.&#13;
     *                         &lt;ul&gt;&lt;li&gt;readerDefault = The Reader shall use it's default suggestion.&lt;/li&gt;&lt;li&gt;byPDFSize = The Reader shall suggest to not scale the document during printing.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "printScaling")
    protected PrintScaleType printScaling;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The duplex settings initially suggested when opening the Reader's print dialog.&#13;
     *                         &lt;ul&gt;&lt;li&gt;none = The Reader shall use it's default suggestion.&lt;/li&gt;&lt;li&gt;simplex = The Reader shall suggest simplex printing.&lt;/li&gt;&lt;li&gt;duplexFlipShortEdge = The Reader shall suggest duplex printing, flipping pages over the shorter edge.&lt;/li&gt;&lt;li&gt;duplexFlipLongEdge = The Reader shall suggest duplex printing, flipping pages over the longer edge.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "duplex")
    protected DuplexType duplex;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The print tray selection initially suggested when opening the Reader's print dialog.&#13;
     *                         &lt;ul&gt;&lt;li&gt;readerDefault = The Reader shall use it's default suggestion.&lt;/li&gt;&lt;li&gt;byPDFSize = The Reader shall select a print tray, that matches the PDF's page dimensions.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "printTraySelection")
    protected PrintTraySelectionType printTraySelection;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the page range, that shall initially be suggested for printing, when opening the Reader's print dialog.&#13;
     * &#13;
     *                         The page number can be an individual page, a page range, or a list (separated with commas) (e.g., "1,5-6,9"). To specify "all pages," use an asterisk ("*").&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "printPageRange")
    protected String printPageRange;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The number of copies initially suggested, when opening the Reader's print dialog.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "numCopies")
    protected Integer numCopies;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The Reader's toolbars shall be hidden, when opening the document.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isHideToolbar() {
        if (hideToolbar == null) {
            return false;
        } else {
            return hideToolbar;
        }
    }

    /**
     * Sets the value of the hideToolbar property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isHideToolbar()
     */
    public void setHideToolbar(boolean value) {
        this.hideToolbar = value;
    }

    public boolean isSetHideToolbar() {
        return (this.hideToolbar!= null);
    }

    public void unsetHideToolbar() {
        this.hideToolbar = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The Reader's menu bar shall be hidden, when opening the document.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isHideMenuBar() {
        if (hideMenuBar == null) {
            return false;
        } else {
            return hideMenuBar;
        }
    }

    /**
     * Sets the value of the hideMenuBar property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isHideMenuBar()
     */
    public void setHideMenuBar(boolean value) {
        this.hideMenuBar = value;
    }

    public boolean isSetHideMenuBar() {
        return (this.hideMenuBar!= null);
    }

    public void unsetHideMenuBar() {
        this.hideMenuBar = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The Reader's navigation controls (such as scrollbars) shall be hidden, when opening the document.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isHideWindowUI() {
        if (hideWindowUI == null) {
            return false;
        } else {
            return hideWindowUI;
        }
    }

    /**
     * Sets the value of the hideWindowUI property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isHideWindowUI()
     */
    public void setHideWindowUI(boolean value) {
        this.hideWindowUI = value;
    }

    public boolean isSetHideWindowUI() {
        return (this.hideWindowUI!= null);
    }

    public void unsetHideWindowUI() {
        this.hideWindowUI = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The dimensions of the Reader's window shall adapt to the first displayed page of the document.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isFitWindow() {
        if (fitWindow == null) {
            return false;
        } else {
            return fitWindow;
        }
    }

    /**
     * Sets the value of the fitWindow property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isFitWindow()
     */
    public void setFitWindow(boolean value) {
        this.fitWindow = value;
    }

    public boolean isSetFitWindow() {
        return (this.fitWindow!= null);
    }

    public void unsetFitWindow() {
        this.fitWindow = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The Reader's window shall be positioned at the center of the screen, when opening the document.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isCenterWindow() {
        if (centerWindow == null) {
            return false;
        } else {
            return centerWindow;
        }
    }

    /**
     * Sets the value of the centerWindow property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isCenterWindow()
     */
    public void setCenterWindow(boolean value) {
        this.centerWindow = value;
    }

    public boolean isSetCenterWindow() {
        return (this.centerWindow!= null);
    }

    public void unsetCenterWindow() {
        this.centerWindow = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Instead of the file name the reader shall display the title of the document in it's title bar.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isDisplayDocTitle() {
        if (displayDocTitle == null) {
            return false;
        } else {
            return displayDocTitle;
        }
    }

    /**
     * Sets the value of the displayDocTitle property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isDisplayDocTitle()
     */
    public void setDisplayDocTitle(boolean value) {
        this.displayDocTitle = value;
    }

    public boolean isSetDisplayDocTitle() {
        return (this.displayDocTitle!= null);
    }

    public void unsetDisplayDocTitle() {
        this.displayDocTitle = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;When displaying the document in windowed mode, the Reader shall show the selected panel.&#13;
     *                         &lt;ul&gt;&lt;li&gt;none = No panel shall be opened.&lt;/li&gt;&lt;li&gt;outlines = The document's outlines shall be displayed.&lt;/li&gt;&lt;li&gt;thumbnails = The document's page thumbnails shall be shown.&lt;/li&gt;&lt;li&gt;optionalContents = document's layers (OCGs - Optional Content Groups) shall be displayed.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link NonFullScreenPageModeType }
     *     
     */
    public NonFullScreenPageModeType getNonFullScreenPageMode() {
        if (nonFullScreenPageMode == null) {
            return NonFullScreenPageModeType.NONE;
        } else {
            return nonFullScreenPageMode;
        }
    }

    /**
     * Sets the value of the nonFullScreenPageMode property.
     * 
     * @param value
     *     allowed object is
     *     {@link NonFullScreenPageModeType }
     *     
     * @see #getNonFullScreenPageMode()
     */
    public void setNonFullScreenPageMode(NonFullScreenPageModeType value) {
        this.nonFullScreenPageMode = value;
    }

    public boolean isSetNonFullScreenPageMode() {
        return (this.nonFullScreenPageMode!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the predominant document's text writing/reading direction.&#13;
     *                         &lt;ul&gt;&lt;li&gt;leftToRight or&lt;/li&gt;&lt;li&gt;rightToLeft&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link TextDirectionType }
     *     
     */
    public TextDirectionType getTextDirection() {
        if (textDirection == null) {
            return TextDirectionType.LEFT_TO_RIGHT;
        } else {
            return textDirection;
        }
    }

    /**
     * Sets the value of the textDirection property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextDirectionType }
     *     
     * @see #getTextDirection()
     */
    public void setTextDirection(TextDirectionType value) {
        this.textDirection = value;
    }

    public boolean isSetTextDirection() {
        return (this.textDirection!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the visible box, when displaying the document.&#13;
     *                         &lt;ul&gt;&lt;li&gt;media_box = The page's physical dimensions.&lt;/li&gt;&lt;li&gt;crop_box = The visible (printable) page area.&lt;/li&gt;&lt;li&gt;bleed_box = Untrimmed content position on the page (content dimensions plus trim box).&lt;/li&gt;&lt;li&gt;trim_box = Trimmed content position on the page (final content dimensions).&lt;/li&gt;&lt;li&gt;art_box = Position for special page content (images).&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link BoxSelectionType }
     *     
     */
    public BoxSelectionType getViewArea() {
        if (viewArea == null) {
            return BoxSelectionType.CROP_BOX;
        } else {
            return viewArea;
        }
    }

    /**
     * Sets the value of the viewArea property.
     * 
     * @param value
     *     allowed object is
     *     {@link BoxSelectionType }
     *     
     * @see #getViewArea()
     */
    public void setViewArea(BoxSelectionType value) {
        this.viewArea = value;
    }

    public boolean isSetViewArea() {
        return (this.viewArea!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the box contents shall be cropped at, when displaying the document.&#13;
     *                         &lt;ul&gt;&lt;li&gt;media_box = The page's physical dimensions.&lt;/li&gt;&lt;li&gt;crop_box = The visible (printable) page area.&lt;/li&gt;&lt;li&gt;bleed_box = Untrimmed content position on the page (content dimensions plus trim box).&lt;/li&gt;&lt;li&gt;trim_box = Trimmed content position on the page (final content dimensions).&lt;/li&gt;&lt;li&gt;art_box = Position for special page content (images).&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link BoxSelectionType }
     *     
     */
    public BoxSelectionType getViewClip() {
        if (viewClip == null) {
            return BoxSelectionType.CROP_BOX;
        } else {
            return viewClip;
        }
    }

    /**
     * Sets the value of the viewClip property.
     * 
     * @param value
     *     allowed object is
     *     {@link BoxSelectionType }
     *     
     * @see #getViewClip()
     */
    public void setViewClip(BoxSelectionType value) {
        this.viewClip = value;
    }

    public boolean isSetViewClip() {
        return (this.viewClip!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the visible box, when printing the document.&#13;
     *                         &lt;ul&gt;&lt;li&gt;media_box = The page's physical dimensions.&lt;/li&gt;&lt;li&gt;crop_box = The visible (printable) page area.&lt;/li&gt;&lt;li&gt;bleed_box = Untrimmed content position on the page (content dimensions plus trim box).&lt;/li&gt;&lt;li&gt;trim_box = Trimmed content position on the page (final content dimensions).&lt;/li&gt;&lt;li&gt;art_box = Position for special page content (images).&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link BoxSelectionType }
     *     
     */
    public BoxSelectionType getPrintArea() {
        if (printArea == null) {
            return BoxSelectionType.CROP_BOX;
        } else {
            return printArea;
        }
    }

    /**
     * Sets the value of the printArea property.
     * 
     * @param value
     *     allowed object is
     *     {@link BoxSelectionType }
     *     
     * @see #getPrintArea()
     */
    public void setPrintArea(BoxSelectionType value) {
        this.printArea = value;
    }

    public boolean isSetPrintArea() {
        return (this.printArea!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the box contents shall be cropped at, when printing the document.&#13;
     *                         &lt;ul&gt;&lt;li&gt;media_box = The page's physical dimensions.&lt;/li&gt;&lt;li&gt;crop_box = The visible (printable) page area.&lt;/li&gt;&lt;li&gt;bleed_box = Untrimmed content position on the page (content dimensions plus trim box).&lt;/li&gt;&lt;li&gt;trim_box = Trimmed content position on the page (final content dimensions).&lt;/li&gt;&lt;li&gt;art_box = Position for special page content (images).&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link BoxSelectionType }
     *     
     */
    public BoxSelectionType getPrintClip() {
        if (printClip == null) {
            return BoxSelectionType.CROP_BOX;
        } else {
            return printClip;
        }
    }

    /**
     * Sets the value of the printClip property.
     * 
     * @param value
     *     allowed object is
     *     {@link BoxSelectionType }
     *     
     * @see #getPrintClip()
     */
    public void setPrintClip(BoxSelectionType value) {
        this.printClip = value;
    }

    public boolean isSetPrintClip() {
        return (this.printClip!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The print scaling initially suggested when opening the Reader's print dialog.&#13;
     *                         &lt;ul&gt;&lt;li&gt;readerDefault = The Reader shall use it's default suggestion.&lt;/li&gt;&lt;li&gt;byPDFSize = The Reader shall suggest to not scale the document during printing.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link PrintScaleType }
     *     
     */
    public PrintScaleType getPrintScaling() {
        if (printScaling == null) {
            return PrintScaleType.READER_DEFAULT;
        } else {
            return printScaling;
        }
    }

    /**
     * Sets the value of the printScaling property.
     * 
     * @param value
     *     allowed object is
     *     {@link PrintScaleType }
     *     
     * @see #getPrintScaling()
     */
    public void setPrintScaling(PrintScaleType value) {
        this.printScaling = value;
    }

    public boolean isSetPrintScaling() {
        return (this.printScaling!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The duplex settings initially suggested when opening the Reader's print dialog.&#13;
     *                         &lt;ul&gt;&lt;li&gt;none = The Reader shall use it's default suggestion.&lt;/li&gt;&lt;li&gt;simplex = The Reader shall suggest simplex printing.&lt;/li&gt;&lt;li&gt;duplexFlipShortEdge = The Reader shall suggest duplex printing, flipping pages over the shorter edge.&lt;/li&gt;&lt;li&gt;duplexFlipLongEdge = The Reader shall suggest duplex printing, flipping pages over the longer edge.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link DuplexType }
     *     
     */
    public DuplexType getDuplex() {
        if (duplex == null) {
            return DuplexType.NONE;
        } else {
            return duplex;
        }
    }

    /**
     * Sets the value of the duplex property.
     * 
     * @param value
     *     allowed object is
     *     {@link DuplexType }
     *     
     * @see #getDuplex()
     */
    public void setDuplex(DuplexType value) {
        this.duplex = value;
    }

    public boolean isSetDuplex() {
        return (this.duplex!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The print tray selection initially suggested when opening the Reader's print dialog.&#13;
     *                         &lt;ul&gt;&lt;li&gt;readerDefault = The Reader shall use it's default suggestion.&lt;/li&gt;&lt;li&gt;byPDFSize = The Reader shall select a print tray, that matches the PDF's page dimensions.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link PrintTraySelectionType }
     *     
     */
    public PrintTraySelectionType getPrintTraySelection() {
        if (printTraySelection == null) {
            return PrintTraySelectionType.READER_DEFAULT;
        } else {
            return printTraySelection;
        }
    }

    /**
     * Sets the value of the printTraySelection property.
     * 
     * @param value
     *     allowed object is
     *     {@link PrintTraySelectionType }
     *     
     * @see #getPrintTraySelection()
     */
    public void setPrintTraySelection(PrintTraySelectionType value) {
        this.printTraySelection = value;
    }

    public boolean isSetPrintTraySelection() {
        return (this.printTraySelection!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the page range, that shall initially be suggested for printing, when opening the Reader's print dialog.&#13;
     * &#13;
     *                         The page number can be an individual page, a page range, or a list (separated with commas) (e.g., "1,5-6,9"). To specify "all pages," use an asterisk ("*").&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPrintPageRange() {
        if (printPageRange == null) {
            return "";
        } else {
            return printPageRange;
        }
    }

    /**
     * Sets the value of the printPageRange property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getPrintPageRange()
     */
    public void setPrintPageRange(String value) {
        this.printPageRange = value;
    }

    public boolean isSetPrintPageRange() {
        return (this.printPageRange!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The number of copies initially suggested, when opening the Reader's print dialog.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getNumCopies() {
        if (numCopies == null) {
            return  1;
        } else {
            return numCopies;
        }
    }

    /**
     * Sets the value of the numCopies property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getNumCopies()
     */
    public void setNumCopies(int value) {
        this.numCopies = value;
    }

    public boolean isSetNumCopies() {
        return (this.numCopies!= null);
    }

    public void unsetNumCopies() {
        this.numCopies = null;
    }

}
