
package net.webpdf.wsclient.schema.extraction.info;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;An element of this type shall contain information concerning the security settings, manipulation protection and used password of a PDF document.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for SecurityType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="SecurityType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <choice>
 *         <element name="password" type="{http://schema.webpdf.de/1.0/extraction/info}PasswordType" minOccurs="0"/>
 *       </choice>
 *       <attGroup ref="{http://schema.webpdf.de/1.0/extraction/info}securityFlags"/>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SecurityType", propOrder = {
    "password"
})
public class SecurityType {

    protected PasswordType password;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," the document can be rearranged (e.g., pages can be deleted, inserted, and rotated).&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "canAssemble")
    protected Boolean canAssemble;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," content can be extracted (copied) from the document.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "canExtractContent")
    protected Boolean canExtractContent;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," content can be extracted (copied) for accessibility purposes.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "canExtractForAccessibility")
    protected Boolean canExtractForAccessibility;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," form fields can be filled out and the document can be signed.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "canFillInForm")
    protected Boolean canFillInForm;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," changes to the document are permitted.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "canModify")
    protected Boolean canModify;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," comments can be added to the document and deleted from the document.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "canModifyAnnotations")
    protected Boolean canModifyAnnotations;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," the document can be printed.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "canPrint")
    protected Boolean canPrint;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," the document can be printed at high resolution levels.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "canPrintHighRes")
    protected Boolean canPrintHighRes;

    /**
     * Gets the value of the password property.
     * 
     * @return
     *     possible object is
     *     {@link PasswordType }
     *     
     */
    public PasswordType getPassword() {
        return password;
    }

    /**
     * Sets the value of the password property.
     * 
     * @param value
     *     allowed object is
     *     {@link PasswordType }
     *     
     */
    public void setPassword(PasswordType value) {
        this.password = value;
    }

    public boolean isSetPassword() {
        return (this.password!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," the document can be rearranged (e.g., pages can be deleted, inserted, and rotated).&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isCanAssemble() {
        if (canAssemble == null) {
            return true;
        } else {
            return canAssemble;
        }
    }

    /**
     * Sets the value of the canAssemble property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isCanAssemble()
     */
    public void setCanAssemble(boolean value) {
        this.canAssemble = value;
    }

    public boolean isSetCanAssemble() {
        return (this.canAssemble!= null);
    }

    public void unsetCanAssemble() {
        this.canAssemble = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," content can be extracted (copied) from the document.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isCanExtractContent() {
        if (canExtractContent == null) {
            return true;
        } else {
            return canExtractContent;
        }
    }

    /**
     * Sets the value of the canExtractContent property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isCanExtractContent()
     */
    public void setCanExtractContent(boolean value) {
        this.canExtractContent = value;
    }

    public boolean isSetCanExtractContent() {
        return (this.canExtractContent!= null);
    }

    public void unsetCanExtractContent() {
        this.canExtractContent = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," content can be extracted (copied) for accessibility purposes.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isCanExtractForAccessibility() {
        if (canExtractForAccessibility == null) {
            return true;
        } else {
            return canExtractForAccessibility;
        }
    }

    /**
     * Sets the value of the canExtractForAccessibility property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isCanExtractForAccessibility()
     */
    public void setCanExtractForAccessibility(boolean value) {
        this.canExtractForAccessibility = value;
    }

    public boolean isSetCanExtractForAccessibility() {
        return (this.canExtractForAccessibility!= null);
    }

    public void unsetCanExtractForAccessibility() {
        this.canExtractForAccessibility = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," form fields can be filled out and the document can be signed.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isCanFillInForm() {
        if (canFillInForm == null) {
            return true;
        } else {
            return canFillInForm;
        }
    }

    /**
     * Sets the value of the canFillInForm property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isCanFillInForm()
     */
    public void setCanFillInForm(boolean value) {
        this.canFillInForm = value;
    }

    public boolean isSetCanFillInForm() {
        return (this.canFillInForm!= null);
    }

    public void unsetCanFillInForm() {
        this.canFillInForm = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," changes to the document are permitted.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isCanModify() {
        if (canModify == null) {
            return true;
        } else {
            return canModify;
        }
    }

    /**
     * Sets the value of the canModify property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isCanModify()
     */
    public void setCanModify(boolean value) {
        this.canModify = value;
    }

    public boolean isSetCanModify() {
        return (this.canModify!= null);
    }

    public void unsetCanModify() {
        this.canModify = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," comments can be added to the document and deleted from the document.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isCanModifyAnnotations() {
        if (canModifyAnnotations == null) {
            return true;
        } else {
            return canModifyAnnotations;
        }
    }

    /**
     * Sets the value of the canModifyAnnotations property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isCanModifyAnnotations()
     */
    public void setCanModifyAnnotations(boolean value) {
        this.canModifyAnnotations = value;
    }

    public boolean isSetCanModifyAnnotations() {
        return (this.canModifyAnnotations!= null);
    }

    public void unsetCanModifyAnnotations() {
        this.canModifyAnnotations = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," the document can be printed.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isCanPrint() {
        if (canPrint == null) {
            return true;
        } else {
            return canPrint;
        }
    }

    /**
     * Sets the value of the canPrint property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isCanPrint()
     */
    public void setCanPrint(boolean value) {
        this.canPrint = value;
    }

    public boolean isSetCanPrint() {
        return (this.canPrint!= null);
    }

    public void unsetCanPrint() {
        this.canPrint = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," the document can be printed at high resolution levels.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isCanPrintHighRes() {
        if (canPrintHighRes == null) {
            return true;
        } else {
            return canPrintHighRes;
        }
    }

    /**
     * Sets the value of the canPrintHighRes property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isCanPrintHighRes()
     */
    public void setCanPrintHighRes(boolean value) {
        this.canPrintHighRes = value;
    }

    public boolean isSetCanPrintHighRes() {
        return (this.canPrintHighRes!= null);
    }

    public void unsetCanPrintHighRes() {
        this.canPrintHighRes = null;
    }

}
