
package net.webpdf.wsclient.schema.extraction.info;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The print scaling initially suggested when opening the Reader's print dialog.&#13;
 *                     &lt;ul&gt;&lt;li&gt;readerDefault = The Reader shall use it's default suggestion.&lt;/li&gt;&lt;li&gt;byPDFSize = The Reader shall suggest to not scale the document during printing.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for PrintScaleType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="PrintScaleType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="readerDefault"/>
 *     <enumeration value="noPrintScaling"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "PrintScaleType")
@XmlEnum
public enum PrintScaleType {

    @XmlEnumValue("readerDefault")
    READER_DEFAULT("readerDefault"),
    @XmlEnumValue("noPrintScaling")
    NO_PRINT_SCALING("noPrintScaling");
    private final String value;

    PrintScaleType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static PrintScaleType fromValue(String v) {
        for (PrintScaleType c: PrintScaleType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
