
package net.webpdf.wsclient.schema.extraction.info;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The set initial page layout of a document. When opening the document in a Reader, this layout shall be selected to display pages.&#13;
 *                     &lt;ul&gt;&lt;li&gt;singlePage = One page at a time.&lt;/li&gt;&lt;li&gt;oneColumn = One continuous column of pages.&lt;/li&gt;&lt;li&gt;twoColumnLeft = The pages in two columns, with odd-numbered pages on the left.&lt;/li&gt;&lt;li&gt;twoColumnRight = The pages in two columns, with odd-numbered pages on the right.&lt;/li&gt;&lt;li&gt;twoPageLeft = Display the pages two at a time, with odd-numbered pages on the left.&lt;/li&gt;&lt;li&gt;twoPageRight = Display the pages two at a time, with odd-numbered pages on the right.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for PageLayoutType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="PageLayoutType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="singlePage"/>
 *     <enumeration value="oneColumn"/>
 *     <enumeration value="twoColumnLeft"/>
 *     <enumeration value="twoColumnRight"/>
 *     <enumeration value="twoPageLeft"/>
 *     <enumeration value="twoPageRight"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "PageLayoutType")
@XmlEnum
public enum PageLayoutType {

    @XmlEnumValue("singlePage")
    SINGLE_PAGE("singlePage"),
    @XmlEnumValue("oneColumn")
    ONE_COLUMN("oneColumn"),
    @XmlEnumValue("twoColumnLeft")
    TWO_COLUMN_LEFT("twoColumnLeft"),
    @XmlEnumValue("twoColumnRight")
    TWO_COLUMN_RIGHT("twoColumnRight"),
    @XmlEnumValue("twoPageLeft")
    TWO_PAGE_LEFT("twoPageLeft"),
    @XmlEnumValue("twoPageRight")
    TWO_PAGE_RIGHT("twoPageRight");
    private final String value;

    PageLayoutType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static PageLayoutType fromValue(String v) {
        for (PageLayoutType c: PageLayoutType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
