
package net.webpdf.wsclient.schema.extraction.info;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;When displaying a document in windowed mode, the Reader shall show the selected panel.&#13;
 *                     &lt;ul&gt;&lt;li&gt;none = No panel shall be opened.&lt;/li&gt;&lt;li&gt;outlines = The document's outlines shall be displayed.&lt;/li&gt;&lt;li&gt;thumbnails = The document's page thumbnails shall be shown.&lt;/li&gt;&lt;li&gt;optionalContents = document's layers (OCGs - Optional Content Groups) shall be displayed.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for NonFullScreenPageModeType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="NonFullScreenPageModeType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="none"/>
 *     <enumeration value="outlines"/>
 *     <enumeration value="thumbnails"/>
 *     <enumeration value="optionalContents"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "NonFullScreenPageModeType")
@XmlEnum
public enum NonFullScreenPageModeType {

    @XmlEnumValue("none")
    NONE("none"),
    @XmlEnumValue("outlines")
    OUTLINES("outlines"),
    @XmlEnumValue("thumbnails")
    THUMBNAILS("thumbnails"),
    @XmlEnumValue("optionalContents")
    OPTIONAL_CONTENTS("optionalContents");
    private final String value;

    NonFullScreenPageModeType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static NonFullScreenPageModeType fromValue(String v) {
        for (NonFullScreenPageModeType c: NonFullScreenPageModeType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
