
package net.webpdf.wsclient.schema.extraction.info;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines a set of attributes for text markup annotations.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for MarkupType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="MarkupType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="richContents" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <element name="relation" minOccurs="0">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <choice>
 *                   <element name="group" type="{http://schema.webpdf.de/1.0/extraction/info}GroupRelationType"/>
 *                   <element name="mark" type="{http://schema.webpdf.de/1.0/extraction/info}MarkRelationType"/>
 *                   <element name="state" type="{http://schema.webpdf.de/1.0/extraction/info}ReplyStateRelationType"/>
 *                   <element name="comment" type="{http://schema.webpdf.de/1.0/extraction/info}CommentRelationType"/>
 *                 </choice>
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *       </sequence>
 *       <attribute name="opacity" type="{http://schema.webpdf.de/1.0/extraction/info}OpacityType" default="100" />
 *       <attribute name="creationDate" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="subject" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="intents" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="creator" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "MarkupType", propOrder = {
    "richContents",
    "relation"
})
public class MarkupType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A richtext string containing defining style and contents of the annotation. (This String shall conform to the richtext conventions of the XML Forms Specification (XFA)).&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlElement(defaultValue = "")
    protected String richContents;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the relation of this annotation to other annotations.&lt;/p&gt;
     * </pre>
     * 
     */
    protected MarkupType.Relation relation;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The annotations opacity as a percentage, where 100 is fully oqaque and 0 is fully transparent.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "opacity")
    protected Integer opacity;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The date of the annotation's creation. This string will contain the date in ASN.1 standard format. (D:YYYYMMDDHHmmSSOHH'mm)&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "creationDate")
    protected String creationDate;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The annotation's subject.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "subject")
    protected String subject;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The annotation's intents. Depending on the annotation sub type the intents value shall serve further purposes.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "intents")
    protected String intents;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The name of the annotation's author.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "creator")
    protected String creator;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A richtext string containing defining style and contents of the annotation. (This String shall conform to the richtext conventions of the XML Forms Specification (XFA)).&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getRichContents() {
        return richContents;
    }

    /**
     * Sets the value of the richContents property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getRichContents()
     */
    public void setRichContents(String value) {
        this.richContents = value;
    }

    public boolean isSetRichContents() {
        return (this.richContents!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the relation of this annotation to other annotations.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link MarkupType.Relation }
     *     
     */
    public MarkupType.Relation getRelation() {
        return relation;
    }

    /**
     * Sets the value of the relation property.
     * 
     * @param value
     *     allowed object is
     *     {@link MarkupType.Relation }
     *     
     * @see #getRelation()
     */
    public void setRelation(MarkupType.Relation value) {
        this.relation = value;
    }

    public boolean isSetRelation() {
        return (this.relation!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The annotations opacity as a percentage, where 100 is fully oqaque and 0 is fully transparent.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getOpacity() {
        if (opacity == null) {
            return  100;
        } else {
            return opacity;
        }
    }

    /**
     * Sets the value of the opacity property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getOpacity()
     */
    public void setOpacity(int value) {
        this.opacity = value;
    }

    public boolean isSetOpacity() {
        return (this.opacity!= null);
    }

    public void unsetOpacity() {
        this.opacity = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The date of the annotation's creation. This string will contain the date in ASN.1 standard format. (D:YYYYMMDDHHmmSSOHH'mm)&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCreationDate() {
        if (creationDate == null) {
            return "";
        } else {
            return creationDate;
        }
    }

    /**
     * Sets the value of the creationDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getCreationDate()
     */
    public void setCreationDate(String value) {
        this.creationDate = value;
    }

    public boolean isSetCreationDate() {
        return (this.creationDate!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The annotation's subject.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSubject() {
        if (subject == null) {
            return "";
        } else {
            return subject;
        }
    }

    /**
     * Sets the value of the subject property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getSubject()
     */
    public void setSubject(String value) {
        this.subject = value;
    }

    public boolean isSetSubject() {
        return (this.subject!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The annotation's intents. Depending on the annotation sub type the intents value shall serve further purposes.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getIntents() {
        if (intents == null) {
            return "";
        } else {
            return intents;
        }
    }

    /**
     * Sets the value of the intents property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getIntents()
     */
    public void setIntents(String value) {
        this.intents = value;
    }

    public boolean isSetIntents() {
        return (this.intents!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The name of the annotation's author.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCreator() {
        if (creator == null) {
            return "";
        } else {
            return creator;
        }
    }

    /**
     * Sets the value of the creator property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getCreator()
     */
    public void setCreator(String value) {
        this.creator = value;
    }

    public boolean isSetCreator() {
        return (this.creator!= null);
    }


    /**
     * <p>Java class for anonymous complex type</p>.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.</p>
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <choice>
     *         <element name="group" type="{http://schema.webpdf.de/1.0/extraction/info}GroupRelationType"/>
     *         <element name="mark" type="{http://schema.webpdf.de/1.0/extraction/info}MarkRelationType"/>
     *         <element name="state" type="{http://schema.webpdf.de/1.0/extraction/info}ReplyStateRelationType"/>
     *         <element name="comment" type="{http://schema.webpdf.de/1.0/extraction/info}CommentRelationType"/>
     *       </choice>
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "group",
        "mark",
        "state",
        "comment"
    })
    public static class Relation {

        protected GroupRelationType group;
        protected MarkRelationType mark;
        protected ReplyStateRelationType state;
        protected CommentRelationType comment;

        /**
         * Gets the value of the group property.
         * 
         * @return
         *     possible object is
         *     {@link GroupRelationType }
         *     
         */
        public GroupRelationType getGroup() {
            return group;
        }

        /**
         * Sets the value of the group property.
         * 
         * @param value
         *     allowed object is
         *     {@link GroupRelationType }
         *     
         */
        public void setGroup(GroupRelationType value) {
            this.group = value;
        }

        public boolean isSetGroup() {
            return (this.group!= null);
        }

        /**
         * Gets the value of the mark property.
         * 
         * @return
         *     possible object is
         *     {@link MarkRelationType }
         *     
         */
        public MarkRelationType getMark() {
            return mark;
        }

        /**
         * Sets the value of the mark property.
         * 
         * @param value
         *     allowed object is
         *     {@link MarkRelationType }
         *     
         */
        public void setMark(MarkRelationType value) {
            this.mark = value;
        }

        public boolean isSetMark() {
            return (this.mark!= null);
        }

        /**
         * Gets the value of the state property.
         * 
         * @return
         *     possible object is
         *     {@link ReplyStateRelationType }
         *     
         */
        public ReplyStateRelationType getState() {
            return state;
        }

        /**
         * Sets the value of the state property.
         * 
         * @param value
         *     allowed object is
         *     {@link ReplyStateRelationType }
         *     
         */
        public void setState(ReplyStateRelationType value) {
            this.state = value;
        }

        public boolean isSetState() {
            return (this.state!= null);
        }

        /**
         * Gets the value of the comment property.
         * 
         * @return
         *     possible object is
         *     {@link CommentRelationType }
         *     
         */
        public CommentRelationType getComment() {
            return comment;
        }

        /**
         * Sets the value of the comment property.
         * 
         * @param value
         *     allowed object is
         *     {@link CommentRelationType }
         *     
         */
        public void setComment(CommentRelationType value) {
            this.comment = value;
        }

        public boolean isSetComment() {
            return (this.comment!= null);
        }

    }

}
