
package net.webpdf.wsclient.schema.extraction.info;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines a set of attributes for Line annotations.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for LineType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="LineType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="startStyle" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="endStyle" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="showCaption" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="captionHorizontalOffset" type="{http://www.w3.org/2001/XMLSchema}float" default="0" />
 *       <attribute name="captionVerticalOffset" type="{http://www.w3.org/2001/XMLSchema}float" default="0" />
 *       <attribute name="captionPositioning" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="leaderLineLength" type="{http://www.w3.org/2001/XMLSchema}float" default="0" />
 *       <attribute name="leaderLineOffsetLength" type="{http://www.w3.org/2001/XMLSchema}float" default="0" />
 *       <attribute name="leaderLineExtensionLength" type="{http://www.w3.org/2001/XMLSchema}float" default="0" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "LineType")
public class LineType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the Line ending style at the start of the line.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "startStyle")
    protected String startStyle;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the Line ending style at the end of the line. Possible values are: Square, Circle, Diamond, OpenArrow, ClosedArrow, None, Butt, ROpenArrow, RClosedArrow, Slash&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "endStyle")
    protected String endStyle;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;When set to true the line shall display a textual caption.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "showCaption")
    protected Boolean showCaption;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The horizontal offset of the caption's leading letter in relation to it's normal position.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "captionHorizontalOffset")
    protected Float captionHorizontalOffset;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The vertical offset of the caption's leading letter in relation to it's normal position.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "captionVerticalOffset")
    protected Float captionVerticalOffset;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The positioning method for the caption of the line. Possible values are "Inline" (superimposed) and "Top" (above the line).&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "captionPositioning")
    protected String captionPositioning;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The length of leader lines that extend from each endpoint of the line perpendicular to the line itself. A positive value shall mean that the leader lines appear in the direction that is clockwise when traversing the line from its starting point to its ending point; a negative value shall indicate the opposite direction.(0 = no leader lines)&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "leaderLineLength")
    protected Float leaderLineLength;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A non-negative number that shall represent the length of the leader line offset, which is the amount of empty space between the endpoints of the annotation and the beginning of the leader lines.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "leaderLineOffsetLength")
    protected Float leaderLineOffsetLength;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A non-negative number that shall represent the length of leader line extensions that extend from the line proper 180 degrees from the leader lines. (0 = no leader line extensions)&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "leaderLineExtensionLength")
    protected Float leaderLineExtensionLength;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the Line ending style at the start of the line.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getStartStyle() {
        if (startStyle == null) {
            return "";
        } else {
            return startStyle;
        }
    }

    /**
     * Sets the value of the startStyle property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getStartStyle()
     */
    public void setStartStyle(String value) {
        this.startStyle = value;
    }

    public boolean isSetStartStyle() {
        return (this.startStyle!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the Line ending style at the end of the line. Possible values are: Square, Circle, Diamond, OpenArrow, ClosedArrow, None, Butt, ROpenArrow, RClosedArrow, Slash&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getEndStyle() {
        if (endStyle == null) {
            return "";
        } else {
            return endStyle;
        }
    }

    /**
     * Sets the value of the endStyle property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getEndStyle()
     */
    public void setEndStyle(String value) {
        this.endStyle = value;
    }

    public boolean isSetEndStyle() {
        return (this.endStyle!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;When set to true the line shall display a textual caption.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isShowCaption() {
        if (showCaption == null) {
            return false;
        } else {
            return showCaption;
        }
    }

    /**
     * Sets the value of the showCaption property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isShowCaption()
     */
    public void setShowCaption(boolean value) {
        this.showCaption = value;
    }

    public boolean isSetShowCaption() {
        return (this.showCaption!= null);
    }

    public void unsetShowCaption() {
        this.showCaption = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The horizontal offset of the caption's leading letter in relation to it's normal position.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Float }
     *     
     */
    public float getCaptionHorizontalOffset() {
        if (captionHorizontalOffset == null) {
            return  0.0F;
        } else {
            return captionHorizontalOffset;
        }
    }

    /**
     * Sets the value of the captionHorizontalOffset property.
     * 
     * @param value
     *     allowed object is
     *     {@link Float }
     *     
     * @see #getCaptionHorizontalOffset()
     */
    public void setCaptionHorizontalOffset(float value) {
        this.captionHorizontalOffset = value;
    }

    public boolean isSetCaptionHorizontalOffset() {
        return (this.captionHorizontalOffset!= null);
    }

    public void unsetCaptionHorizontalOffset() {
        this.captionHorizontalOffset = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The vertical offset of the caption's leading letter in relation to it's normal position.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Float }
     *     
     */
    public float getCaptionVerticalOffset() {
        if (captionVerticalOffset == null) {
            return  0.0F;
        } else {
            return captionVerticalOffset;
        }
    }

    /**
     * Sets the value of the captionVerticalOffset property.
     * 
     * @param value
     *     allowed object is
     *     {@link Float }
     *     
     * @see #getCaptionVerticalOffset()
     */
    public void setCaptionVerticalOffset(float value) {
        this.captionVerticalOffset = value;
    }

    public boolean isSetCaptionVerticalOffset() {
        return (this.captionVerticalOffset!= null);
    }

    public void unsetCaptionVerticalOffset() {
        this.captionVerticalOffset = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The positioning method for the caption of the line. Possible values are "Inline" (superimposed) and "Top" (above the line).&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCaptionPositioning() {
        if (captionPositioning == null) {
            return "";
        } else {
            return captionPositioning;
        }
    }

    /**
     * Sets the value of the captionPositioning property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getCaptionPositioning()
     */
    public void setCaptionPositioning(String value) {
        this.captionPositioning = value;
    }

    public boolean isSetCaptionPositioning() {
        return (this.captionPositioning!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The length of leader lines that extend from each endpoint of the line perpendicular to the line itself. A positive value shall mean that the leader lines appear in the direction that is clockwise when traversing the line from its starting point to its ending point; a negative value shall indicate the opposite direction.(0 = no leader lines)&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Float }
     *     
     */
    public float getLeaderLineLength() {
        if (leaderLineLength == null) {
            return  0.0F;
        } else {
            return leaderLineLength;
        }
    }

    /**
     * Sets the value of the leaderLineLength property.
     * 
     * @param value
     *     allowed object is
     *     {@link Float }
     *     
     * @see #getLeaderLineLength()
     */
    public void setLeaderLineLength(float value) {
        this.leaderLineLength = value;
    }

    public boolean isSetLeaderLineLength() {
        return (this.leaderLineLength!= null);
    }

    public void unsetLeaderLineLength() {
        this.leaderLineLength = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A non-negative number that shall represent the length of the leader line offset, which is the amount of empty space between the endpoints of the annotation and the beginning of the leader lines.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Float }
     *     
     */
    public float getLeaderLineOffsetLength() {
        if (leaderLineOffsetLength == null) {
            return  0.0F;
        } else {
            return leaderLineOffsetLength;
        }
    }

    /**
     * Sets the value of the leaderLineOffsetLength property.
     * 
     * @param value
     *     allowed object is
     *     {@link Float }
     *     
     * @see #getLeaderLineOffsetLength()
     */
    public void setLeaderLineOffsetLength(float value) {
        this.leaderLineOffsetLength = value;
    }

    public boolean isSetLeaderLineOffsetLength() {
        return (this.leaderLineOffsetLength!= null);
    }

    public void unsetLeaderLineOffsetLength() {
        this.leaderLineOffsetLength = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A non-negative number that shall represent the length of leader line extensions that extend from the line proper 180 degrees from the leader lines. (0 = no leader line extensions)&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Float }
     *     
     */
    public float getLeaderLineExtensionLength() {
        if (leaderLineExtensionLength == null) {
            return  0.0F;
        } else {
            return leaderLineExtensionLength;
        }
    }

    /**
     * Sets the value of the leaderLineExtensionLength property.
     * 
     * @param value
     *     allowed object is
     *     {@link Float }
     *     
     * @see #getLeaderLineExtensionLength()
     */
    public void setLeaderLineExtensionLength(float value) {
        this.leaderLineExtensionLength = value;
    }

    public boolean isSetLeaderLineExtensionLength() {
        return (this.leaderLineExtensionLength!= null);
    }

    public void unsetLeaderLineExtensionLength() {
        this.leaderLineExtensionLength = null;
    }

}
