
package net.webpdf.wsclient.schema.extraction.info;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;When set to another value than "none", the document does contain a PDF form in the hereby given format.&#13;
 *                     &lt;ul&gt;&lt;li&gt;none = The document does not contain a form.&lt;/li&gt;&lt;li&gt;acroForm = The document contains a standard PDF Acroform.&lt;/li&gt;&lt;li&gt;staticXFA = The document contains a "XML Forms Architecture" form with a fixed layout (static).&lt;/li&gt;&lt;li&gt;dynamicXFA = The document contains a "XML Forms Architecture" form with an adaptable/interactive layout (dynamic).&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for FormsFormatType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="FormsFormatType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="none"/>
 *     <enumeration value="acroForm"/>
 *     <enumeration value="staticXFA"/>
 *     <enumeration value="dynamicXFA"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "FormsFormatType")
@XmlEnum
public enum FormsFormatType {

    @XmlEnumValue("none")
    NONE("none"),
    @XmlEnumValue("acroForm")
    ACRO_FORM("acroForm"),
    @XmlEnumValue("staticXFA")
    STATIC_XFA("staticXFA"),
    @XmlEnumValue("dynamicXFA")
    DYNAMIC_XFA("dynamicXFA");
    private final String value;

    FormsFormatType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static FormsFormatType fromValue(String v) {
        for (FormsFormatType c: FormsFormatType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
