/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 9.0.0.3479 (2024-07-23T08:38:02Z) 
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * This element defines a file necessary for the transformation, which is passed \&quot;Base64 encoded\&quot;. This element can be used with &#x60;&lt;resources&gt;&#x60; or &#x60;&lt;visualization&gt;&#x60;. In the case of &#x60;&lt;resources&gt;&#x60;, this is a file that defines, for example, an XLST stylesheet or a CSS resource. In the case of an X invoice and the parent &#x60;&lt;visualization&gt;&#x60; it defines a file (XLST stylesheet) which defines a different layout for the PDF output.
 */
@Schema(description = "This element defines a file necessary for the transformation, which is passed \"Base64 encoded\". This element can be used with `<resources>` or `<visualization>`. In the case of `<resources>`, this is a file that defines, for example, an XLST stylesheet or a CSS resource. In the case of an X invoice and the parent `<visualization>` it defines a file (XLST stylesheet) which defines a different layout for the PDF output.")
@JsonPropertyOrder({
  OperationXslTransformationFile.JSON_PROPERTY_FILE_NAME,
  OperationXslTransformationFile.JSON_PROPERTY_FORMAT,
  OperationXslTransformationFile.JSON_PROPERTY_SOURCE,
  OperationXslTransformationFile.JSON_PROPERTY_URI,
  OperationXslTransformationFile.JSON_PROPERTY_VALUE
})
@JsonTypeName("Operation_XslTransformationFile")

public class OperationXslTransformationFile {
  public static final String JSON_PROPERTY_FILE_NAME = "fileName";
  private String fileName = "";

  /**
   * The type of the resource passed  *   xlst &#x3D; An XSLT stylesheet to be used for the transformation. *   other &#x3D; Any other resource that is needed for the transformation. For example, this can be a CSS stylesheet, which is used by an output file of a transformation if it results in HTML output.  **Important:** The order of the resources can be important if multiple transformations are to be performed, i.e. multiple resources of the format \&quot;xlst\&quot; are passed. The transformations are performed in the order in which they are passed, in which case each transformation uses the output of the previous transformation as the starting point for its own transformation.
   */
  public enum FormatEnum {
    XSLT("xslt"),
    
    OTHER("other");

    private String value;

    FormatEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static FormatEnum fromValue(String value) {
      for (FormatEnum b : FormatEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_FORMAT = "format";
  private FormatEnum format = FormatEnum.XSLT;

  /**
   * Selects the data source for the hereby expressed resource. Possible values are:  *   value &#x3D; The element&#39;s value shall contain the BASE64 encoded data. *   uri &#x3D; The data shall be located at the given uri.
   */
  public enum SourceEnum {
    VALUE("value"),
    
    URI("uri");

    private String value;

    SourceEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SourceEnum fromValue(String value) {
      for (SourceEnum b : SourceEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SOURCE = "source";
  private SourceEnum source = SourceEnum.VALUE;

  public static final String JSON_PROPERTY_URI = "uri";
  private String uri = "";

  public static final String JSON_PROPERTY_VALUE = "value";
  private byte[] value;

  public OperationXslTransformationFile() {
  }

  public OperationXslTransformationFile fileName(String fileName) {
    
    this.fileName = fileName;
    return this;
  }

  /**
   * The filename of the file. This is the name under which the resource can be found again and is especially important for resources that are referenced from other files passed here via this name. (For example, the name of a CSS stylesheet that is referenced by name from an XSLT stylesheet).
   * @return fileName
   **/
  @Nullable
  @Schema(name = "The filename of the file. This is the name under which the resource can be found again and is especially important for resources that are referenced from other files passed here via this name. (For example, the name of a CSS stylesheet that is referenced by name from an XSLT stylesheet).")
  @JsonProperty(JSON_PROPERTY_FILE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFileName() {
    return fileName;
  }


  @JsonProperty(JSON_PROPERTY_FILE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFileName(String fileName) {
    this.fileName = fileName;
  }


  public OperationXslTransformationFile format(FormatEnum format) {
    
    this.format = format;
    return this;
  }

  /**
   * The type of the resource passed  *   xlst &#x3D; An XSLT stylesheet to be used for the transformation. *   other &#x3D; Any other resource that is needed for the transformation. For example, this can be a CSS stylesheet, which is used by an output file of a transformation if it results in HTML output.  **Important:** The order of the resources can be important if multiple transformations are to be performed, i.e. multiple resources of the format \&quot;xlst\&quot; are passed. The transformations are performed in the order in which they are passed, in which case each transformation uses the output of the previous transformation as the starting point for its own transformation.
   * @return format
   **/
  @Nullable
  @Schema(name = "The type of the resource passed  *   xlst = An XSLT stylesheet to be used for the transformation. *   other = Any other resource that is needed for the transformation. For example, this can be a CSS stylesheet, which is used by an output file of a transformation if it results in HTML output.  **Important:** The order of the resources can be important if multiple transformations are to be performed, i.e. multiple resources of the format \"xlst\" are passed. The transformations are performed in the order in which they are passed, in which case each transformation uses the output of the previous transformation as the starting point for its own transformation.")
  @JsonProperty(JSON_PROPERTY_FORMAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public FormatEnum getFormat() {
    return format;
  }


  @JsonProperty(JSON_PROPERTY_FORMAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFormat(FormatEnum format) {
    this.format = format;
  }


  public OperationXslTransformationFile source(SourceEnum source) {
    
    this.source = source;
    return this;
  }

  /**
   * Selects the data source for the hereby expressed resource. Possible values are:  *   value &#x3D; The element&#39;s value shall contain the BASE64 encoded data. *   uri &#x3D; The data shall be located at the given uri.
   * @return source
   **/
  @Nullable
  @Schema(name = "Selects the data source for the hereby expressed resource. Possible values are:  *   value = The element's value shall contain the BASE64 encoded data. *   uri = The data shall be located at the given uri.")
  @JsonProperty(JSON_PROPERTY_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SourceEnum getSource() {
    return source;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSource(SourceEnum source) {
    this.source = source;
  }


  public OperationXslTransformationFile uri(String uri) {
    
    this.uri = uri;
    return this;
  }

  /**
   * The uri the data shall be located at. (This shall only have effect, if the \&quot;source\&quot; is \&quot;uri\&quot;.)
   * @return uri
   **/
  @Nullable
  @Schema(name = "The uri the data shall be located at. (This shall only have effect, if the \"source\" is \"uri\".)")
  @JsonProperty(JSON_PROPERTY_URI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUri() {
    return uri;
  }


  @JsonProperty(JSON_PROPERTY_URI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUri(String uri) {
    this.uri = uri;
  }


  public OperationXslTransformationFile value(byte[] value) {
    
    this.value = value;
    return this;
  }

  /**
   * Get value
   * @return value
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public byte[] getValue() {
    return value;
  }


  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValue(byte[] value) {
    this.value = value;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationXslTransformationFile operationXslTransformationFile = (OperationXslTransformationFile) o;
    return Objects.equals(this.fileName, operationXslTransformationFile.fileName) &&
        Objects.equals(this.format, operationXslTransformationFile.format) &&
        Objects.equals(this.source, operationXslTransformationFile.source) &&
        Objects.equals(this.uri, operationXslTransformationFile.uri) &&
        Arrays.equals(this.value, operationXslTransformationFile.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(fileName, format, source, uri, Arrays.hashCode(value));
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationXslTransformationFile {\n");
    sb.append("    fileName: ").append(toIndentedString(fileName)).append("\n");
    sb.append("    format: ").append(toIndentedString(format)).append("\n");
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("    uri: ").append(toIndentedString(uri)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
