/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 9.0.0.3479 (2024-07-23T08:38:02Z) 
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Creates a page transition animation for a PDF full screen presentation. It is possible to specify several transition elements for different page ranges.
 */
@Schema(description = "Creates a page transition animation for a PDF full screen presentation. It is possible to specify several transition elements for different page ranges.")
@JsonPropertyOrder({
  OperationTransition.JSON_PROPERTY_AUTO_SCROLL,
  OperationTransition.JSON_PROPERTY_AUTO_SCROLL_TIME,
  OperationTransition.JSON_PROPERTY_DIRECTION,
  OperationTransition.JSON_PROPERTY_DURATION,
  OperationTransition.JSON_PROPERTY_FLY_AREA_OPAQUE,
  OperationTransition.JSON_PROPERTY_FLY_SCALE,
  OperationTransition.JSON_PROPERTY_PAGES,
  OperationTransition.JSON_PROPERTY_STYLE
})
@JsonTypeName("Operation_Transition")

public class OperationTransition {
  public static final String JSON_PROPERTY_AUTO_SCROLL = "autoScroll";
  private Boolean autoScroll = false;

  public static final String JSON_PROPERTY_AUTO_SCROLL_TIME = "autoScrollTime";
  private Float autoScrollTime = 0f;

  /**
   * The direction of the transition animation (provided that it can be applied to the animation).  *   leftToRight &#x3D; From left to right *   bottomToTop &#x3D; From bottom to top *   rightToLeft &#x3D; From right to left *   topToBottom &#x3D; From top to bottom *   topLeftToBottomRight &#x3D; From top left to bottom right *   none &#x3D; Use the default value for the animation
   */
  public enum DirectionEnum {
    LEFTTORIGHT("leftToRight"),
    
    BOTTOMTOTOP("bottomToTop"),
    
    RIGHTTOLEFT("rightToLeft"),
    
    TOPTOBOTTOM("topToBottom"),
    
    TOPLEFTTOBOTTOMRIGHT("topLeftToBottomRight"),
    
    NONE("none");

    private String value;

    DirectionEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DirectionEnum fromValue(String value) {
      for (DirectionEnum b : DirectionEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_DIRECTION = "direction";
  private DirectionEnum direction = DirectionEnum.NONE;

  public static final String JSON_PROPERTY_DURATION = "duration";
  private Float duration = 1f;

  public static final String JSON_PROPERTY_FLY_AREA_OPAQUE = "flyAreaOpaque";
  private Boolean flyAreaOpaque = false;

  public static final String JSON_PROPERTY_FLY_SCALE = "flyScale";
  private Float flyScale = 1f;

  public static final String JSON_PROPERTY_PAGES = "pages";
  private String pages = "";

  /**
   * The style of transition animation.  *   blinds &#x3D; Crossfades *   box &#x3D; Crossfades in a rectangular pattern *   cover &#x3D; Covers *   dissolve &#x3D; Dissolves *   fade &#x3D; Fades *   fly &#x3D; Page flies in *   glitter &#x3D; Page dissolves and is replaced *   push &#x3D; Page is pushed out *   split &#x3D; Splits page *   uncover &#x3D; Uncovers page *   wipe &#x3D; Wipes page *   none &#x3D; No special effect
   */
  public enum StyleEnum {
    BLINDS("blinds"),
    
    BOX("box"),
    
    COVER("cover"),
    
    DISSOLVE("dissolve"),
    
    FADE("fade"),
    
    FLY("fly"),
    
    GLITTER("glitter"),
    
    PUSH("push"),
    
    SPLIT("split"),
    
    UNCOVER("uncover"),
    
    WIPE("wipe"),
    
    NONE("none");

    private String value;

    StyleEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StyleEnum fromValue(String value) {
      for (StyleEnum b : StyleEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STYLE = "style";
  private StyleEnum style = StyleEnum.NONE;

  public OperationTransition() {
  }

  public OperationTransition autoScroll(Boolean autoScroll) {
    
    this.autoScroll = autoScroll;
    return this;
  }

  /**
   * If true, the next page to be automatically shown completely in full screen presentation mode after a specific time.
   * @return autoScroll
   **/
  @Nullable
  @Schema(name = "If true, the next page to be automatically shown completely in full screen presentation mode after a specific time.")
  @JsonProperty(JSON_PROPERTY_AUTO_SCROLL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAutoScroll() {
    return autoScroll;
  }


  @JsonProperty(JSON_PROPERTY_AUTO_SCROLL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAutoScroll(Boolean autoScroll) {
    this.autoScroll = autoScroll;
  }


  public OperationTransition autoScrollTime(Float autoScrollTime) {
    
    this.autoScrollTime = autoScrollTime;
    return this;
  }

  /**
   * The time it will take for the next page to be automatically shown completely in full screen presentation mode.
   * minimum: 0
   * @return autoScrollTime
   **/
  @Nullable
  @Schema(name = "The time it will take for the next page to be automatically shown completely in full screen presentation mode.")
  @JsonProperty(JSON_PROPERTY_AUTO_SCROLL_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getAutoScrollTime() {
    return autoScrollTime;
  }


  @JsonProperty(JSON_PROPERTY_AUTO_SCROLL_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAutoScrollTime(Float autoScrollTime) {
    this.autoScrollTime = autoScrollTime;
  }


  public OperationTransition direction(DirectionEnum direction) {
    
    this.direction = direction;
    return this;
  }

  /**
   * The direction of the transition animation (provided that it can be applied to the animation).  *   leftToRight &#x3D; From left to right *   bottomToTop &#x3D; From bottom to top *   rightToLeft &#x3D; From right to left *   topToBottom &#x3D; From top to bottom *   topLeftToBottomRight &#x3D; From top left to bottom right *   none &#x3D; Use the default value for the animation
   * @return direction
   **/
  @Nullable
  @Schema(name = "The direction of the transition animation (provided that it can be applied to the animation).  *   leftToRight = From left to right *   bottomToTop = From bottom to top *   rightToLeft = From right to left *   topToBottom = From top to bottom *   topLeftToBottomRight = From top left to bottom right *   none = Use the default value for the animation")
  @JsonProperty(JSON_PROPERTY_DIRECTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DirectionEnum getDirection() {
    return direction;
  }


  @JsonProperty(JSON_PROPERTY_DIRECTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDirection(DirectionEnum direction) {
    this.direction = direction;
  }


  public OperationTransition duration(Float duration) {
    
    this.duration = duration;
    return this;
  }

  /**
   * The page transition animation&#39;s duration, in seconds. Make sure to avoid excessively high values, as certain reader programs will force the entire animation to be displayed without any option for interrupting it. Moreover, an excessively long animation can result in display and execution errors in the reader program. Values under 10 seconds are recommendable.
   * minimum: 0
   * @return duration
   **/
  @Nullable
  @Schema(name = "The page transition animation's duration, in seconds. Make sure to avoid excessively high values, as certain reader programs will force the entire animation to be displayed without any option for interrupting it. Moreover, an excessively long animation can result in display and execution errors in the reader program. Values under 10 seconds are recommendable.")
  @JsonProperty(JSON_PROPERTY_DURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getDuration() {
    return duration;
  }


  @JsonProperty(JSON_PROPERTY_DURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDuration(Float duration) {
    this.duration = duration;
  }


  public OperationTransition flyAreaOpaque(Boolean flyAreaOpaque) {
    
    this.flyAreaOpaque = flyAreaOpaque;
    return this;
  }

  /**
   * Option for the \&quot;fly\&quot; animation style - used to define whether the page background for the page that flies in should be transparent initially.
   * @return flyAreaOpaque
   **/
  @Nullable
  @Schema(name = "Option for the \"fly\" animation style - used to define whether the page background for the page that flies in should be transparent initially.")
  @JsonProperty(JSON_PROPERTY_FLY_AREA_OPAQUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getFlyAreaOpaque() {
    return flyAreaOpaque;
  }


  @JsonProperty(JSON_PROPERTY_FLY_AREA_OPAQUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFlyAreaOpaque(Boolean flyAreaOpaque) {
    this.flyAreaOpaque = flyAreaOpaque;
  }


  public OperationTransition flyScale(Float flyScale) {
    
    this.flyScale = flyScale;
    return this;
  }

  /**
   * Option for the \&quot;fly\&quot; animation style - used to define the starting scale for the page that flies in. The page will smoothly be scaled from this starting scale all the way to the size of the page being displayed.
   * @return flyScale
   **/
  @Nullable
  @Schema(name = "Option for the \"fly\" animation style - used to define the starting scale for the page that flies in. The page will smoothly be scaled from this starting scale all the way to the size of the page being displayed.")
  @JsonProperty(JSON_PROPERTY_FLY_SCALE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getFlyScale() {
    return flyScale;
  }


  @JsonProperty(JSON_PROPERTY_FLY_SCALE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFlyScale(Float flyScale) {
    this.flyScale = flyScale;
  }


  public OperationTransition pages(String pages) {
    
    this.pages = pages;
    return this;
  }

  /**
   * Used to define the page number or page range (e.g., \&quot;1,5-6,9\&quot;) to which the transition animation should be applied.
   * @return pages
   **/
  @Nullable
  @Schema(name = "Used to define the page number or page range (e.g., \"1,5-6,9\") to which the transition animation should be applied.")
  @JsonProperty(JSON_PROPERTY_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPages() {
    return pages;
  }


  @JsonProperty(JSON_PROPERTY_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPages(String pages) {
    this.pages = pages;
  }


  public OperationTransition style(StyleEnum style) {
    
    this.style = style;
    return this;
  }

  /**
   * The style of transition animation.  *   blinds &#x3D; Crossfades *   box &#x3D; Crossfades in a rectangular pattern *   cover &#x3D; Covers *   dissolve &#x3D; Dissolves *   fade &#x3D; Fades *   fly &#x3D; Page flies in *   glitter &#x3D; Page dissolves and is replaced *   push &#x3D; Page is pushed out *   split &#x3D; Splits page *   uncover &#x3D; Uncovers page *   wipe &#x3D; Wipes page *   none &#x3D; No special effect
   * @return style
   **/
  @Nullable
  @Schema(name = "The style of transition animation.  *   blinds = Crossfades *   box = Crossfades in a rectangular pattern *   cover = Covers *   dissolve = Dissolves *   fade = Fades *   fly = Page flies in *   glitter = Page dissolves and is replaced *   push = Page is pushed out *   split = Splits page *   uncover = Uncovers page *   wipe = Wipes page *   none = No special effect")
  @JsonProperty(JSON_PROPERTY_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StyleEnum getStyle() {
    return style;
  }


  @JsonProperty(JSON_PROPERTY_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStyle(StyleEnum style) {
    this.style = style;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationTransition operationTransition = (OperationTransition) o;
    return Objects.equals(this.autoScroll, operationTransition.autoScroll) &&
        Objects.equals(this.autoScrollTime, operationTransition.autoScrollTime) &&
        Objects.equals(this.direction, operationTransition.direction) &&
        Objects.equals(this.duration, operationTransition.duration) &&
        Objects.equals(this.flyAreaOpaque, operationTransition.flyAreaOpaque) &&
        Objects.equals(this.flyScale, operationTransition.flyScale) &&
        Objects.equals(this.pages, operationTransition.pages) &&
        Objects.equals(this.style, operationTransition.style);
  }

  @Override
  public int hashCode() {
    return Objects.hash(autoScroll, autoScrollTime, direction, duration, flyAreaOpaque, flyScale, pages, style);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationTransition {\n");
    sb.append("    autoScroll: ").append(toIndentedString(autoScroll)).append("\n");
    sb.append("    autoScrollTime: ").append(toIndentedString(autoScrollTime)).append("\n");
    sb.append("    direction: ").append(toIndentedString(direction)).append("\n");
    sb.append("    duration: ").append(toIndentedString(duration)).append("\n");
    sb.append("    flyAreaOpaque: ").append(toIndentedString(flyAreaOpaque)).append("\n");
    sb.append("    flyScale: ").append(toIndentedString(flyScale)).append("\n");
    sb.append("    pages: ").append(toIndentedString(pages)).append("\n");
    sb.append("    style: ").append(toIndentedString(style)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
