/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 9.0.0.3479 (2024-07-23T08:38:02Z) 
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * The transcribe operation element can be used to convert a PDF document into other document formats. Errors and inaccuracies can always occur during such conversions, so the endpoint allows a report to be generated to detect and evaluate possible transfer errors both in the event of an error and in the event of a success.
 */
@Schema(description = "The transcribe operation element can be used to convert a PDF document into other document formats. Errors and inaccuracies can always occur during such conversions, so the endpoint allows a report to be generated to detect and evaluate possible transfer errors both in the event of an error and in the event of a success.")
@JsonPropertyOrder({
  OperationToolboxTranscribeTranscribe.JSON_PROPERTY_ERROR_REPORT,
  OperationToolboxTranscribeTranscribe.JSON_PROPERTY_FAILURE_LEVEL,
  OperationToolboxTranscribeTranscribe.JSON_PROPERTY_HTML,
  OperationToolboxTranscribeTranscribe.JSON_PROPERTY_SUCCESS_REPORT
})
@JsonTypeName("Operation_ToolboxTranscribe_transcribe")

public class OperationToolboxTranscribeTranscribe {
  /**
   * This parameter determines if and in which form the XML report for a failed conversion is returned.  *   none &#x3D; XML report is not returned *   message &#x3D; XML report will be delivered as part of the error message *   file &#x3D; XML report is saved to file
   */
  public enum ErrorReportEnum {
    NONE("none"),
    
    FILE("file"),
    
    MESSAGE("message");

    private String value;

    ErrorReportEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ErrorReportEnum fromValue(String value) {
      for (ErrorReportEnum b : ErrorReportEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ERROR_REPORT = "errorReport";
  private ErrorReportEnum errorReport = ErrorReportEnum.NONE;

  /**
   * This parameter determines at which error level the conversion should fail, you can use this parameter to automatically reject also results with lower precision as failure  *   warning &#x3D; Documents for which warnings occur will also cause the conversion to fail. *   missingContent &#x3D; Documents for which not all content could be converted correctly will also be considered as failures. *   error &#x3D; Only if a conversion of the document did not lead to any meaningful result document, this is evaluated as failure, even if contents should be missing.
   */
  public enum FailureLevelEnum {
    WARNING("warning"),
    
    MISSINGCONTENT("missingContent"),
    
    ERROR("error");

    private String value;

    FailureLevelEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static FailureLevelEnum fromValue(String value) {
      for (FailureLevelEnum b : FailureLevelEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_FAILURE_LEVEL = "failureLevel";
  private FailureLevelEnum failureLevel = FailureLevelEnum.ERROR;

  public static final String JSON_PROPERTY_HTML = "html";
  private OperationHtmlTranscribe html;

  /**
   * This parameter determines if and in which form the XML report for a successful conversion is returned.  *   none &#x3D; XML report is not returned *   linked &#x3D; XML report is appended to the end of the target document. *   zip &#x3D; target document and XML report are packed together in a ZIP archive.  **Important:** The format of the document created at \&quot;errorReport\&quot; and \&quot;successReport\&quot; is described via the http://schema.webpdf.de/1.0/report/transcribe.xsd schema.
   */
  public enum SuccessReportEnum {
    NONE("none"),
    
    ZIP("zip"),
    
    LINKED("linked");

    private String value;

    SuccessReportEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SuccessReportEnum fromValue(String value) {
      for (SuccessReportEnum b : SuccessReportEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SUCCESS_REPORT = "successReport";
  private SuccessReportEnum successReport = SuccessReportEnum.NONE;

  public OperationToolboxTranscribeTranscribe() {
  }

  public OperationToolboxTranscribeTranscribe errorReport(ErrorReportEnum errorReport) {
    
    this.errorReport = errorReport;
    return this;
  }

  /**
   * This parameter determines if and in which form the XML report for a failed conversion is returned.  *   none &#x3D; XML report is not returned *   message &#x3D; XML report will be delivered as part of the error message *   file &#x3D; XML report is saved to file
   * @return errorReport
   **/
  @Nullable
  @Schema(name = "This parameter determines if and in which form the XML report for a failed conversion is returned.  *   none = XML report is not returned *   message = XML report will be delivered as part of the error message *   file = XML report is saved to file")
  @JsonProperty(JSON_PROPERTY_ERROR_REPORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ErrorReportEnum getErrorReport() {
    return errorReport;
  }


  @JsonProperty(JSON_PROPERTY_ERROR_REPORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setErrorReport(ErrorReportEnum errorReport) {
    this.errorReport = errorReport;
  }


  public OperationToolboxTranscribeTranscribe failureLevel(FailureLevelEnum failureLevel) {
    
    this.failureLevel = failureLevel;
    return this;
  }

  /**
   * This parameter determines at which error level the conversion should fail, you can use this parameter to automatically reject also results with lower precision as failure  *   warning &#x3D; Documents for which warnings occur will also cause the conversion to fail. *   missingContent &#x3D; Documents for which not all content could be converted correctly will also be considered as failures. *   error &#x3D; Only if a conversion of the document did not lead to any meaningful result document, this is evaluated as failure, even if contents should be missing.
   * @return failureLevel
   **/
  @Nullable
  @Schema(name = "This parameter determines at which error level the conversion should fail, you can use this parameter to automatically reject also results with lower precision as failure  *   warning = Documents for which warnings occur will also cause the conversion to fail. *   missingContent = Documents for which not all content could be converted correctly will also be considered as failures. *   error = Only if a conversion of the document did not lead to any meaningful result document, this is evaluated as failure, even if contents should be missing.")
  @JsonProperty(JSON_PROPERTY_FAILURE_LEVEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public FailureLevelEnum getFailureLevel() {
    return failureLevel;
  }


  @JsonProperty(JSON_PROPERTY_FAILURE_LEVEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFailureLevel(FailureLevelEnum failureLevel) {
    this.failureLevel = failureLevel;
  }


  public OperationToolboxTranscribeTranscribe html(OperationHtmlTranscribe html) {
    
    this.html = html;
    return this;
  }

  /**
   * Get html
   * @return html
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_HTML)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationHtmlTranscribe getHtml() {
    return html;
  }


  @JsonProperty(JSON_PROPERTY_HTML)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHtml(OperationHtmlTranscribe html) {
    this.html = html;
  }


  public OperationToolboxTranscribeTranscribe successReport(SuccessReportEnum successReport) {
    
    this.successReport = successReport;
    return this;
  }

  /**
   * This parameter determines if and in which form the XML report for a successful conversion is returned.  *   none &#x3D; XML report is not returned *   linked &#x3D; XML report is appended to the end of the target document. *   zip &#x3D; target document and XML report are packed together in a ZIP archive.  **Important:** The format of the document created at \&quot;errorReport\&quot; and \&quot;successReport\&quot; is described via the http://schema.webpdf.de/1.0/report/transcribe.xsd schema.
   * @return successReport
   **/
  @Nullable
  @Schema(name = "This parameter determines if and in which form the XML report for a successful conversion is returned.  *   none = XML report is not returned *   linked = XML report is appended to the end of the target document. *   zip = target document and XML report are packed together in a ZIP archive.  **Important:** The format of the document created at \"errorReport\" and \"successReport\" is described via the http://schema.webpdf.de/1.0/report/transcribe.xsd schema.")
  @JsonProperty(JSON_PROPERTY_SUCCESS_REPORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SuccessReportEnum getSuccessReport() {
    return successReport;
  }


  @JsonProperty(JSON_PROPERTY_SUCCESS_REPORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSuccessReport(SuccessReportEnum successReport) {
    this.successReport = successReport;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationToolboxTranscribeTranscribe operationToolboxTranscribeTranscribe = (OperationToolboxTranscribeTranscribe) o;
    return Objects.equals(this.errorReport, operationToolboxTranscribeTranscribe.errorReport) &&
        Objects.equals(this.failureLevel, operationToolboxTranscribeTranscribe.failureLevel) &&
        Objects.equals(this.html, operationToolboxTranscribeTranscribe.html) &&
        Objects.equals(this.successReport, operationToolboxTranscribeTranscribe.successReport);
  }

  @Override
  public int hashCode() {
    return Objects.hash(errorReport, failureLevel, html, successReport);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationToolboxTranscribeTranscribe {\n");
    sb.append("    errorReport: ").append(toIndentedString(errorReport)).append("\n");
    sb.append("    failureLevel: ").append(toIndentedString(failureLevel)).append("\n");
    sb.append("    html: ").append(toIndentedString(html)).append("\n");
    sb.append("    successReport: ").append(toIndentedString(successReport)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
