/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 9.0.0.3479 (2024-07-23T08:38:02Z) 
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * The rotate operation element can be used to rotate pages in the document.
 */
@Schema(description = "The rotate operation element can be used to rotate pages in the document.")
@JsonPropertyOrder({
  OperationToolboxRotateRotate.JSON_PROPERTY_DEGREES,
  OperationToolboxRotateRotate.JSON_PROPERTY_ORIENTATION_DETECT_MODE,
  OperationToolboxRotateRotate.JSON_PROPERTY_PAGE_GROUP,
  OperationToolboxRotateRotate.JSON_PROPERTY_PAGE_ORIENTATION,
  OperationToolboxRotateRotate.JSON_PROPERTY_PAGES
})
@JsonTypeName("Operation_ToolboxRotate_rotate")

public class OperationToolboxRotateRotate {
  public static final String JSON_PROPERTY_DEGREES = "degrees";
  private Integer degrees = 90;

  /**
   * Selects which criteria to use to determine the orientation (portrait/landscape) of pages (see also \&quot;pageOrientation\&quot;):  *   value &#x3D; Based solely on the page rotation value entered in the PDF. *   dimensions &#x3D; Based on the ratio of the page dimensions to each other.
   */
  public enum OrientationDetectModeEnum {
    VALUE("value"),
    
    DIMENSIONS("dimensions");

    private String value;

    OrientationDetectModeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static OrientationDetectModeEnum fromValue(String value) {
      for (OrientationDetectModeEnum b : OrientationDetectModeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ORIENTATION_DETECT_MODE = "orientationDetectMode";
  private OrientationDetectModeEnum orientationDetectMode = OrientationDetectModeEnum.VALUE;

  /**
   * Used to select pages based on their page number within the specified page range:  *   all &#x3D; All pages *   even &#x3D; All pages with an even page number *   odd &#x3D; All pages with an odd page number
   */
  public enum PageGroupEnum {
    ALL("all"),
    
    EVEN("even"),
    
    ODD("odd");

    private String value;

    PageGroupEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PageGroupEnum fromValue(String value) {
      for (PageGroupEnum b : PageGroupEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PAGE_GROUP = "pageGroup";
  private PageGroupEnum pageGroup = PageGroupEnum.ALL;

  /**
   * Used to select pages based on their orientation within the specified page range:  *   any &#x3D; All pages *   portrait &#x3D; All pages in portrait format *   landscape &#x3D; All pages in landscape format
   */
  public enum PageOrientationEnum {
    ANY("any"),
    
    PORTRAIT("portrait"),
    
    LANDSCAPE("landscape");

    private String value;

    PageOrientationEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PageOrientationEnum fromValue(String value) {
      for (PageOrientationEnum b : PageOrientationEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PAGE_ORIENTATION = "pageOrientation";
  private PageOrientationEnum pageOrientation = PageOrientationEnum.ANY;

  public static final String JSON_PROPERTY_PAGES = "pages";
  private String pages = "1";

  public OperationToolboxRotateRotate() {
  }

  public OperationToolboxRotateRotate degrees(Integer degrees) {
    
    this.degrees = degrees;
    return this;
  }

  /**
   * Used to specify the clockwise rotation in degrees. The rotation is always in 90-degree increments (0, 90, 180, 270, 360). Deviating values will always be rounded down to the next lower increment (e.g.: 32 degrees will become 0 degrees and 101 degrees will become 90 degrees). Once the rotation is completed, the new value will be normalized to a range of 0 to 359 degrees. If the page being rotated has an impermissible value (e.g. 112 degrees), this value will be adjusted before the rotation operation as well (112 degrees will become 90 degrees).
   * minimum: 0
   * maximum: 360
   * @return degrees
   **/
  @Nullable
  @Schema(name = "Used to specify the clockwise rotation in degrees. The rotation is always in 90-degree increments (0, 90, 180, 270, 360). Deviating values will always be rounded down to the next lower increment (e.g.: 32 degrees will become 0 degrees and 101 degrees will become 90 degrees). Once the rotation is completed, the new value will be normalized to a range of 0 to 359 degrees. If the page being rotated has an impermissible value (e.g. 112 degrees), this value will be adjusted before the rotation operation as well (112 degrees will become 90 degrees).")
  @JsonProperty(JSON_PROPERTY_DEGREES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getDegrees() {
    return degrees;
  }


  @JsonProperty(JSON_PROPERTY_DEGREES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDegrees(Integer degrees) {
    this.degrees = degrees;
  }


  public OperationToolboxRotateRotate orientationDetectMode(OrientationDetectModeEnum orientationDetectMode) {
    
    this.orientationDetectMode = orientationDetectMode;
    return this;
  }

  /**
   * Selects which criteria to use to determine the orientation (portrait/landscape) of pages (see also \&quot;pageOrientation\&quot;):  *   value &#x3D; Based solely on the page rotation value entered in the PDF. *   dimensions &#x3D; Based on the ratio of the page dimensions to each other.
   * @return orientationDetectMode
   **/
  @Nullable
  @Schema(name = "Selects which criteria to use to determine the orientation (portrait/landscape) of pages (see also \"pageOrientation\"):  *   value = Based solely on the page rotation value entered in the PDF. *   dimensions = Based on the ratio of the page dimensions to each other.")
  @JsonProperty(JSON_PROPERTY_ORIENTATION_DETECT_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OrientationDetectModeEnum getOrientationDetectMode() {
    return orientationDetectMode;
  }


  @JsonProperty(JSON_PROPERTY_ORIENTATION_DETECT_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOrientationDetectMode(OrientationDetectModeEnum orientationDetectMode) {
    this.orientationDetectMode = orientationDetectMode;
  }


  public OperationToolboxRotateRotate pageGroup(PageGroupEnum pageGroup) {
    
    this.pageGroup = pageGroup;
    return this;
  }

  /**
   * Used to select pages based on their page number within the specified page range:  *   all &#x3D; All pages *   even &#x3D; All pages with an even page number *   odd &#x3D; All pages with an odd page number
   * @return pageGroup
   **/
  @Nullable
  @Schema(name = "Used to select pages based on their page number within the specified page range:  *   all = All pages *   even = All pages with an even page number *   odd = All pages with an odd page number")
  @JsonProperty(JSON_PROPERTY_PAGE_GROUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PageGroupEnum getPageGroup() {
    return pageGroup;
  }


  @JsonProperty(JSON_PROPERTY_PAGE_GROUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPageGroup(PageGroupEnum pageGroup) {
    this.pageGroup = pageGroup;
  }


  public OperationToolboxRotateRotate pageOrientation(PageOrientationEnum pageOrientation) {
    
    this.pageOrientation = pageOrientation;
    return this;
  }

  /**
   * Used to select pages based on their orientation within the specified page range:  *   any &#x3D; All pages *   portrait &#x3D; All pages in portrait format *   landscape &#x3D; All pages in landscape format
   * @return pageOrientation
   **/
  @Nullable
  @Schema(name = "Used to select pages based on their orientation within the specified page range:  *   any = All pages *   portrait = All pages in portrait format *   landscape = All pages in landscape format")
  @JsonProperty(JSON_PROPERTY_PAGE_ORIENTATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PageOrientationEnum getPageOrientation() {
    return pageOrientation;
  }


  @JsonProperty(JSON_PROPERTY_PAGE_ORIENTATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPageOrientation(PageOrientationEnum pageOrientation) {
    this.pageOrientation = pageOrientation;
  }


  public OperationToolboxRotateRotate pages(String pages) {
    
    this.pages = pages;
    return this;
  }

  /**
   * Defines which page(s) should be rotated. The page number can be an individual page, a page range, or a list (separated with commas) (e.g., \&quot;1,5-6,9\&quot;). To specify \&quot;all pages,\&quot; use an asterisk (\&quot;\\*\&quot;).
   * @return pages
   **/
  @Nullable
  @Schema(name = "Defines which page(s) should be rotated. The page number can be an individual page, a page range, or a list (separated with commas) (e.g., \"1,5-6,9\"). To specify \"all pages,\" use an asterisk (\"\\*\").")
  @JsonProperty(JSON_PROPERTY_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPages() {
    return pages;
  }


  @JsonProperty(JSON_PROPERTY_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPages(String pages) {
    this.pages = pages;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationToolboxRotateRotate operationToolboxRotateRotate = (OperationToolboxRotateRotate) o;
    return Objects.equals(this.degrees, operationToolboxRotateRotate.degrees) &&
        Objects.equals(this.orientationDetectMode, operationToolboxRotateRotate.orientationDetectMode) &&
        Objects.equals(this.pageGroup, operationToolboxRotateRotate.pageGroup) &&
        Objects.equals(this.pageOrientation, operationToolboxRotateRotate.pageOrientation) &&
        Objects.equals(this.pages, operationToolboxRotateRotate.pages);
  }

  @Override
  public int hashCode() {
    return Objects.hash(degrees, orientationDetectMode, pageGroup, pageOrientation, pages);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationToolboxRotateRotate {\n");
    sb.append("    degrees: ").append(toIndentedString(degrees)).append("\n");
    sb.append("    orientationDetectMode: ").append(toIndentedString(orientationDetectMode)).append("\n");
    sb.append("    pageGroup: ").append(toIndentedString(pageGroup)).append("\n");
    sb.append("    pageOrientation: ").append(toIndentedString(pageOrientation)).append("\n");
    sb.append("    pages: ").append(toIndentedString(pages)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
