/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 9.0.0.3479 (2024-07-23T08:38:02Z) 
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * The move operation element can be used to change the order of the document&#39;s pages.
 */
@Schema(description = "The move operation element can be used to change the order of the document's pages.")
@JsonPropertyOrder({
  OperationToolboxMoveMove.JSON_PROPERTY_MODE,
  OperationToolboxMoveMove.JSON_PROPERTY_ORDER,
  OperationToolboxMoveMove.JSON_PROPERTY_PAGES,
  OperationToolboxMoveMove.JSON_PROPERTY_TARGET_POSITION
})
@JsonTypeName("Operation_ToolboxMove_move")

public class OperationToolboxMoveMove {
  /**
   * Used to specify whether the selected page range should be inserted before or after the selected position in the document.  *   afterPage &#x3D; After the selected position. *   beforePage &#x3D; Before the selected position.
   */
  public enum ModeEnum {
    BEFOREPAGE("beforePage"),
    
    AFTERPAGE("afterPage");

    private String value;

    ModeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ModeEnum fromValue(String value) {
      for (ModeEnum b : ModeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_MODE = "mode";
  private ModeEnum mode = ModeEnum.AFTERPAGE;

  /**
   * Used to select the order of the selected pages at the new position.  *   preserve &#x3D; Keeps the original order in which the pages were found in the document. *   reverse &#x3D; Reverses the original order in which the pages were found in the document.
   */
  public enum OrderEnum {
    PRESERVE("preserve"),
    
    REVERSE("reverse");

    private String value;

    OrderEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static OrderEnum fromValue(String value) {
      for (OrderEnum b : OrderEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ORDER = "order";
  private OrderEnum order = OrderEnum.PRESERVE;

  public static final String JSON_PROPERTY_PAGES = "pages";
  private String pages = "1";

  public static final String JSON_PROPERTY_TARGET_POSITION = "targetPosition";
  private Integer targetPosition = 1;

  public OperationToolboxMoveMove() {
  }

  public OperationToolboxMoveMove mode(ModeEnum mode) {
    
    this.mode = mode;
    return this;
  }

  /**
   * Used to specify whether the selected page range should be inserted before or after the selected position in the document.  *   afterPage &#x3D; After the selected position. *   beforePage &#x3D; Before the selected position.
   * @return mode
   **/
  @Nullable
  @Schema(name = "Used to specify whether the selected page range should be inserted before or after the selected position in the document.  *   afterPage = After the selected position. *   beforePage = Before the selected position.")
  @JsonProperty(JSON_PROPERTY_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ModeEnum getMode() {
    return mode;
  }


  @JsonProperty(JSON_PROPERTY_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMode(ModeEnum mode) {
    this.mode = mode;
  }


  public OperationToolboxMoveMove order(OrderEnum order) {
    
    this.order = order;
    return this;
  }

  /**
   * Used to select the order of the selected pages at the new position.  *   preserve &#x3D; Keeps the original order in which the pages were found in the document. *   reverse &#x3D; Reverses the original order in which the pages were found in the document.
   * @return order
   **/
  @Nullable
  @Schema(name = "Used to select the order of the selected pages at the new position.  *   preserve = Keeps the original order in which the pages were found in the document. *   reverse = Reverses the original order in which the pages were found in the document.")
  @JsonProperty(JSON_PROPERTY_ORDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OrderEnum getOrder() {
    return order;
  }


  @JsonProperty(JSON_PROPERTY_ORDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOrder(OrderEnum order) {
    this.order = order;
  }


  public OperationToolboxMoveMove pages(String pages) {
    
    this.pages = pages;
    return this;
  }

  /**
   * Used to define which page(s) should be moved. The page number can be an individual page, a page range, or a list (separated with commas) (e.g., \&quot;1,5-6,9\&quot;).
   * @return pages
   **/
  @Nullable
  @Schema(name = "Used to define which page(s) should be moved. The page number can be an individual page, a page range, or a list (separated with commas) (e.g., \"1,5-6,9\").")
  @JsonProperty(JSON_PROPERTY_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPages() {
    return pages;
  }


  @JsonProperty(JSON_PROPERTY_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPages(String pages) {
    this.pages = pages;
  }


  public OperationToolboxMoveMove targetPosition(Integer targetPosition) {
    
    this.targetPosition = targetPosition;
    return this;
  }

  /**
   * Used to select the page number after or before which the selected page range should be inserted. This page must not be part of the page range being moved.
   * minimum: 1
   * @return targetPosition
   **/
  @Nullable
  @Schema(name = "Used to select the page number after or before which the selected page range should be inserted. This page must not be part of the page range being moved.")
  @JsonProperty(JSON_PROPERTY_TARGET_POSITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getTargetPosition() {
    return targetPosition;
  }


  @JsonProperty(JSON_PROPERTY_TARGET_POSITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTargetPosition(Integer targetPosition) {
    this.targetPosition = targetPosition;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationToolboxMoveMove operationToolboxMoveMove = (OperationToolboxMoveMove) o;
    return Objects.equals(this.mode, operationToolboxMoveMove.mode) &&
        Objects.equals(this.order, operationToolboxMoveMove.order) &&
        Objects.equals(this.pages, operationToolboxMoveMove.pages) &&
        Objects.equals(this.targetPosition, operationToolboxMoveMove.targetPosition);
  }

  @Override
  public int hashCode() {
    return Objects.hash(mode, order, pages, targetPosition);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationToolboxMoveMove {\n");
    sb.append("    mode: ").append(toIndentedString(mode)).append("\n");
    sb.append("    order: ").append(toIndentedString(order)).append("\n");
    sb.append("    pages: ").append(toIndentedString(pages)).append("\n");
    sb.append("    targetPosition: ").append(toIndentedString(targetPosition)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
