/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 9.0.0.3479 (2024-07-23T08:38:02Z) 
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * The merge operation element can be used to merge documents.  **Important:** When a \&quot;merge\&quot; operation is performed, the pages and structural information (such as outlines and tag) will be merged. This can result in name conflicts that can prevent a success. If you would rather like to ignore such conflicts use the matching \&quot;ignoreConflicts\&quot; parameter.  **Important:** Merging documents could also fail because of signatures or a used PDF/A format. As  *   by definition - altering PDF/A documents and signed documents would result in an invalidation of such documents/signatures.
 */
@Schema(description = "The merge operation element can be used to merge documents.  **Important:** When a \"merge\" operation is performed, the pages and structural information (such as outlines and tag) will be merged. This can result in name conflicts that can prevent a success. If you would rather like to ignore such conflicts use the matching \"ignoreConflicts\" parameter.  **Important:** Merging documents could also fail because of signatures or a used PDF/A format. As  *   by definition - altering PDF/A documents and signed documents would result in an invalidation of such documents/signatures.")
@JsonPropertyOrder({
  OperationToolboxMergeMerge.JSON_PROPERTY_DATA,
  OperationToolboxMergeMerge.JSON_PROPERTY_MODE,
  OperationToolboxMergeMerge.JSON_PROPERTY_OUTLINE_NAME,
  OperationToolboxMergeMerge.JSON_PROPERTY_PAGE,
  OperationToolboxMergeMerge.JSON_PROPERTY_REMOVE_STATIC_X_F_A,
  OperationToolboxMergeMerge.JSON_PROPERTY_RESET_METADATA,
  OperationToolboxMergeMerge.JSON_PROPERTY_SOURCE_IS_ZIP
})
@JsonTypeName("Operation_ToolboxMerge_merge")

public class OperationToolboxMergeMerge {
  public static final String JSON_PROPERTY_DATA = "data";
  private OperationMergeFileData data;

  /**
   * Defines the mode used to merge the PDF documents. The PDF document passed with the \&quot;data\&quot; element will be appended to the current PDF document or inserted at a specific point. The following modes define the position where the documents will be inserted. Instead of a single base document, the \&quot;portfolio\&quot; mode always expects a ZIP archive. The elements in this archive will be added, all with identical permissions, to the resulting portfolio (the data element is not required at all for \&quot;portfolio\&quot;).  *   atTheEnd &#x3D; At the end of the PDF document *   atTheBeginning &#x3D; At the beginning of the PDF document *   afterPage &#x3D; After a page (please refer to the \&quot;page\&quot; attribute) in the PDF document *   beforePage &#x3D; Before a page (please refer to the \&quot;page\&quot; attribute) in the PDF document
   */
  public enum ModeEnum {
    ATTHEEND("atTheEnd"),
    
    ATTHEBEGINNING("atTheBeginning"),
    
    AFTERPAGE("afterPage"),
    
    BEFOREPAGE("beforePage");

    private String value;

    ModeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ModeEnum fromValue(String value) {
      for (ModeEnum b : ModeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_MODE = "mode";
  private ModeEnum mode = ModeEnum.ATTHEEND;

  public static final String JSON_PROPERTY_OUTLINE_NAME = "outlineName";
  private String outlineName = "";

  public static final String JSON_PROPERTY_PAGE = "page";
  private Integer page = 1;

  public static final String JSON_PROPERTY_REMOVE_STATIC_X_F_A = "removeStaticXFA";
  private Boolean removeStaticXFA = false;

  public static final String JSON_PROPERTY_RESET_METADATA = "resetMetadata";
  private Boolean resetMetadata = false;

  public static final String JSON_PROPERTY_SOURCE_IS_ZIP = "sourceIsZip";
  private Boolean sourceIsZip = false;

  public OperationToolboxMergeMerge() {
  }

  public OperationToolboxMergeMerge data(OperationMergeFileData data) {
    
    this.data = data;
    return this;
  }

  /**
   * Get data
   * @return data
   **/
  @NotNull
  @Schema(required = true, name = "")
  @JsonProperty(JSON_PROPERTY_DATA)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OperationMergeFileData getData() {
    return data;
  }


  @JsonProperty(JSON_PROPERTY_DATA)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setData(OperationMergeFileData data) {
    this.data = data;
  }


  public OperationToolboxMergeMerge mode(ModeEnum mode) {
    
    this.mode = mode;
    return this;
  }

  /**
   * Defines the mode used to merge the PDF documents. The PDF document passed with the \&quot;data\&quot; element will be appended to the current PDF document or inserted at a specific point. The following modes define the position where the documents will be inserted. Instead of a single base document, the \&quot;portfolio\&quot; mode always expects a ZIP archive. The elements in this archive will be added, all with identical permissions, to the resulting portfolio (the data element is not required at all for \&quot;portfolio\&quot;).  *   atTheEnd &#x3D; At the end of the PDF document *   atTheBeginning &#x3D; At the beginning of the PDF document *   afterPage &#x3D; After a page (please refer to the \&quot;page\&quot; attribute) in the PDF document *   beforePage &#x3D; Before a page (please refer to the \&quot;page\&quot; attribute) in the PDF document
   * @return mode
   **/
  @Nullable
  @Schema(name = "Defines the mode used to merge the PDF documents. The PDF document passed with the \"data\" element will be appended to the current PDF document or inserted at a specific point. The following modes define the position where the documents will be inserted. Instead of a single base document, the \"portfolio\" mode always expects a ZIP archive. The elements in this archive will be added, all with identical permissions, to the resulting portfolio (the data element is not required at all for \"portfolio\").  *   atTheEnd = At the end of the PDF document *   atTheBeginning = At the beginning of the PDF document *   afterPage = After a page (please refer to the \"page\" attribute) in the PDF document *   beforePage = Before a page (please refer to the \"page\" attribute) in the PDF document")
  @JsonProperty(JSON_PROPERTY_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ModeEnum getMode() {
    return mode;
  }


  @JsonProperty(JSON_PROPERTY_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMode(ModeEnum mode) {
    this.mode = mode;
  }


  public OperationToolboxMergeMerge outlineName(String outlineName) {
    
    this.outlineName = outlineName;
    return this;
  }

  /**
   * Used to define the base path that should be used for outline nodes of the source document. This parameter can contain a slash separated path and should ideally end with the name of the document (\&quot;A/B/filename\&quot;). If this parameter is not set, all outlines will be appended to the root outline node.
   * @return outlineName
   **/
  @Nullable
  @Schema(name = "Used to define the base path that should be used for outline nodes of the source document. This parameter can contain a slash separated path and should ideally end with the name of the document (\"A/B/filename\"). If this parameter is not set, all outlines will be appended to the root outline node.")
  @JsonProperty(JSON_PROPERTY_OUTLINE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOutlineName() {
    return outlineName;
  }


  @JsonProperty(JSON_PROPERTY_OUTLINE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOutlineName(String outlineName) {
    this.outlineName = outlineName;
  }


  public OperationToolboxMergeMerge page(Integer page) {
    
    this.page = page;
    return this;
  }

  /**
   * Used to define the page number where the PDF document should be inserted.
   * minimum: 1
   * @return page
   **/
  @Nullable
  @Schema(name = "Used to define the page number where the PDF document should be inserted.")
  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPage() {
    return page;
  }


  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPage(Integer page) {
    this.page = page;
  }


  public OperationToolboxMergeMerge removeStaticXFA(Boolean removeStaticXFA) {
    
    this.removeStaticXFA = removeStaticXFA;
    return this;
  }

  /**
   * If this parameter is enabled, all entries related to static XFA documents and all connected extended permission settings will be removed from the document. Using this parameter it is possible to merge static XFA documents with other documents, which is normally forbidden by default.  **Important:** Although this parameter allows the merging of static XFA documents, this will not create a valid static XFA document as a result. All structures qualifying a document as a static XFA document will be removed. The resulting document will contain a pure Acroform and will not be recognized as a XFA form by applications for XFA creation/editing. Also, all extended access  *   and write permissions will be removed (That normally can expected to be found in a static XFA document).
   * @return removeStaticXFA
   **/
  @Nullable
  @Schema(name = "If this parameter is enabled, all entries related to static XFA documents and all connected extended permission settings will be removed from the document. Using this parameter it is possible to merge static XFA documents with other documents, which is normally forbidden by default.  **Important:** Although this parameter allows the merging of static XFA documents, this will not create a valid static XFA document as a result. All structures qualifying a document as a static XFA document will be removed. The resulting document will contain a pure Acroform and will not be recognized as a XFA form by applications for XFA creation/editing. Also, all extended access  *   and write permissions will be removed (That normally can expected to be found in a static XFA document).")
  @JsonProperty(JSON_PROPERTY_REMOVE_STATIC_X_F_A)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getRemoveStaticXFA() {
    return removeStaticXFA;
  }


  @JsonProperty(JSON_PROPERTY_REMOVE_STATIC_X_F_A)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRemoveStaticXFA(Boolean removeStaticXFA) {
    this.removeStaticXFA = removeStaticXFA;
  }


  public OperationToolboxMergeMerge resetMetadata(Boolean resetMetadata) {
    
    this.resetMetadata = resetMetadata;
    return this;
  }

  /**
   * If you enable this parameter, the source document&#39;s metadata will be removed and replaced with default values.
   * @return resetMetadata
   **/
  @Nullable
  @Schema(name = "If you enable this parameter, the source document's metadata will be removed and replaced with default values.")
  @JsonProperty(JSON_PROPERTY_RESET_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getResetMetadata() {
    return resetMetadata;
  }


  @JsonProperty(JSON_PROPERTY_RESET_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResetMetadata(Boolean resetMetadata) {
    this.resetMetadata = resetMetadata;
  }


  public OperationToolboxMergeMerge sourceIsZip(Boolean sourceIsZip) {
    
    this.sourceIsZip = sourceIsZip;
    return this;
  }

  /**
   * If this parameter is enabled, a ZIP archive  *   containing the documents to merge - will be expected as the webservice&#39;s source document. Also - in that case, the \&quot;data\&quot; parameter is not required. The first element in the ZIP archive will be used as a base document to which all following entries will be appended.  **Important:** The usage of this parameter is expected to be used for the \&quot;portfolio\&quot; mode. All the documents in the ZIP archive will be added to the portfolio receiving identical permission settings.
   * @return sourceIsZip
   **/
  @Nullable
  @Schema(name = "If this parameter is enabled, a ZIP archive  *   containing the documents to merge - will be expected as the webservice's source document. Also - in that case, the \"data\" parameter is not required. The first element in the ZIP archive will be used as a base document to which all following entries will be appended.  **Important:** The usage of this parameter is expected to be used for the \"portfolio\" mode. All the documents in the ZIP archive will be added to the portfolio receiving identical permission settings.")
  @JsonProperty(JSON_PROPERTY_SOURCE_IS_ZIP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSourceIsZip() {
    return sourceIsZip;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_IS_ZIP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceIsZip(Boolean sourceIsZip) {
    this.sourceIsZip = sourceIsZip;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationToolboxMergeMerge operationToolboxMergeMerge = (OperationToolboxMergeMerge) o;
    return Objects.equals(this.data, operationToolboxMergeMerge.data) &&
        Objects.equals(this.mode, operationToolboxMergeMerge.mode) &&
        Objects.equals(this.outlineName, operationToolboxMergeMerge.outlineName) &&
        Objects.equals(this.page, operationToolboxMergeMerge.page) &&
        Objects.equals(this.removeStaticXFA, operationToolboxMergeMerge.removeStaticXFA) &&
        Objects.equals(this.resetMetadata, operationToolboxMergeMerge.resetMetadata) &&
        Objects.equals(this.sourceIsZip, operationToolboxMergeMerge.sourceIsZip);
  }

  @Override
  public int hashCode() {
    return Objects.hash(data, mode, outlineName, page, removeStaticXFA, resetMetadata, sourceIsZip);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationToolboxMergeMerge {\n");
    sb.append("    data: ").append(toIndentedString(data)).append("\n");
    sb.append("    mode: ").append(toIndentedString(mode)).append("\n");
    sb.append("    outlineName: ").append(toIndentedString(outlineName)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    removeStaticXFA: ").append(toIndentedString(removeStaticXFA)).append("\n");
    sb.append("    resetMetadata: ").append(toIndentedString(resetMetadata)).append("\n");
    sb.append("    sourceIsZip: ").append(toIndentedString(sourceIsZip)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
