/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 9.0.0.3479 (2024-07-23T08:38:02Z) 
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * This element is used to configure the display of contents for which the syntax highlighter was unable to identify a known language.
 */
@Schema(description = "This element is used to configure the display of contents for which the syntax highlighter was unable to identify a known language.")
@JsonPropertyOrder({
  OperationTextHighlight.JSON_PROPERTY_COLOR,
  OperationTextHighlight.JSON_PROPERTY_FONT_FAMILY,
  OperationTextHighlight.JSON_PROPERTY_FONT_ORIGIN,
  OperationTextHighlight.JSON_PROPERTY_FONT_SIZE,
  OperationTextHighlight.JSON_PROPERTY_LINE_HEIGHT,
  OperationTextHighlight.JSON_PROPERTY_LINE_NUMBERS,
  OperationTextHighlight.JSON_PROPERTY_WORD_BREAK
})
@JsonTypeName("Operation_TextHighlight")

public class OperationTextHighlight {
  public static final String JSON_PROPERTY_COLOR = "color";
  private String color = "#000000";

  public static final String JSON_PROPERTY_FONT_FAMILY = "fontFamily";
  private String fontFamily = "";

  /**
   * Used to specify whether the selected font should be obtained from your operating system or from the \&quot;templates/fonts\&quot; folder (in your webPDF installation path). Possible values:  *   system &#x3D; It will be possible to select from the fonts available system-wide. *   folder &#x3D;It will be possible to select from the fonts in \&quot;templates/fonts\&quot;.
   */
  public enum FontOriginEnum {
    SYSTEM("system"),
    
    FOLDER("folder");

    private String value;

    FontOriginEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static FontOriginEnum fromValue(String value) {
      for (FontOriginEnum b : FontOriginEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_FONT_ORIGIN = "fontOrigin";
  private FontOriginEnum fontOrigin = FontOriginEnum.SYSTEM;

  public static final String JSON_PROPERTY_FONT_SIZE = "fontSize";
  private String fontSize = "10px";

  public static final String JSON_PROPERTY_LINE_HEIGHT = "lineHeight";
  private String lineHeight = "12px";

  public static final String JSON_PROPERTY_LINE_NUMBERS = "lineNumbers";
  private Boolean lineNumbers = false;

  /**
   * Can be used to configure the word wrap behaviour during highlighting Possible values:  *   auto &#x3D; Automatic word wrap if necessary. *   none &#x3D; Suppress the addition of extra line breaks. *   word &#x3D; Line breaks allowed only after words. *   all &#x3D; Line breaks allowed unconditionally.
   */
  public enum WordBreakEnum {
    AUTO("auto"),
    
    NONE("none"),
    
    WORD("word"),
    
    ALL("all");

    private String value;

    WordBreakEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static WordBreakEnum fromValue(String value) {
      for (WordBreakEnum b : WordBreakEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_WORD_BREAK = "wordBreak";
  private WordBreakEnum wordBreak = WordBreakEnum.AUTO;

  public OperationTextHighlight() {
  }

  public OperationTextHighlight color(String color) {
    
    this.color = color;
    return this;
  }

  /**
   * Sets the font color for the text to the given value. The colour needs to be specified as a hexadecimal RGB value with a number sign before it.
   * @return color
   **/
  @Nullable
  @Schema(name = "Sets the font color for the text to the given value. The colour needs to be specified as a hexadecimal RGB value with a number sign before it.")
  @JsonProperty(JSON_PROPERTY_COLOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getColor() {
    return color;
  }


  @JsonProperty(JSON_PROPERTY_COLOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setColor(String color) {
    this.color = color;
  }


  public OperationTextHighlight fontFamily(String fontFamily) {
    
    this.fontFamily = fontFamily;
    return this;
  }

  /**
   * Specifies the font to use for the text. If you select \&quot;folder\&quot; for the \&quot;fontOrigin\&quot; parameter, the font here needs to be specified with the filename for the file. Otherwise, use the name of the font you want. If the value is left blank, the \&quot;SourceHanSans\&quot; font will be used automatically.
   * @return fontFamily
   **/
  @Nullable
  @Schema(name = "Specifies the font to use for the text. If you select \"folder\" for the \"fontOrigin\" parameter, the font here needs to be specified with the filename for the file. Otherwise, use the name of the font you want. If the value is left blank, the \"SourceHanSans\" font will be used automatically.")
  @JsonProperty(JSON_PROPERTY_FONT_FAMILY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFontFamily() {
    return fontFamily;
  }


  @JsonProperty(JSON_PROPERTY_FONT_FAMILY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFontFamily(String fontFamily) {
    this.fontFamily = fontFamily;
  }


  public OperationTextHighlight fontOrigin(FontOriginEnum fontOrigin) {
    
    this.fontOrigin = fontOrigin;
    return this;
  }

  /**
   * Used to specify whether the selected font should be obtained from your operating system or from the \&quot;templates/fonts\&quot; folder (in your webPDF installation path). Possible values:  *   system &#x3D; It will be possible to select from the fonts available system-wide. *   folder &#x3D;It will be possible to select from the fonts in \&quot;templates/fonts\&quot;.
   * @return fontOrigin
   **/
  @Nullable
  @Schema(name = "Used to specify whether the selected font should be obtained from your operating system or from the \"templates/fonts\" folder (in your webPDF installation path). Possible values:  *   system = It will be possible to select from the fonts available system-wide. *   folder =It will be possible to select from the fonts in \"templates/fonts\".")
  @JsonProperty(JSON_PROPERTY_FONT_ORIGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public FontOriginEnum getFontOrigin() {
    return fontOrigin;
  }


  @JsonProperty(JSON_PROPERTY_FONT_ORIGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFontOrigin(FontOriginEnum fontOrigin) {
    this.fontOrigin = fontOrigin;
  }


  public OperationTextHighlight fontSize(String fontSize) {
    
    this.fontSize = fontSize;
    return this;
  }

  /**
   * Used to set the font size for the text to the specified value. You can use any of the following units:  *   px &#x3D; Pixels *   cm &#x3D; Centimeters *   mm &#x3D; Millimeters *   in &#x3D; Inches *   pt &#x3D; Points *   pc &#x3D; Pica
   * @return fontSize
   **/
  @Nullable
  @Schema(name = "Used to set the font size for the text to the specified value. You can use any of the following units:  *   px = Pixels *   cm = Centimeters *   mm = Millimeters *   in = Inches *   pt = Points *   pc = Pica")
  @JsonProperty(JSON_PROPERTY_FONT_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFontSize() {
    return fontSize;
  }


  @JsonProperty(JSON_PROPERTY_FONT_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFontSize(String fontSize) {
    this.fontSize = fontSize;
  }


  public OperationTextHighlight lineHeight(String lineHeight) {
    
    this.lineHeight = lineHeight;
    return this;
  }

  /**
   * Used to set the line height. You can use any of the following units:  *   px &#x3D; Pixels *   cm &#x3D; Centimeters *   mm &#x3D; Millimeters *   in &#x3D; Inches *   pt &#x3D; Points *   pc &#x3D; Pica
   * @return lineHeight
   **/
  @Nullable
  @Schema(name = "Used to set the line height. You can use any of the following units:  *   px = Pixels *   cm = Centimeters *   mm = Millimeters *   in = Inches *   pt = Points *   pc = Pica")
  @JsonProperty(JSON_PROPERTY_LINE_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLineHeight() {
    return lineHeight;
  }


  @JsonProperty(JSON_PROPERTY_LINE_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLineHeight(String lineHeight) {
    this.lineHeight = lineHeight;
  }


  public OperationTextHighlight lineNumbers(Boolean lineNumbers) {
    
    this.lineNumbers = lineNumbers;
    return this;
  }

  /**
   * If this value is set to \&quot;true\&quot;, line numbers are added before the code.
   * @return lineNumbers
   **/
  @Nullable
  @Schema(name = "If this value is set to \"true\", line numbers are added before the code.")
  @JsonProperty(JSON_PROPERTY_LINE_NUMBERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getLineNumbers() {
    return lineNumbers;
  }


  @JsonProperty(JSON_PROPERTY_LINE_NUMBERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLineNumbers(Boolean lineNumbers) {
    this.lineNumbers = lineNumbers;
  }


  public OperationTextHighlight wordBreak(WordBreakEnum wordBreak) {
    
    this.wordBreak = wordBreak;
    return this;
  }

  /**
   * Can be used to configure the word wrap behaviour during highlighting Possible values:  *   auto &#x3D; Automatic word wrap if necessary. *   none &#x3D; Suppress the addition of extra line breaks. *   word &#x3D; Line breaks allowed only after words. *   all &#x3D; Line breaks allowed unconditionally.
   * @return wordBreak
   **/
  @Nullable
  @Schema(name = "Can be used to configure the word wrap behaviour during highlighting Possible values:  *   auto = Automatic word wrap if necessary. *   none = Suppress the addition of extra line breaks. *   word = Line breaks allowed only after words. *   all = Line breaks allowed unconditionally.")
  @JsonProperty(JSON_PROPERTY_WORD_BREAK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public WordBreakEnum getWordBreak() {
    return wordBreak;
  }


  @JsonProperty(JSON_PROPERTY_WORD_BREAK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWordBreak(WordBreakEnum wordBreak) {
    this.wordBreak = wordBreak;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationTextHighlight operationTextHighlight = (OperationTextHighlight) o;
    return Objects.equals(this.color, operationTextHighlight.color) &&
        Objects.equals(this.fontFamily, operationTextHighlight.fontFamily) &&
        Objects.equals(this.fontOrigin, operationTextHighlight.fontOrigin) &&
        Objects.equals(this.fontSize, operationTextHighlight.fontSize) &&
        Objects.equals(this.lineHeight, operationTextHighlight.lineHeight) &&
        Objects.equals(this.lineNumbers, operationTextHighlight.lineNumbers) &&
        Objects.equals(this.wordBreak, operationTextHighlight.wordBreak);
  }

  @Override
  public int hashCode() {
    return Objects.hash(color, fontFamily, fontOrigin, fontSize, lineHeight, lineNumbers, wordBreak);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationTextHighlight {\n");
    sb.append("    color: ").append(toIndentedString(color)).append("\n");
    sb.append("    fontFamily: ").append(toIndentedString(fontFamily)).append("\n");
    sb.append("    fontOrigin: ").append(toIndentedString(fontOrigin)).append("\n");
    sb.append("    fontSize: ").append(toIndentedString(fontSize)).append("\n");
    sb.append("    lineHeight: ").append(toIndentedString(lineHeight)).append("\n");
    sb.append("    lineNumbers: ").append(toIndentedString(lineNumbers)).append("\n");
    sb.append("    wordBreak: ").append(toIndentedString(wordBreak)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
