/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 9.0.0.3479 (2024-07-23T08:38:02Z) 
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * This element is used to configure language detection and the representation of syntax elements in recognized programming/script languages.
 */
@Schema(description = "This element is used to configure language detection and the representation of syntax elements in recognized programming/script languages.")
@JsonPropertyOrder({
  OperationSyntaxHighlight.JSON_PROPERTY_AVAILABLE,
  OperationSyntaxHighlight.JSON_PROPERTY_FONT_FAMILY,
  OperationSyntaxHighlight.JSON_PROPERTY_FONT_ORIGIN,
  OperationSyntaxHighlight.JSON_PROPERTY_FONT_SIZE,
  OperationSyntaxHighlight.JSON_PROPERTY_LANGUAGE,
  OperationSyntaxHighlight.JSON_PROPERTY_LINE_HEIGHT,
  OperationSyntaxHighlight.JSON_PROPERTY_LINE_NUMBERS,
  OperationSyntaxHighlight.JSON_PROPERTY_RELEVANCE,
  OperationSyntaxHighlight.JSON_PROPERTY_WORD_BREAK
})
@JsonTypeName("Operation_SyntaxHighlight")

public class OperationSyntaxHighlight {
  public static final String JSON_PROPERTY_AVAILABLE = "available";
  private String available = "";

  public static final String JSON_PROPERTY_FONT_FAMILY = "fontFamily";
  private String fontFamily = "";

  /**
   * Used to specify whether the selected font should be obtained from your operating system or from the \&quot;templates/fonts\&quot; folder (in your webPDF installation path). Possible values:  *   system &#x3D; It will be possible to select from the fonts available system-wide. *   folder &#x3D;It will be possible to select from the fonts in \&quot;templates/fonts\&quot;.
   */
  public enum FontOriginEnum {
    SYSTEM("system"),
    
    FOLDER("folder");

    private String value;

    FontOriginEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static FontOriginEnum fromValue(String value) {
      for (FontOriginEnum b : FontOriginEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_FONT_ORIGIN = "fontOrigin";
  private FontOriginEnum fontOrigin = FontOriginEnum.SYSTEM;

  public static final String JSON_PROPERTY_FONT_SIZE = "fontSize";
  private String fontSize = "10px";

  public static final String JSON_PROPERTY_LANGUAGE = "language";
  private String language = "";

  public static final String JSON_PROPERTY_LINE_HEIGHT = "lineHeight";
  private String lineHeight = "12px";

  public static final String JSON_PROPERTY_LINE_NUMBERS = "lineNumbers";
  private Boolean lineNumbers = true;

  public static final String JSON_PROPERTY_RELEVANCE = "relevance";
  private Integer relevance = 90;

  /**
   * Can be used to configure the word wrap behaviour during highlighting Possible values:  *   auto &#x3D; Automatic word wrap if necessary. *   none &#x3D; Suppress the addition of extra line breaks. *   word &#x3D; Line breaks allowed only after words. *   all &#x3D; Line breaks allowed unconditionally.
   */
  public enum WordBreakEnum {
    AUTO("auto"),
    
    NONE("none"),
    
    WORD("word"),
    
    ALL("all");

    private String value;

    WordBreakEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static WordBreakEnum fromValue(String value) {
      for (WordBreakEnum b : WordBreakEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_WORD_BREAK = "wordBreak";
  private WordBreakEnum wordBreak = WordBreakEnum.AUTO;

  public OperationSyntaxHighlight() {
  }

  public OperationSyntaxHighlight available(String available) {
    
    this.available = available;
    return this;
  }

  /**
   * Can be used to specify the languages to which the syntax highlighted should be limited. You can enter multiple languages by separating them with a comma (\&quot;java,cpp\&quot;). If you do not specify a value, all the languages listed below will be recognized. You can select any of the following languages:  *   abnf &#x3D; Augmented Backus-Naur form *   accesslog &#x3D; Apache/Nginx Access Logs *   actionscript &#x3D; ActionScript *   ada &#x3D; Ada *   angelscript &#x3D; AngelScript *   apache &#x3D; Apache configuration language *   applescript &#x3D; AppleScript *   arcade &#x3D; ArcGIS Arcade *   arduino &#x3D; Arduino *   armasm &#x3D; ARM Assembly *   asciidoc &#x3D; AsciiDoc *   aspectj &#x3D; AspectJ *   autohotkey &#x3D; AutoHotkey *   autoit &#x3D; AutoIt *   avrasm &#x3D; AVR Assembler *   awk &#x3D; Awk *   axapta &#x3D; Axapta *   bash &#x3D; Bash *   basic &#x3D; Basic *   bnf &#x3D; Backus-Naur Form *   brainfuck &#x3D; Brainfuck *   cal &#x3D; C/AL *   capnproto &#x3D; Cap&#39;n Proto *   ceylon &#x3D; Ceylon *   clean &#x3D; Clean *   clojure-repl &#x3D; Clojure REPL *   clojure &#x3D; Clojure *   cmake &#x3D; CMake *   coffeescript &#x3D; CoffeeScript *   coq &#x3D; Coq *   cos &#x3D; Caché Object Script *   cpp &#x3D; C++ *   crmsh &#x3D; crmsh *   crystal &#x3D; Crystal *   cs &#x3D; C# *   csp &#x3D; CSP *   css &#x3D; CSS *   d &#x3D; D *   dart &#x3D; Dart *   delphi &#x3D; Delphi *   diff &#x3D; Diff *   django &#x3D; Django *   dns &#x3D; DNS Zone file *   dockerfile &#x3D; Dockerfile *   dos &#x3D; DOS .bat *   dsconfig &#x3D; dsconfig *   dts &#x3D; Device Tree *   dust &#x3D; Dust *   ebnf &#x3D; Extended Backus-Naur Form *   elixir &#x3D; Elixir *   elm &#x3D; Elm *   erb &#x3D; Embedded Ruby *   erlang-repl &#x3D; Erlang REPL *   erlang &#x3D; Erlang *   excel &#x3D; Excel *   fix &#x3D; FIX *   flix &#x3D; FLIX *   fortran &#x3D; Fortran *   fsharp &#x3D; F# *   gams &#x3D; GAMS *   gauss &#x3D; GAUSS *   gcode &#x3D; G-code *   gherkin &#x3D; Gherkin *   glsl &#x3D; GLSL *   gml &#x3D; GML *   go &#x3D; Go *   golo &#x3D; Golo *   gradle &#x3D; Gradle *   groovy &#x3D; Groovy *   haml &#x3D; Haml *   arduino &#x3D; Arduino *   handlebars &#x3D; Handlebars *   haskell &#x3D; Haskell *   haxe &#x3D; Haxe *   hsp &#x3D; HSP *   htmlbars &#x3D; HTMLBars *   http &#x3D; HTTP *   hy &#x3D; Hy *   inform7 &#x3D; Inform 7 *   arduino &#x3D; Ini, TOML *   irpf90 &#x3D; IRPF90 *   isbl &#x3D; ISBL *   java &#x3D; Java *   javascript &#x3D; Javascript *   jboss-cli &#x3D; jboss-cli *   json &#x3D; JSON *   julia-repl &#x3D; Julia REPL *   julia &#x3D; Julia *   kotlin &#x3D; Kotlin *   lasso &#x3D; Lasso *   ldif &#x3D; LDIF *   leaf &#x3D; Leaf *   less &#x3D; Less *   lisp &#x3D; Lisp *   livecodeserver &#x3D; LiveCode *   livescript &#x3D; LiveScript *   llvm &#x3D; LLVM IR *   lsl &#x3D; Linden Scripting Language *   lua &#x3D; Lua *   makefile &#x3D; Makefile *   markdown &#x3D; Markdown *   mathematica &#x3D; Mathematica *   matlab &#x3D; Matlab *   maxima &#x3D; Maxima *   mel &#x3D; MEL *   mercury &#x3D; Mercury *   mipsasm &#x3D; MIPS Assembly *   mizar &#x3D; Mizar *   mojolicious &#x3D; Mojolicious *   monkey &#x3D; Monkey *   moonscript &#x3D; MoonScript *   n1ql &#x3D; N1QL *   nginx &#x3D; Nginx *   nimrod &#x3D; Nimrod *   nix &#x3D; Nix *   nsis &#x3D; NSIS *   objectivec &#x3D; Objective-C *   ocaml &#x3D; OCaml *   openscad &#x3D; OpenSCAD *   oxygene &#x3D; Oxygene *   parser3 &#x3D; Parser3 *   perl &#x3D; Perl *   pf &#x3D; pf *   pgsql &#x3D; PostgreSQL *   php &#x3D; PHP *   plaintext &#x3D; plaintext *   pony &#x3D; Pony *   powershell &#x3D; PowerShell *   processing &#x3D; Processing *   profile &#x3D; Python profile *   prolog &#x3D; Prolog *   properties &#x3D; Properties *   protobuf &#x3D; Protocol Buffers *   puppet &#x3D; Puppet *   purebasic &#x3D; PureBASIC *   python &#x3D; Python *   q &#x3D; Q *   qml &#x3D; QML *   r &#x3D; R *   reasonml &#x3D; ReasonML *   rib &#x3D; RenderMan RIB *   roboconf &#x3D; Roboconf *   routeros &#x3D; Microtik RouterOS Script *   rsl &#x3D; RenderMan RSL *   ruby &#x3D; Ruby *   ruleslanguage &#x3D; Oracle Rules Language *   rust &#x3D; Rust *   sas &#x3D; SAS *   scala &#x3D; Scala *   scheme &#x3D; Scheme *   scilab &#x3D; Scilab *   scss &#x3D; SCSS *   shell &#x3D; Shell Session *   smali &#x3D; Smali *   smalltalk &#x3D; Smalltalk *   sml &#x3D; SML *   sqf &#x3D; SQF *   sql &#x3D; SQL *   stan &#x3D; Stan *   stata &#x3D; Stata *   step21 &#x3D; Step Part 21 *   stylus &#x3D; Stylus *   subunit &#x3D; SubUnit *   swift &#x3D; Swift *   taggerscript &#x3D; Tagger Script *   tap &#x3D; Test Anything Protocol *   tcl &#x3D; Tcl *   tex &#x3D; TeX *   thrift &#x3D; Thrift *   tp &#x3D; TP *   twig &#x3D; Twig *   typescript &#x3D; TypeScript *   vala &#x3D; Vala *   vbnet &#x3D; VB.NET *   vbscript-html &#x3D; VBScript in HTML *   vbscript &#x3D; VBScript *   verilog &#x3D; Verilog *   vhdl &#x3D; VHDL *   vim &#x3D; Vim Script *   x86asm &#x3D; Intel x86 Assembly *   xl &#x3D; XL *   xml &#x3D; XML *   xquery &#x3D; XQuery *   yaml &#x3D; YAML *   zephir &#x3D; Zephir
   * @return available
   **/
  @Nullable
  @Schema(name = "Can be used to specify the languages to which the syntax highlighted should be limited. You can enter multiple languages by separating them with a comma (\"java,cpp\"). If you do not specify a value, all the languages listed below will be recognized. You can select any of the following languages:  *   abnf = Augmented Backus-Naur form *   accesslog = Apache/Nginx Access Logs *   actionscript = ActionScript *   ada = Ada *   angelscript = AngelScript *   apache = Apache configuration language *   applescript = AppleScript *   arcade = ArcGIS Arcade *   arduino = Arduino *   armasm = ARM Assembly *   asciidoc = AsciiDoc *   aspectj = AspectJ *   autohotkey = AutoHotkey *   autoit = AutoIt *   avrasm = AVR Assembler *   awk = Awk *   axapta = Axapta *   bash = Bash *   basic = Basic *   bnf = Backus-Naur Form *   brainfuck = Brainfuck *   cal = C/AL *   capnproto = Cap'n Proto *   ceylon = Ceylon *   clean = Clean *   clojure-repl = Clojure REPL *   clojure = Clojure *   cmake = CMake *   coffeescript = CoffeeScript *   coq = Coq *   cos = Caché Object Script *   cpp = C++ *   crmsh = crmsh *   crystal = Crystal *   cs = C# *   csp = CSP *   css = CSS *   d = D *   dart = Dart *   delphi = Delphi *   diff = Diff *   django = Django *   dns = DNS Zone file *   dockerfile = Dockerfile *   dos = DOS .bat *   dsconfig = dsconfig *   dts = Device Tree *   dust = Dust *   ebnf = Extended Backus-Naur Form *   elixir = Elixir *   elm = Elm *   erb = Embedded Ruby *   erlang-repl = Erlang REPL *   erlang = Erlang *   excel = Excel *   fix = FIX *   flix = FLIX *   fortran = Fortran *   fsharp = F# *   gams = GAMS *   gauss = GAUSS *   gcode = G-code *   gherkin = Gherkin *   glsl = GLSL *   gml = GML *   go = Go *   golo = Golo *   gradle = Gradle *   groovy = Groovy *   haml = Haml *   arduino = Arduino *   handlebars = Handlebars *   haskell = Haskell *   haxe = Haxe *   hsp = HSP *   htmlbars = HTMLBars *   http = HTTP *   hy = Hy *   inform7 = Inform 7 *   arduino = Ini, TOML *   irpf90 = IRPF90 *   isbl = ISBL *   java = Java *   javascript = Javascript *   jboss-cli = jboss-cli *   json = JSON *   julia-repl = Julia REPL *   julia = Julia *   kotlin = Kotlin *   lasso = Lasso *   ldif = LDIF *   leaf = Leaf *   less = Less *   lisp = Lisp *   livecodeserver = LiveCode *   livescript = LiveScript *   llvm = LLVM IR *   lsl = Linden Scripting Language *   lua = Lua *   makefile = Makefile *   markdown = Markdown *   mathematica = Mathematica *   matlab = Matlab *   maxima = Maxima *   mel = MEL *   mercury = Mercury *   mipsasm = MIPS Assembly *   mizar = Mizar *   mojolicious = Mojolicious *   monkey = Monkey *   moonscript = MoonScript *   n1ql = N1QL *   nginx = Nginx *   nimrod = Nimrod *   nix = Nix *   nsis = NSIS *   objectivec = Objective-C *   ocaml = OCaml *   openscad = OpenSCAD *   oxygene = Oxygene *   parser3 = Parser3 *   perl = Perl *   pf = pf *   pgsql = PostgreSQL *   php = PHP *   plaintext = plaintext *   pony = Pony *   powershell = PowerShell *   processing = Processing *   profile = Python profile *   prolog = Prolog *   properties = Properties *   protobuf = Protocol Buffers *   puppet = Puppet *   purebasic = PureBASIC *   python = Python *   q = Q *   qml = QML *   r = R *   reasonml = ReasonML *   rib = RenderMan RIB *   roboconf = Roboconf *   routeros = Microtik RouterOS Script *   rsl = RenderMan RSL *   ruby = Ruby *   ruleslanguage = Oracle Rules Language *   rust = Rust *   sas = SAS *   scala = Scala *   scheme = Scheme *   scilab = Scilab *   scss = SCSS *   shell = Shell Session *   smali = Smali *   smalltalk = Smalltalk *   sml = SML *   sqf = SQF *   sql = SQL *   stan = Stan *   stata = Stata *   step21 = Step Part 21 *   stylus = Stylus *   subunit = SubUnit *   swift = Swift *   taggerscript = Tagger Script *   tap = Test Anything Protocol *   tcl = Tcl *   tex = TeX *   thrift = Thrift *   tp = TP *   twig = Twig *   typescript = TypeScript *   vala = Vala *   vbnet = VB.NET *   vbscript-html = VBScript in HTML *   vbscript = VBScript *   verilog = Verilog *   vhdl = VHDL *   vim = Vim Script *   x86asm = Intel x86 Assembly *   xl = XL *   xml = XML *   xquery = XQuery *   yaml = YAML *   zephir = Zephir")
  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAvailable() {
    return available;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailable(String available) {
    this.available = available;
  }


  public OperationSyntaxHighlight fontFamily(String fontFamily) {
    
    this.fontFamily = fontFamily;
    return this;
  }

  /**
   * Used to specify the font that should be used for syntax highlighting. If you select \&quot;folder\&quot; for the \&quot;fontOrigin\&quot; parameter, the font here needs to be specified with the filename for the file. Otherwise, use the name of the font you want. If the value is left blank, the \&quot;Fira Code\&quot; font will be used automatically.
   * @return fontFamily
   **/
  @Nullable
  @Schema(name = "Used to specify the font that should be used for syntax highlighting. If you select \"folder\" for the \"fontOrigin\" parameter, the font here needs to be specified with the filename for the file. Otherwise, use the name of the font you want. If the value is left blank, the \"Fira Code\" font will be used automatically.")
  @JsonProperty(JSON_PROPERTY_FONT_FAMILY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFontFamily() {
    return fontFamily;
  }


  @JsonProperty(JSON_PROPERTY_FONT_FAMILY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFontFamily(String fontFamily) {
    this.fontFamily = fontFamily;
  }


  public OperationSyntaxHighlight fontOrigin(FontOriginEnum fontOrigin) {
    
    this.fontOrigin = fontOrigin;
    return this;
  }

  /**
   * Used to specify whether the selected font should be obtained from your operating system or from the \&quot;templates/fonts\&quot; folder (in your webPDF installation path). Possible values:  *   system &#x3D; It will be possible to select from the fonts available system-wide. *   folder &#x3D;It will be possible to select from the fonts in \&quot;templates/fonts\&quot;.
   * @return fontOrigin
   **/
  @Nullable
  @Schema(name = "Used to specify whether the selected font should be obtained from your operating system or from the \"templates/fonts\" folder (in your webPDF installation path). Possible values:  *   system = It will be possible to select from the fonts available system-wide. *   folder =It will be possible to select from the fonts in \"templates/fonts\".")
  @JsonProperty(JSON_PROPERTY_FONT_ORIGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public FontOriginEnum getFontOrigin() {
    return fontOrigin;
  }


  @JsonProperty(JSON_PROPERTY_FONT_ORIGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFontOrigin(FontOriginEnum fontOrigin) {
    this.fontOrigin = fontOrigin;
  }


  public OperationSyntaxHighlight fontSize(String fontSize) {
    
    this.fontSize = fontSize;
    return this;
  }

  /**
   * Used to set the font size for syntax highlighting to the specified value. You can use any of the following units:  *   px &#x3D; Pixels *   cm &#x3D; Centimeters *   mm &#x3D; Millimeters *   in &#x3D; Inches *   pt &#x3D; Points *   pc &#x3D; Pica
   * @return fontSize
   **/
  @Nullable
  @Schema(name = "Used to set the font size for syntax highlighting to the specified value. You can use any of the following units:  *   px = Pixels *   cm = Centimeters *   mm = Millimeters *   in = Inches *   pt = Points *   pc = Pica")
  @JsonProperty(JSON_PROPERTY_FONT_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFontSize() {
    return fontSize;
  }


  @JsonProperty(JSON_PROPERTY_FONT_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFontSize(String fontSize) {
    this.fontSize = fontSize;
  }


  public OperationSyntaxHighlight language(String language) {
    
    this.language = language;
    return this;
  }

  /**
   * Used to select a specific language for highlighting recognition. You can select one of the languages listed for the \&quot;available\&quot; parameter. If you do not set this value, the system will attempt to automatically select an appropriate language from the list of available languages.
   * @return language
   **/
  @Nullable
  @Schema(name = "Used to select a specific language for highlighting recognition. You can select one of the languages listed for the \"available\" parameter. If you do not set this value, the system will attempt to automatically select an appropriate language from the list of available languages.")
  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLanguage() {
    return language;
  }


  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLanguage(String language) {
    this.language = language;
  }


  public OperationSyntaxHighlight lineHeight(String lineHeight) {
    
    this.lineHeight = lineHeight;
    return this;
  }

  /**
   * Used to set the line height. You can use any of the following units:  *   px &#x3D; Pixels *   cm &#x3D; Centimeters *   mm &#x3D; Millimeters *   in &#x3D; Inches *   pt &#x3D; Points *   pc &#x3D; Pica
   * @return lineHeight
   **/
  @Nullable
  @Schema(name = "Used to set the line height. You can use any of the following units:  *   px = Pixels *   cm = Centimeters *   mm = Millimeters *   in = Inches *   pt = Points *   pc = Pica")
  @JsonProperty(JSON_PROPERTY_LINE_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLineHeight() {
    return lineHeight;
  }


  @JsonProperty(JSON_PROPERTY_LINE_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLineHeight(String lineHeight) {
    this.lineHeight = lineHeight;
  }


  public OperationSyntaxHighlight lineNumbers(Boolean lineNumbers) {
    
    this.lineNumbers = lineNumbers;
    return this;
  }

  /**
   * If this value is set to \&quot;true\&quot;, line numbers are added before the code.
   * @return lineNumbers
   **/
  @Nullable
  @Schema(name = "If this value is set to \"true\", line numbers are added before the code.")
  @JsonProperty(JSON_PROPERTY_LINE_NUMBERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getLineNumbers() {
    return lineNumbers;
  }


  @JsonProperty(JSON_PROPERTY_LINE_NUMBERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLineNumbers(Boolean lineNumbers) {
    this.lineNumbers = lineNumbers;
  }


  public OperationSyntaxHighlight relevance(Integer relevance) {
    
    this.relevance = relevance;
    return this;
  }

  /**
   * The syntax highlighter evaluates the degree of reliability with which it recognizes a language with a value ranging from 0 to 1000 points. This value determines the reliability level starting from which it should highlight syntax for a recognized language. The higher the value, the more closely the content found must match the criteria.
   * @return relevance
   **/
  @Nullable
  @Schema(name = "The syntax highlighter evaluates the degree of reliability with which it recognizes a language with a value ranging from 0 to 1000 points. This value determines the reliability level starting from which it should highlight syntax for a recognized language. The higher the value, the more closely the content found must match the criteria.")
  @JsonProperty(JSON_PROPERTY_RELEVANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRelevance() {
    return relevance;
  }


  @JsonProperty(JSON_PROPERTY_RELEVANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRelevance(Integer relevance) {
    this.relevance = relevance;
  }


  public OperationSyntaxHighlight wordBreak(WordBreakEnum wordBreak) {
    
    this.wordBreak = wordBreak;
    return this;
  }

  /**
   * Can be used to configure the word wrap behaviour during highlighting Possible values:  *   auto &#x3D; Automatic word wrap if necessary. *   none &#x3D; Suppress the addition of extra line breaks. *   word &#x3D; Line breaks allowed only after words. *   all &#x3D; Line breaks allowed unconditionally.
   * @return wordBreak
   **/
  @Nullable
  @Schema(name = "Can be used to configure the word wrap behaviour during highlighting Possible values:  *   auto = Automatic word wrap if necessary. *   none = Suppress the addition of extra line breaks. *   word = Line breaks allowed only after words. *   all = Line breaks allowed unconditionally.")
  @JsonProperty(JSON_PROPERTY_WORD_BREAK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public WordBreakEnum getWordBreak() {
    return wordBreak;
  }


  @JsonProperty(JSON_PROPERTY_WORD_BREAK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWordBreak(WordBreakEnum wordBreak) {
    this.wordBreak = wordBreak;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationSyntaxHighlight operationSyntaxHighlight = (OperationSyntaxHighlight) o;
    return Objects.equals(this.available, operationSyntaxHighlight.available) &&
        Objects.equals(this.fontFamily, operationSyntaxHighlight.fontFamily) &&
        Objects.equals(this.fontOrigin, operationSyntaxHighlight.fontOrigin) &&
        Objects.equals(this.fontSize, operationSyntaxHighlight.fontSize) &&
        Objects.equals(this.language, operationSyntaxHighlight.language) &&
        Objects.equals(this.lineHeight, operationSyntaxHighlight.lineHeight) &&
        Objects.equals(this.lineNumbers, operationSyntaxHighlight.lineNumbers) &&
        Objects.equals(this.relevance, operationSyntaxHighlight.relevance) &&
        Objects.equals(this.wordBreak, operationSyntaxHighlight.wordBreak);
  }

  @Override
  public int hashCode() {
    return Objects.hash(available, fontFamily, fontOrigin, fontSize, language, lineHeight, lineNumbers, relevance, wordBreak);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationSyntaxHighlight {\n");
    sb.append("    available: ").append(toIndentedString(available)).append("\n");
    sb.append("    fontFamily: ").append(toIndentedString(fontFamily)).append("\n");
    sb.append("    fontOrigin: ").append(toIndentedString(fontOrigin)).append("\n");
    sb.append("    fontSize: ").append(toIndentedString(fontSize)).append("\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    lineHeight: ").append(toIndentedString(lineHeight)).append("\n");
    sb.append("    lineNumbers: ").append(toIndentedString(lineNumbers)).append("\n");
    sb.append("    relevance: ").append(toIndentedString(relevance)).append("\n");
    sb.append("    wordBreak: ").append(toIndentedString(wordBreak)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
