/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 9.0.0.3479 (2024-07-23T08:38:02Z) 
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * When activated, the playSound Element plays the specified audio data.
 */
@Schema(description = "When activated, the playSound Element plays the specified audio data.")
@JsonPropertyOrder({
  OperationSoundActionPlaySound.JSON_PROPERTY_ENCODING,
  OperationSoundActionPlaySound.JSON_PROPERTY_MIX,
  OperationSoundActionPlaySound.JSON_PROPERTY_REPEAT,
  OperationSoundActionPlaySound.JSON_PROPERTY_SAMPLE_SIZE,
  OperationSoundActionPlaySound.JSON_PROPERTY_SAMPLING_RATE,
  OperationSoundActionPlaySound.JSON_PROPERTY_SOUND,
  OperationSoundActionPlaySound.JSON_PROPERTY_SOUND_CHANNELS,
  OperationSoundActionPlaySound.JSON_PROPERTY_SYNCHRONOUS,
  OperationSoundActionPlaySound.JSON_PROPERTY_VOLUME
})
@JsonTypeName("Operation_SoundAction_playSound")

public class OperationSoundActionPlaySound {
  /**
   * The encoding of the audio file. Possible values are:  *   Raw *   Signed *   muLaw *   ALaw
   */
  public enum EncodingEnum {
    RAW("Raw"),
    
    SIGNED("Signed"),
    
    MULAW("muLaw"),
    
    ALAW("ALaw");

    private String value;

    EncodingEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static EncodingEnum fromValue(String value) {
      for (EncodingEnum b : EncodingEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ENCODING = "encoding";
  private EncodingEnum encoding = EncodingEnum.RAW;

  public static final String JSON_PROPERTY_MIX = "mix";
  private Boolean mix = false;

  public static final String JSON_PROPERTY_REPEAT = "repeat";
  private Boolean repeat = false;

  public static final String JSON_PROPERTY_SAMPLE_SIZE = "sampleSize";
  private Integer sampleSize = 8;

  public static final String JSON_PROPERTY_SAMPLING_RATE = "samplingRate";
  private Float samplingRate = 8000f;

  public static final String JSON_PROPERTY_SOUND = "sound";
  private byte[] sound;

  public static final String JSON_PROPERTY_SOUND_CHANNELS = "soundChannels";
  private Integer soundChannels = 1;

  public static final String JSON_PROPERTY_SYNCHRONOUS = "synchronous";
  private Boolean synchronous = false;

  public static final String JSON_PROPERTY_VOLUME = "volume";
  private Integer volume = 100;

  public OperationSoundActionPlaySound() {
  }

  public OperationSoundActionPlaySound encoding(EncodingEnum encoding) {
    
    this.encoding = encoding;
    return this;
  }

  /**
   * The encoding of the audio file. Possible values are:  *   Raw *   Signed *   muLaw *   ALaw
   * @return encoding
   **/
  @Nullable
  @Schema(name = "The encoding of the audio file. Possible values are:  *   Raw *   Signed *   muLaw *   ALaw")
  @JsonProperty(JSON_PROPERTY_ENCODING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public EncodingEnum getEncoding() {
    return encoding;
  }


  @JsonProperty(JSON_PROPERTY_ENCODING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEncoding(EncodingEnum encoding) {
    this.encoding = encoding;
  }


  public OperationSoundActionPlaySound mix(Boolean mix) {
    
    this.mix = mix;
    return this;
  }

  /**
   * If this value is set to true, it will be possible to play the audio track at the same time as other audio tracks. If it is set to false instead, any audio tracks that were already playing will be stopped previously.
   * @return mix
   **/
  @Nullable
  @Schema(name = "If this value is set to true, it will be possible to play the audio track at the same time as other audio tracks. If it is set to false instead, any audio tracks that were already playing will be stopped previously.")
  @JsonProperty(JSON_PROPERTY_MIX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getMix() {
    return mix;
  }


  @JsonProperty(JSON_PROPERTY_MIX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMix(Boolean mix) {
    this.mix = mix;
  }


  public OperationSoundActionPlaySound repeat(Boolean repeat) {
    
    this.repeat = repeat;
    return this;
  }

  /**
   * If this value is set to true, the audio track should be repeated endlessly.
   * @return repeat
   **/
  @Nullable
  @Schema(name = "If this value is set to true, the audio track should be repeated endlessly.")
  @JsonProperty(JSON_PROPERTY_REPEAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getRepeat() {
    return repeat;
  }


  @JsonProperty(JSON_PROPERTY_REPEAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRepeat(Boolean repeat) {
    this.repeat = repeat;
  }


  public OperationSoundActionPlaySound sampleSize(Integer sampleSize) {
    
    this.sampleSize = sampleSize;
    return this;
  }

  /**
   * The number of bits per sample per audio channel.
   * minimum: 1
   * @return sampleSize
   **/
  @Nullable
  @Schema(name = "The number of bits per sample per audio channel.")
  @JsonProperty(JSON_PROPERTY_SAMPLE_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSampleSize() {
    return sampleSize;
  }


  @JsonProperty(JSON_PROPERTY_SAMPLE_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSampleSize(Integer sampleSize) {
    this.sampleSize = sampleSize;
  }


  public OperationSoundActionPlaySound samplingRate(Float samplingRate) {
    
    this.samplingRate = samplingRate;
    return this;
  }

  /**
   * The Sample Rate in Samples per Second.
   * minimum: 1
   * @return samplingRate
   **/
  @Nullable
  @Schema(name = "The Sample Rate in Samples per Second.")
  @JsonProperty(JSON_PROPERTY_SAMPLING_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getSamplingRate() {
    return samplingRate;
  }


  @JsonProperty(JSON_PROPERTY_SAMPLING_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSamplingRate(Float samplingRate) {
    this.samplingRate = samplingRate;
  }


  public OperationSoundActionPlaySound sound(byte[] sound) {
    
    this.sound = sound;
    return this;
  }

  /**
   * The audio file that should be played. The file must be encoded as a BASE64 value. The passed file must be completely independent and contain all the information and data required to play it. The AIFF, AIFF-C, RIFF (\\*.wav), snd(\\*.au) audio formats are supported, for example.
   * @return sound
   **/
  @NotNull
  @Schema(required = true, name = "The audio file that should be played. The file must be encoded as a BASE64 value. The passed file must be completely independent and contain all the information and data required to play it. The AIFF, AIFF-C, RIFF (\\*.wav), snd(\\*.au) audio formats are supported, for example.")
  @JsonProperty(JSON_PROPERTY_SOUND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public byte[] getSound() {
    return sound;
  }


  @JsonProperty(JSON_PROPERTY_SOUND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSound(byte[] sound) {
    this.sound = sound;
  }


  public OperationSoundActionPlaySound soundChannels(Integer soundChannels) {
    
    this.soundChannels = soundChannels;
    return this;
  }

  /**
   * The number of audio channels.
   * minimum: 1
   * @return soundChannels
   **/
  @Nullable
  @Schema(name = "The number of audio channels.")
  @JsonProperty(JSON_PROPERTY_SOUND_CHANNELS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSoundChannels() {
    return soundChannels;
  }


  @JsonProperty(JSON_PROPERTY_SOUND_CHANNELS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSoundChannels(Integer soundChannels) {
    this.soundChannels = soundChannels;
  }


  public OperationSoundActionPlaySound synchronous(Boolean synchronous) {
    
    this.synchronous = synchronous;
    return this;
  }

  /**
   * If this value is set to true, the reader program must guarantee that the audio track will be plated in a completely synchronized manner without any interruptions and, accordingly, suppress any user interaction (except for cancelling the audio) while the audio is playing.
   * @return synchronous
   **/
  @Nullable
  @Schema(name = "If this value is set to true, the reader program must guarantee that the audio track will be plated in a completely synchronized manner without any interruptions and, accordingly, suppress any user interaction (except for cancelling the audio) while the audio is playing.")
  @JsonProperty(JSON_PROPERTY_SYNCHRONOUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSynchronous() {
    return synchronous;
  }


  @JsonProperty(JSON_PROPERTY_SYNCHRONOUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSynchronous(Boolean synchronous) {
    this.synchronous = synchronous;
  }


  public OperationSoundActionPlaySound volume(Integer volume) {
    
    this.volume = volume;
    return this;
  }

  /**
   * A floating-point number between 100 and -100 that configures the volume for audio playback (as a percentage).
   * minimum: -100
   * maximum: 100
   * @return volume
   **/
  @Nullable
  @Schema(name = "A floating-point number between 100 and -100 that configures the volume for audio playback (as a percentage).")
  @JsonProperty(JSON_PROPERTY_VOLUME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getVolume() {
    return volume;
  }


  @JsonProperty(JSON_PROPERTY_VOLUME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVolume(Integer volume) {
    this.volume = volume;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationSoundActionPlaySound operationSoundActionPlaySound = (OperationSoundActionPlaySound) o;
    return Objects.equals(this.encoding, operationSoundActionPlaySound.encoding) &&
        Objects.equals(this.mix, operationSoundActionPlaySound.mix) &&
        Objects.equals(this.repeat, operationSoundActionPlaySound.repeat) &&
        Objects.equals(this.sampleSize, operationSoundActionPlaySound.sampleSize) &&
        Objects.equals(this.samplingRate, operationSoundActionPlaySound.samplingRate) &&
        Arrays.equals(this.sound, operationSoundActionPlaySound.sound) &&
        Objects.equals(this.soundChannels, operationSoundActionPlaySound.soundChannels) &&
        Objects.equals(this.synchronous, operationSoundActionPlaySound.synchronous) &&
        Objects.equals(this.volume, operationSoundActionPlaySound.volume);
  }

  @Override
  public int hashCode() {
    return Objects.hash(encoding, mix, repeat, sampleSize, samplingRate, Arrays.hashCode(sound), soundChannels, synchronous, volume);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationSoundActionPlaySound {\n");
    sb.append("    encoding: ").append(toIndentedString(encoding)).append("\n");
    sb.append("    mix: ").append(toIndentedString(mix)).append("\n");
    sb.append("    repeat: ").append(toIndentedString(repeat)).append("\n");
    sb.append("    sampleSize: ").append(toIndentedString(sampleSize)).append("\n");
    sb.append("    samplingRate: ").append(toIndentedString(samplingRate)).append("\n");
    sb.append("    sound: ").append(toIndentedString(sound)).append("\n");
    sb.append("    soundChannels: ").append(toIndentedString(soundChannels)).append("\n");
    sb.append("    synchronous: ").append(toIndentedString(synchronous)).append("\n");
    sb.append("    volume: ").append(toIndentedString(volume)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
