/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 9.0.0.3479 (2024-07-23T08:38:02Z) 
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Used to define the annotation element that should be linked to the file attachment.  **Important:** If an \&quot;annotation element\&quot; is not defined for the \&quot;file element,\&quot; the attachment will be stored at the document level.
 */
@Schema(description = "Used to define the annotation element that should be linked to the file attachment.  **Important:** If an \"annotation element\" is not defined for the \"file element,\" the attachment will be stored at the document level.")
@JsonPropertyOrder({
  OperationFileAnnotation.JSON_PROPERTY_COLOR,
  OperationFileAnnotation.JSON_PROPERTY_HEIGHT,
  OperationFileAnnotation.JSON_PROPERTY_ICON,
  OperationFileAnnotation.JSON_PROPERTY_LOCKED_POSITION,
  OperationFileAnnotation.JSON_PROPERTY_OPACITY,
  OperationFileAnnotation.JSON_PROPERTY_PAGE,
  OperationFileAnnotation.JSON_PROPERTY_POINT,
  OperationFileAnnotation.JSON_PROPERTY_POPUP_TEXT,
  OperationFileAnnotation.JSON_PROPERTY_WIDTH
})
@JsonTypeName("Operation_FileAnnotation")

public class OperationFileAnnotation {
  public static final String JSON_PROPERTY_COLOR = "color";
  private String color = "#4800FF";

  public static final String JSON_PROPERTY_HEIGHT = "height";
  private Float height = 0f;

  /**
   * If an attachment is embedded at the page level, this option can be used to specify the icon that should be used to show it:  The value you use here will define which icon will be used, as well as the basic dimensions for the annotation generated in the PDF. If you use the \&quot;None\&quot; icon type, a predefined icon will not be used. Instead, this option will only use the dimensions specified in \&quot;width\&quot; and \&quot;height\&quot; to generate an annotation with a transparent selection box at the specified position.  *   graph &#x3D; Diagram *   paperclip &#x3D; Paper clip *   pushPin &#x3D; Thumb tack *   tag &#x3D; Tag *   none &#x3D; Rectangular selection box
   */
  public enum IconEnum {
    GRAPH("graph"),
    
    PAPERCLIP("paperclip"),
    
    PUSHPIN("pushPin"),
    
    TAG("tag"),
    
    NONE("none");

    private String value;

    IconEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static IconEnum fromValue(String value) {
      for (IconEnum b : IconEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ICON = "icon";
  private IconEnum icon = IconEnum.PAPERCLIP;

  public static final String JSON_PROPERTY_LOCKED_POSITION = "lockedPosition";
  private Boolean lockedPosition = true;

  public static final String JSON_PROPERTY_OPACITY = "opacity";
  private Integer opacity = 100;

  public static final String JSON_PROPERTY_PAGE = "page";
  private Integer page = 1;

  public static final String JSON_PROPERTY_POINT = "point";
  private OperationPoint point;

  public static final String JSON_PROPERTY_POPUP_TEXT = "popupText";
  private String popupText = "";

  public static final String JSON_PROPERTY_WIDTH = "width";
  private Float width = 0f;

  public OperationFileAnnotation() {
  }

  public OperationFileAnnotation color(String color) {
    
    this.color = color;
    return this;
  }

  /**
   * The annotation colour will change the main colour of the attachment&#39;s icon. The colour needs to be specified as a hexadecimal RGB value with a number sign before it.
   * @return color
   **/
  @Nullable
  @Schema(name = "The annotation colour will change the main colour of the attachment's icon. The colour needs to be specified as a hexadecimal RGB value with a number sign before it.")
  @JsonProperty(JSON_PROPERTY_COLOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getColor() {
    return color;
  }


  @JsonProperty(JSON_PROPERTY_COLOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setColor(String color) {
    this.color = color;
  }


  public OperationFileAnnotation height(Float height) {
    
    this.height = height;
    return this;
  }

  /**
   * If this value is positive, the annotation will be generated with a fixed height corresponding to the value instead of using the dimensions of the specified icon.
   * minimum: 0
   * @return height
   **/
  @Nullable
  @Schema(name = "If this value is positive, the annotation will be generated with a fixed height corresponding to the value instead of using the dimensions of the specified icon.")
  @JsonProperty(JSON_PROPERTY_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getHeight() {
    return height;
  }


  @JsonProperty(JSON_PROPERTY_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHeight(Float height) {
    this.height = height;
  }


  public OperationFileAnnotation icon(IconEnum icon) {
    
    this.icon = icon;
    return this;
  }

  /**
   * If an attachment is embedded at the page level, this option can be used to specify the icon that should be used to show it:  The value you use here will define which icon will be used, as well as the basic dimensions for the annotation generated in the PDF. If you use the \&quot;None\&quot; icon type, a predefined icon will not be used. Instead, this option will only use the dimensions specified in \&quot;width\&quot; and \&quot;height\&quot; to generate an annotation with a transparent selection box at the specified position.  *   graph &#x3D; Diagram *   paperclip &#x3D; Paper clip *   pushPin &#x3D; Thumb tack *   tag &#x3D; Tag *   none &#x3D; Rectangular selection box
   * @return icon
   **/
  @Nullable
  @Schema(name = "If an attachment is embedded at the page level, this option can be used to specify the icon that should be used to show it:  The value you use here will define which icon will be used, as well as the basic dimensions for the annotation generated in the PDF. If you use the \"None\" icon type, a predefined icon will not be used. Instead, this option will only use the dimensions specified in \"width\" and \"height\" to generate an annotation with a transparent selection box at the specified position.  *   graph = Diagram *   paperclip = Paper clip *   pushPin = Thumb tack *   tag = Tag *   none = Rectangular selection box")
  @JsonProperty(JSON_PROPERTY_ICON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public IconEnum getIcon() {
    return icon;
  }


  @JsonProperty(JSON_PROPERTY_ICON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIcon(IconEnum icon) {
    this.icon = icon;
  }


  public OperationFileAnnotation lockedPosition(Boolean lockedPosition) {
    
    this.lockedPosition = lockedPosition;
    return this;
  }

  /**
   * If this value is set to \&quot;true\&quot;, the person viewing the document will not be allowed to move the icon for the file attached at the page level.
   * @return lockedPosition
   **/
  @Nullable
  @Schema(name = "If this value is set to \"true\", the person viewing the document will not be allowed to move the icon for the file attached at the page level.")
  @JsonProperty(JSON_PROPERTY_LOCKED_POSITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getLockedPosition() {
    return lockedPosition;
  }


  @JsonProperty(JSON_PROPERTY_LOCKED_POSITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLockedPosition(Boolean lockedPosition) {
    this.lockedPosition = lockedPosition;
  }


  public OperationFileAnnotation opacity(Integer opacity) {
    
    this.opacity = opacity;
    return this;
  }

  /**
   * Used to set the opacity for the attachment&#39;s icon. A percent value between 0 and 100 is allowed, whereby 0 equals the minimum opacity. The higher the value, the more the content of the PDF document will be covered over.
   * minimum: 0
   * maximum: 100
   * @return opacity
   **/
  @Nullable
  @Schema(name = "Used to set the opacity for the attachment's icon. A percent value between 0 and 100 is allowed, whereby 0 equals the minimum opacity. The higher the value, the more the content of the PDF document will be covered over.")
  @JsonProperty(JSON_PROPERTY_OPACITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getOpacity() {
    return opacity;
  }


  @JsonProperty(JSON_PROPERTY_OPACITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOpacity(Integer opacity) {
    this.opacity = opacity;
  }


  public OperationFileAnnotation page(Integer page) {
    
    this.page = page;
    return this;
  }

  /**
   * Used to define the page on which the annotation will be generated, i.e., the page where the attachment will be stored.
   * minimum: 1
   * @return page
   **/
  @Nullable
  @Schema(name = "Used to define the page on which the annotation will be generated, i.e., the page where the attachment will be stored.")
  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPage() {
    return page;
  }


  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPage(Integer page) {
    this.page = page;
  }


  public OperationFileAnnotation point(OperationPoint point) {
    
    this.point = point;
    return this;
  }

  /**
   * Get point
   * @return point
   **/
  @NotNull
  @Schema(required = true, name = "")
  @JsonProperty(JSON_PROPERTY_POINT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OperationPoint getPoint() {
    return point;
  }


  @JsonProperty(JSON_PROPERTY_POINT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPoint(OperationPoint point) {
    this.point = point;
  }


  public OperationFileAnnotation popupText(String popupText) {
    
    this.popupText = popupText;
    return this;
  }

  /**
   * The text that should be displayed in the pop-up for the annotation.
   * @return popupText
   **/
  @Nullable
  @Schema(name = "The text that should be displayed in the pop-up for the annotation.")
  @JsonProperty(JSON_PROPERTY_POPUP_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPopupText() {
    return popupText;
  }


  @JsonProperty(JSON_PROPERTY_POPUP_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPopupText(String popupText) {
    this.popupText = popupText;
  }


  public OperationFileAnnotation width(Float width) {
    
    this.width = width;
    return this;
  }

  /**
   * If this value is positive, the annotation will be generated with a fixed width corresponding to the value instead of using the dimensions of the specified icon.
   * minimum: 0
   * @return width
   **/
  @Nullable
  @Schema(name = "If this value is positive, the annotation will be generated with a fixed width corresponding to the value instead of using the dimensions of the specified icon.")
  @JsonProperty(JSON_PROPERTY_WIDTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getWidth() {
    return width;
  }


  @JsonProperty(JSON_PROPERTY_WIDTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWidth(Float width) {
    this.width = width;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationFileAnnotation operationFileAnnotation = (OperationFileAnnotation) o;
    return Objects.equals(this.color, operationFileAnnotation.color) &&
        Objects.equals(this.height, operationFileAnnotation.height) &&
        Objects.equals(this.icon, operationFileAnnotation.icon) &&
        Objects.equals(this.lockedPosition, operationFileAnnotation.lockedPosition) &&
        Objects.equals(this.opacity, operationFileAnnotation.opacity) &&
        Objects.equals(this.page, operationFileAnnotation.page) &&
        Objects.equals(this.point, operationFileAnnotation.point) &&
        Objects.equals(this.popupText, operationFileAnnotation.popupText) &&
        Objects.equals(this.width, operationFileAnnotation.width);
  }

  @Override
  public int hashCode() {
    return Objects.hash(color, height, icon, lockedPosition, opacity, page, point, popupText, width);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationFileAnnotation {\n");
    sb.append("    color: ").append(toIndentedString(color)).append("\n");
    sb.append("    height: ").append(toIndentedString(height)).append("\n");
    sb.append("    icon: ").append(toIndentedString(icon)).append("\n");
    sb.append("    lockedPosition: ").append(toIndentedString(lockedPosition)).append("\n");
    sb.append("    opacity: ").append(toIndentedString(opacity)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    point: ").append(toIndentedString(point)).append("\n");
    sb.append("    popupText: ").append(toIndentedString(popupText)).append("\n");
    sb.append("    width: ").append(toIndentedString(width)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
