/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 9.0.0.3479 (2024-07-23T08:38:02Z) 
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * A common base type for destination events, that shall target some location or content of the document.
 */
@Schema(description = "A common base type for destination events, that shall target some location or content of the document.")
@JsonPropertyOrder({
  OperationDestinationEvent.JSON_PROPERTY_ZOOM_PAGE,
  OperationDestinationEvent.JSON_PROPERTY_FIT_PAGE,
  OperationDestinationEvent.JSON_PROPERTY_FIT_WIDTH,
  OperationDestinationEvent.JSON_PROPERTY_FIT_HEIGHT,
  OperationDestinationEvent.JSON_PROPERTY_FIT_RECTANGLE,
  OperationDestinationEvent.JSON_PROPERTY_FIT_BOUNDING_BOX,
  OperationDestinationEvent.JSON_PROPERTY_FIT_BOUNDING_BOX_WIDTH,
  OperationDestinationEvent.JSON_PROPERTY_GO_TO_NAMED
})
@JsonTypeName("Operation_DestinationEvent")

public class OperationDestinationEvent {
  public static final String JSON_PROPERTY_ZOOM_PAGE = "zoomPage";
  private OperationZoomDestinationZoomPage zoomPage;

  public static final String JSON_PROPERTY_FIT_PAGE = "fitPage";
  private OperationFitPageDestinationFitPage fitPage;

  public static final String JSON_PROPERTY_FIT_WIDTH = "fitWidth";
  private OperationFitWidthDestinationFitWidth fitWidth;

  public static final String JSON_PROPERTY_FIT_HEIGHT = "fitHeight";
  private OperationFitHeightDestinationFitHeight fitHeight;

  public static final String JSON_PROPERTY_FIT_RECTANGLE = "fitRectangle";
  private OperationFitRectangleDestinationFitRectangle fitRectangle;

  public static final String JSON_PROPERTY_FIT_BOUNDING_BOX = "fitBoundingBox";
  private OperationFitBoundingBoxDestinationFitBoundingBox fitBoundingBox;

  public static final String JSON_PROPERTY_FIT_BOUNDING_BOX_WIDTH = "fitBoundingBoxWidth";
  private OperationFitBoundingBoxWidthDestinationFitBoundingBoxWidth fitBoundingBoxWidth;

  public static final String JSON_PROPERTY_GO_TO_NAMED = "goToNamed";
  private OperationNamedDestinationGoToNamed goToNamed;

  public OperationDestinationEvent() {
  }

  public OperationDestinationEvent zoomPage(OperationZoomDestinationZoomPage zoomPage) {
    
    this.zoomPage = zoomPage;
    return this;
  }

  /**
   * Get zoomPage
   * @return zoomPage
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_ZOOM_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationZoomDestinationZoomPage getZoomPage() {
    return zoomPage;
  }


  @JsonProperty(JSON_PROPERTY_ZOOM_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setZoomPage(OperationZoomDestinationZoomPage zoomPage) {
    this.zoomPage = zoomPage;
  }


  public OperationDestinationEvent fitPage(OperationFitPageDestinationFitPage fitPage) {
    
    this.fitPage = fitPage;
    return this;
  }

  /**
   * Get fitPage
   * @return fitPage
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_FIT_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationFitPageDestinationFitPage getFitPage() {
    return fitPage;
  }


  @JsonProperty(JSON_PROPERTY_FIT_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFitPage(OperationFitPageDestinationFitPage fitPage) {
    this.fitPage = fitPage;
  }


  public OperationDestinationEvent fitWidth(OperationFitWidthDestinationFitWidth fitWidth) {
    
    this.fitWidth = fitWidth;
    return this;
  }

  /**
   * Get fitWidth
   * @return fitWidth
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_FIT_WIDTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationFitWidthDestinationFitWidth getFitWidth() {
    return fitWidth;
  }


  @JsonProperty(JSON_PROPERTY_FIT_WIDTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFitWidth(OperationFitWidthDestinationFitWidth fitWidth) {
    this.fitWidth = fitWidth;
  }


  public OperationDestinationEvent fitHeight(OperationFitHeightDestinationFitHeight fitHeight) {
    
    this.fitHeight = fitHeight;
    return this;
  }

  /**
   * Get fitHeight
   * @return fitHeight
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_FIT_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationFitHeightDestinationFitHeight getFitHeight() {
    return fitHeight;
  }


  @JsonProperty(JSON_PROPERTY_FIT_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFitHeight(OperationFitHeightDestinationFitHeight fitHeight) {
    this.fitHeight = fitHeight;
  }


  public OperationDestinationEvent fitRectangle(OperationFitRectangleDestinationFitRectangle fitRectangle) {
    
    this.fitRectangle = fitRectangle;
    return this;
  }

  /**
   * Get fitRectangle
   * @return fitRectangle
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_FIT_RECTANGLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationFitRectangleDestinationFitRectangle getFitRectangle() {
    return fitRectangle;
  }


  @JsonProperty(JSON_PROPERTY_FIT_RECTANGLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFitRectangle(OperationFitRectangleDestinationFitRectangle fitRectangle) {
    this.fitRectangle = fitRectangle;
  }


  public OperationDestinationEvent fitBoundingBox(OperationFitBoundingBoxDestinationFitBoundingBox fitBoundingBox) {
    
    this.fitBoundingBox = fitBoundingBox;
    return this;
  }

  /**
   * Get fitBoundingBox
   * @return fitBoundingBox
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_FIT_BOUNDING_BOX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationFitBoundingBoxDestinationFitBoundingBox getFitBoundingBox() {
    return fitBoundingBox;
  }


  @JsonProperty(JSON_PROPERTY_FIT_BOUNDING_BOX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFitBoundingBox(OperationFitBoundingBoxDestinationFitBoundingBox fitBoundingBox) {
    this.fitBoundingBox = fitBoundingBox;
  }


  public OperationDestinationEvent fitBoundingBoxWidth(OperationFitBoundingBoxWidthDestinationFitBoundingBoxWidth fitBoundingBoxWidth) {
    
    this.fitBoundingBoxWidth = fitBoundingBoxWidth;
    return this;
  }

  /**
   * Get fitBoundingBoxWidth
   * @return fitBoundingBoxWidth
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_FIT_BOUNDING_BOX_WIDTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationFitBoundingBoxWidthDestinationFitBoundingBoxWidth getFitBoundingBoxWidth() {
    return fitBoundingBoxWidth;
  }


  @JsonProperty(JSON_PROPERTY_FIT_BOUNDING_BOX_WIDTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFitBoundingBoxWidth(OperationFitBoundingBoxWidthDestinationFitBoundingBoxWidth fitBoundingBoxWidth) {
    this.fitBoundingBoxWidth = fitBoundingBoxWidth;
  }


  public OperationDestinationEvent goToNamed(OperationNamedDestinationGoToNamed goToNamed) {
    
    this.goToNamed = goToNamed;
    return this;
  }

  /**
   * Get goToNamed
   * @return goToNamed
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_GO_TO_NAMED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationNamedDestinationGoToNamed getGoToNamed() {
    return goToNamed;
  }


  @JsonProperty(JSON_PROPERTY_GO_TO_NAMED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGoToNamed(OperationNamedDestinationGoToNamed goToNamed) {
    this.goToNamed = goToNamed;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationDestinationEvent operationDestinationEvent = (OperationDestinationEvent) o;
    return Objects.equals(this.zoomPage, operationDestinationEvent.zoomPage) &&
        Objects.equals(this.fitPage, operationDestinationEvent.fitPage) &&
        Objects.equals(this.fitWidth, operationDestinationEvent.fitWidth) &&
        Objects.equals(this.fitHeight, operationDestinationEvent.fitHeight) &&
        Objects.equals(this.fitRectangle, operationDestinationEvent.fitRectangle) &&
        Objects.equals(this.fitBoundingBox, operationDestinationEvent.fitBoundingBox) &&
        Objects.equals(this.fitBoundingBoxWidth, operationDestinationEvent.fitBoundingBoxWidth) &&
        Objects.equals(this.goToNamed, operationDestinationEvent.goToNamed);
  }

  @Override
  public int hashCode() {
    return Objects.hash(zoomPage, fitPage, fitWidth, fitHeight, fitRectangle, fitBoundingBox, fitBoundingBoxWidth, goToNamed);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationDestinationEvent {\n");
    sb.append("    zoomPage: ").append(toIndentedString(zoomPage)).append("\n");
    sb.append("    fitPage: ").append(toIndentedString(fitPage)).append("\n");
    sb.append("    fitWidth: ").append(toIndentedString(fitWidth)).append("\n");
    sb.append("    fitHeight: ").append(toIndentedString(fitHeight)).append("\n");
    sb.append("    fitRectangle: ").append(toIndentedString(fitRectangle)).append("\n");
    sb.append("    fitBoundingBox: ").append(toIndentedString(fitBoundingBox)).append("\n");
    sb.append("    fitBoundingBoxWidth: ").append(toIndentedString(fitBoundingBoxWidth)).append("\n");
    sb.append("    goToNamed: ").append(toIndentedString(goToNamed)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
