/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 9.0.0.3479 (2024-07-23T08:38:02Z) 
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * OpenID configuration provider metadata
 */
@Schema(description = "OpenID configuration provider metadata")
@JsonPropertyOrder({
  OAuthOIDCMetadata.JSON_PROPERTY_AUTHORIZATION_ENDPOINT,
  OAuthOIDCMetadata.JSON_PROPERTY_CLAIMS_SUPPORTED,
  OAuthOIDCMetadata.JSON_PROPERTY_GRANT_TYPES_SUPPORTED,
  OAuthOIDCMetadata.JSON_PROPERTY_ID_TOKEN_SIGNING_ALG_VALUES_SUPPORTED,
  OAuthOIDCMetadata.JSON_PROPERTY_ISSUER,
  OAuthOIDCMetadata.JSON_PROPERTY_JWKS_URI,
  OAuthOIDCMetadata.JSON_PROPERTY_RESPONSE_TYPES_SUPPORTED,
  OAuthOIDCMetadata.JSON_PROPERTY_SCOPES_SUPPORTED,
  OAuthOIDCMetadata.JSON_PROPERTY_SUBJECT_TYPES_SUPPORTED,
  OAuthOIDCMetadata.JSON_PROPERTY_TOKEN_ENDPOINT,
  OAuthOIDCMetadata.JSON_PROPERTY_USERINFO_ENDPOINT
})
@JsonTypeName("OAuth_OIDCMetadata")

public class OAuthOIDCMetadata {
  public static final String JSON_PROPERTY_AUTHORIZATION_ENDPOINT = "authorization_endpoint";
  private String authorizationEndpoint = "";

  public static final String JSON_PROPERTY_CLAIMS_SUPPORTED = "claims_supported";
  private List<String> claimsSupported = null;

  public static final String JSON_PROPERTY_GRANT_TYPES_SUPPORTED = "grant_types_supported";
  private List<String> grantTypesSupported = null;

  public static final String JSON_PROPERTY_ID_TOKEN_SIGNING_ALG_VALUES_SUPPORTED = "id_token_signing_alg_values_supported";
  private List<String> idTokenSigningAlgValuesSupported = new ArrayList<>();

  public static final String JSON_PROPERTY_ISSUER = "issuer";
  private String issuer = "";

  public static final String JSON_PROPERTY_JWKS_URI = "jwks_uri";
  private String jwksUri = "";

  public static final String JSON_PROPERTY_RESPONSE_TYPES_SUPPORTED = "response_types_supported";
  private List<String> responseTypesSupported = new ArrayList<>();

  public static final String JSON_PROPERTY_SCOPES_SUPPORTED = "scopes_supported";
  private List<String> scopesSupported = null;

  public static final String JSON_PROPERTY_SUBJECT_TYPES_SUPPORTED = "subject_types_supported";
  private List<String> subjectTypesSupported = new ArrayList<>();

  public static final String JSON_PROPERTY_TOKEN_ENDPOINT = "token_endpoint";
  private String tokenEndpoint = "";

  public static final String JSON_PROPERTY_USERINFO_ENDPOINT = "userinfo_endpoint";
  private String userinfoEndpoint = "";

  public OAuthOIDCMetadata() {
  }

  public OAuthOIDCMetadata authorizationEndpoint(String authorizationEndpoint) {
    
    this.authorizationEndpoint = authorizationEndpoint;
    return this;
  }

  /**
   * Get authorizationEndpoint
   * @return authorizationEndpoint
   **/
  @NotNull
  @Schema(required = true, name = "")
  @JsonProperty(JSON_PROPERTY_AUTHORIZATION_ENDPOINT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAuthorizationEndpoint() {
    return authorizationEndpoint;
  }


  @JsonProperty(JSON_PROPERTY_AUTHORIZATION_ENDPOINT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAuthorizationEndpoint(String authorizationEndpoint) {
    this.authorizationEndpoint = authorizationEndpoint;
  }


  public OAuthOIDCMetadata claimsSupported(List<String> claimsSupported) {
    
    this.claimsSupported = claimsSupported;
    return this;
  }

  public OAuthOIDCMetadata addClaimsSupportedItem(String claimsSupportedItem) {
    if (this.claimsSupported == null) {
      this.claimsSupported = new ArrayList<>();
    }
    this.claimsSupported.add(claimsSupportedItem);
    return this;
  }

  /**
   * Get claimsSupported
   * @return claimsSupported
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_CLAIMS_SUPPORTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getClaimsSupported() {
    return claimsSupported;
  }


  @JsonProperty(JSON_PROPERTY_CLAIMS_SUPPORTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClaimsSupported(List<String> claimsSupported) {
    this.claimsSupported = claimsSupported;
  }


  public OAuthOIDCMetadata grantTypesSupported(List<String> grantTypesSupported) {
    
    this.grantTypesSupported = grantTypesSupported;
    return this;
  }

  public OAuthOIDCMetadata addGrantTypesSupportedItem(String grantTypesSupportedItem) {
    if (this.grantTypesSupported == null) {
      this.grantTypesSupported = new ArrayList<>();
    }
    this.grantTypesSupported.add(grantTypesSupportedItem);
    return this;
  }

  /**
   * Get grantTypesSupported
   * @return grantTypesSupported
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_GRANT_TYPES_SUPPORTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getGrantTypesSupported() {
    return grantTypesSupported;
  }


  @JsonProperty(JSON_PROPERTY_GRANT_TYPES_SUPPORTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGrantTypesSupported(List<String> grantTypesSupported) {
    this.grantTypesSupported = grantTypesSupported;
  }


  public OAuthOIDCMetadata idTokenSigningAlgValuesSupported(List<String> idTokenSigningAlgValuesSupported) {
    
    this.idTokenSigningAlgValuesSupported = idTokenSigningAlgValuesSupported;
    return this;
  }

  public OAuthOIDCMetadata addIdTokenSigningAlgValuesSupportedItem(String idTokenSigningAlgValuesSupportedItem) {
    this.idTokenSigningAlgValuesSupported.add(idTokenSigningAlgValuesSupportedItem);
    return this;
  }

  /**
   * Get idTokenSigningAlgValuesSupported
   * @return idTokenSigningAlgValuesSupported
   **/
  @NotNull
  @Schema(required = true, name = "")
  @JsonProperty(JSON_PROPERTY_ID_TOKEN_SIGNING_ALG_VALUES_SUPPORTED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getIdTokenSigningAlgValuesSupported() {
    return idTokenSigningAlgValuesSupported;
  }


  @JsonProperty(JSON_PROPERTY_ID_TOKEN_SIGNING_ALG_VALUES_SUPPORTED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdTokenSigningAlgValuesSupported(List<String> idTokenSigningAlgValuesSupported) {
    this.idTokenSigningAlgValuesSupported = idTokenSigningAlgValuesSupported;
  }


  public OAuthOIDCMetadata issuer(String issuer) {
    
    this.issuer = issuer;
    return this;
  }

  /**
   * Get issuer
   * @return issuer
   **/
  @NotNull
  @Schema(required = true, name = "")
  @JsonProperty(JSON_PROPERTY_ISSUER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getIssuer() {
    return issuer;
  }


  @JsonProperty(JSON_PROPERTY_ISSUER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIssuer(String issuer) {
    this.issuer = issuer;
  }


  public OAuthOIDCMetadata jwksUri(String jwksUri) {
    
    this.jwksUri = jwksUri;
    return this;
  }

  /**
   * Get jwksUri
   * @return jwksUri
   **/
  @NotNull
  @Schema(required = true, name = "")
  @JsonProperty(JSON_PROPERTY_JWKS_URI)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getJwksUri() {
    return jwksUri;
  }


  @JsonProperty(JSON_PROPERTY_JWKS_URI)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setJwksUri(String jwksUri) {
    this.jwksUri = jwksUri;
  }


  public OAuthOIDCMetadata responseTypesSupported(List<String> responseTypesSupported) {
    
    this.responseTypesSupported = responseTypesSupported;
    return this;
  }

  public OAuthOIDCMetadata addResponseTypesSupportedItem(String responseTypesSupportedItem) {
    this.responseTypesSupported.add(responseTypesSupportedItem);
    return this;
  }

  /**
   * Get responseTypesSupported
   * @return responseTypesSupported
   **/
  @NotNull
  @Schema(required = true, name = "")
  @JsonProperty(JSON_PROPERTY_RESPONSE_TYPES_SUPPORTED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getResponseTypesSupported() {
    return responseTypesSupported;
  }


  @JsonProperty(JSON_PROPERTY_RESPONSE_TYPES_SUPPORTED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setResponseTypesSupported(List<String> responseTypesSupported) {
    this.responseTypesSupported = responseTypesSupported;
  }


  public OAuthOIDCMetadata scopesSupported(List<String> scopesSupported) {
    
    this.scopesSupported = scopesSupported;
    return this;
  }

  public OAuthOIDCMetadata addScopesSupportedItem(String scopesSupportedItem) {
    if (this.scopesSupported == null) {
      this.scopesSupported = new ArrayList<>();
    }
    this.scopesSupported.add(scopesSupportedItem);
    return this;
  }

  /**
   * Get scopesSupported
   * @return scopesSupported
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_SCOPES_SUPPORTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getScopesSupported() {
    return scopesSupported;
  }


  @JsonProperty(JSON_PROPERTY_SCOPES_SUPPORTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setScopesSupported(List<String> scopesSupported) {
    this.scopesSupported = scopesSupported;
  }


  public OAuthOIDCMetadata subjectTypesSupported(List<String> subjectTypesSupported) {
    
    this.subjectTypesSupported = subjectTypesSupported;
    return this;
  }

  public OAuthOIDCMetadata addSubjectTypesSupportedItem(String subjectTypesSupportedItem) {
    this.subjectTypesSupported.add(subjectTypesSupportedItem);
    return this;
  }

  /**
   * Get subjectTypesSupported
   * @return subjectTypesSupported
   **/
  @NotNull
  @Schema(required = true, name = "")
  @JsonProperty(JSON_PROPERTY_SUBJECT_TYPES_SUPPORTED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getSubjectTypesSupported() {
    return subjectTypesSupported;
  }


  @JsonProperty(JSON_PROPERTY_SUBJECT_TYPES_SUPPORTED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSubjectTypesSupported(List<String> subjectTypesSupported) {
    this.subjectTypesSupported = subjectTypesSupported;
  }


  public OAuthOIDCMetadata tokenEndpoint(String tokenEndpoint) {
    
    this.tokenEndpoint = tokenEndpoint;
    return this;
  }

  /**
   * Get tokenEndpoint
   * @return tokenEndpoint
   **/
  @NotNull
  @Schema(required = true, name = "")
  @JsonProperty(JSON_PROPERTY_TOKEN_ENDPOINT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTokenEndpoint() {
    return tokenEndpoint;
  }


  @JsonProperty(JSON_PROPERTY_TOKEN_ENDPOINT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTokenEndpoint(String tokenEndpoint) {
    this.tokenEndpoint = tokenEndpoint;
  }


  public OAuthOIDCMetadata userinfoEndpoint(String userinfoEndpoint) {
    
    this.userinfoEndpoint = userinfoEndpoint;
    return this;
  }

  /**
   * Get userinfoEndpoint
   * @return userinfoEndpoint
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_USERINFO_ENDPOINT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUserinfoEndpoint() {
    return userinfoEndpoint;
  }


  @JsonProperty(JSON_PROPERTY_USERINFO_ENDPOINT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserinfoEndpoint(String userinfoEndpoint) {
    this.userinfoEndpoint = userinfoEndpoint;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OAuthOIDCMetadata oauthOIDCMetadata = (OAuthOIDCMetadata) o;
    return Objects.equals(this.authorizationEndpoint, oauthOIDCMetadata.authorizationEndpoint) &&
        Objects.equals(this.claimsSupported, oauthOIDCMetadata.claimsSupported) &&
        Objects.equals(this.grantTypesSupported, oauthOIDCMetadata.grantTypesSupported) &&
        Objects.equals(this.idTokenSigningAlgValuesSupported, oauthOIDCMetadata.idTokenSigningAlgValuesSupported) &&
        Objects.equals(this.issuer, oauthOIDCMetadata.issuer) &&
        Objects.equals(this.jwksUri, oauthOIDCMetadata.jwksUri) &&
        Objects.equals(this.responseTypesSupported, oauthOIDCMetadata.responseTypesSupported) &&
        Objects.equals(this.scopesSupported, oauthOIDCMetadata.scopesSupported) &&
        Objects.equals(this.subjectTypesSupported, oauthOIDCMetadata.subjectTypesSupported) &&
        Objects.equals(this.tokenEndpoint, oauthOIDCMetadata.tokenEndpoint) &&
        Objects.equals(this.userinfoEndpoint, oauthOIDCMetadata.userinfoEndpoint);
  }

  @Override
  public int hashCode() {
    return Objects.hash(authorizationEndpoint, claimsSupported, grantTypesSupported, idTokenSigningAlgValuesSupported, issuer, jwksUri, responseTypesSupported, scopesSupported, subjectTypesSupported, tokenEndpoint, userinfoEndpoint);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OAuthOIDCMetadata {\n");
    sb.append("    authorizationEndpoint: ").append(toIndentedString(authorizationEndpoint)).append("\n");
    sb.append("    claimsSupported: ").append(toIndentedString(claimsSupported)).append("\n");
    sb.append("    grantTypesSupported: ").append(toIndentedString(grantTypesSupported)).append("\n");
    sb.append("    idTokenSigningAlgValuesSupported: ").append(toIndentedString(idTokenSigningAlgValuesSupported)).append("\n");
    sb.append("    issuer: ").append(toIndentedString(issuer)).append("\n");
    sb.append("    jwksUri: ").append(toIndentedString(jwksUri)).append("\n");
    sb.append("    responseTypesSupported: ").append(toIndentedString(responseTypesSupported)).append("\n");
    sb.append("    scopesSupported: ").append(toIndentedString(scopesSupported)).append("\n");
    sb.append("    subjectTypesSupported: ").append(toIndentedString(subjectTypesSupported)).append("\n");
    sb.append("    tokenEndpoint: ").append(toIndentedString(tokenEndpoint)).append("\n");
    sb.append("    userinfoEndpoint: ").append(toIndentedString(userinfoEndpoint)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
